/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.TemporaryFiles;
import net.lecousin.framework.io.buffering.ByteBuffersIO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.mutable.Mutable;
import net.lecousin.framework.mutable.MutableInteger;
import net.lecousin.framework.mutable.MutableLong;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.text.CharArrayStringBuffer;
import net.lecousin.framework.util.Pair;

public final class IOUtil {
    private static final String READING_FROM = "Reading from ";

    private IOUtil() {
    }

    public static int readFully(IO.Readable io, ByteBuffer buffer) throws IOException {
        int nb;
        int read = 0;
        while (buffer.hasRemaining() && (nb = io.readSync(buffer)) > 0) {
            read += nb;
        }
        return read;
    }

    public static int readFully(IO.ReadableByteStream io, byte[] buffer) throws IOException {
        return IOUtil.readFully(io, buffer, 0, buffer.length);
    }

    public static int readFully(IO.ReadableByteStream io, byte[] buffer, int off, int len) throws IOException {
        int read;
        int nb;
        for (read = 0; read < len && (nb = io.read(buffer, off + read, len - read)) > 0; read += nb) {
        }
        return read;
    }

    public static void readFully(IO.Readable io, AsyncSupplier<byte[], IOException> result) {
        if (io instanceof IO.KnownSize) {
            IOUtil.readFullyKnownSize((IO.Readable)((Object)((IO.KnownSize)((Object)io))), result);
            return;
        }
        AsyncSupplier<ByteBuffersIO, IOException> read = IOUtil.readFullyAsync(io, 65536);
        read.thenStart("readFully: convert ByteArraysIO into byte[]", io.getPriority(), () -> result.unblockSuccess(((ByteBuffersIO)read.getResult()).createSingleByteArray()), result);
    }

    public static <T extends IO.Readable & IO.KnownSize> void readFullyKnownSize(T io, AsyncSupplier<byte[], IOException> result) {
        AsyncSupplier<Long, IOException> getSize = ((IO.KnownSize)io).getSizeAsync();
        getSize.thenDoOrStart("readFully", io.getPriority(), size -> {
            if (size > Integer.MAX_VALUE) {
                result.error(new IOException("IO too large to be read into memory"));
                return;
            }
            IOUtil.readFullyKnownSize(io, size.intValue(), result);
        }, result);
    }

    public static void readFullyKnownSize(IO.Readable io, int size, AsyncSupplier<byte[], IOException> result) {
        byte[] bytes;
        try {
            bytes = (byte[])ByteArrayCache.getInstance().get(size, false);
        }
        catch (Exception t) {
            result.error(IO.error(t));
            return;
        }
        IOUtil.readFullyAsync(io, ByteBuffer.wrap(bytes), r -> {
            if (r.getValue2() != null) {
                result.error((IOException)((Exception)r.getValue2()));
            } else {
                result.unblockSuccess(bytes);
            }
        });
    }

    public static int readFullySync(IO.Readable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        int nb;
        int read = 0;
        while (buffer.hasRemaining() && (nb = io.readSync(pos, buffer)) > 0) {
            read += nb;
            pos += (long)nb;
        }
        return read;
    }

    public static AsyncSupplier<Integer, IOException> readFullyAsync(IO.Readable io, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(io, buffer, 0, ondone);
    }

    public static AsyncSupplier<Integer, IOException> readFullyAsync(IO.Readable io, ByteBuffer buffer, int done, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> read = io.readAsync(buffer);
        if (!read.isDone()) {
            return IOUtil.readFullyAsync(read, io, buffer, done, ondone);
        }
        if (!read.isSuccessful()) {
            if (ondone != null && read.getError() != null) {
                ondone.accept(new Pair<Object, IOException>(null, read.getError()));
            }
            return read;
        }
        if (!buffer.hasRemaining()) {
            if (done == 0) {
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>(read.getResult(), null));
                }
                return read;
            }
            if (read.getResult() <= 0) {
                return IOUtil.success(done, ondone);
            }
            return IOUtil.success(read.getResult() + done, ondone);
        }
        if (read.getResult() <= 0) {
            if (done == 0) {
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>(read.getResult(), null));
                }
                return read;
            }
            return IOUtil.success(done, ondone);
        }
        return IOUtil.readFullyAsync(io, buffer, read.getResult() + done, ondone);
    }

    private static AsyncSupplier<Integer, IOException> readFullyAsync(AsyncSupplier<Integer, IOException> read, IO.Readable io, ByteBuffer buffer, int done, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> sp = new AsyncSupplier<Integer, IOException>();
        MutableInteger total = new MutableInteger(done);
        Mutable<AsyncSupplier<Integer, IOException>> r = new Mutable<AsyncSupplier<Integer, IOException>>(read);
        read.listen(new RecursiveAsyncSupplierListener<Integer>((result, that) -> {
            while (true) {
                if (!buffer.hasRemaining() || result <= 0) {
                    if (total.get() == 0) {
                        IOUtil.success(result, sp, ondone);
                    } else if (result >= 0) {
                        IOUtil.success(result + total.get(), sp, ondone);
                    } else {
                        IOUtil.success(total.get(), sp, ondone);
                    }
                    return;
                }
                total.add((int)result);
                AsyncSupplier<Integer, IOException> reading = io.readAsync(buffer);
                r.set(reading);
                if (!reading.isSuccessful()) break;
                result = reading.getResult();
            }
            ((AsyncSupplier)r.get()).listen(that);
        }, sp, ondone));
        sp.onCancel(cancel -> ((AsyncSupplier)r.get()).unblockCancel((CancelException)cancel));
        return sp;
    }

    public static AsyncSupplier<Integer, IOException> readFullyAsync(IO.Readable.Seekable io, long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> read = io.readAsync(pos, buffer);
        if (read.isDone()) {
            if (!read.isSuccessful()) {
                if (ondone != null && read.getError() != null) {
                    ondone.accept(new Pair<Object, IOException>(null, read.getError()));
                }
                return read;
            }
            if (!buffer.hasRemaining()) {
                if (ondone != null && read.getResult() != null) {
                    ondone.accept(new Pair<Integer, Object>(read.getResult(), null));
                }
                return read;
            }
            if (read.getResult() <= 0) {
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>(read.getResult(), null));
                }
                return read;
            }
        }
        return IOUtil.readFullyAsync(read, io, pos, buffer, ondone);
    }

    private static AsyncSupplier<Integer, IOException> readFullyAsync(AsyncSupplier<Integer, IOException> read, IO.Readable.Seekable io, long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> sp = new AsyncSupplier<Integer, IOException>();
        MutableInteger total = new MutableInteger(0);
        Mutable<AsyncSupplier<Integer, IOException>> r = new Mutable<AsyncSupplier<Integer, IOException>>(read);
        read.listen(new RecursiveAsyncSupplierListener<Integer>((result, that) -> {
            while (true) {
                if (!buffer.hasRemaining() || result <= 0) {
                    if (total.get() == 0) {
                        IOUtil.success(result, sp, ondone);
                    } else if (result >= 0) {
                        IOUtil.success(result + total.get(), sp, ondone);
                    } else {
                        IOUtil.success(total.get(), sp, ondone);
                    }
                    return;
                }
                total.add((int)result);
                AsyncSupplier<Integer, IOException> reading = io.readAsync(pos + (long)total.get(), buffer);
                r.set(reading);
                if (!reading.isSuccessful()) break;
                result = reading.getResult();
            }
            ((AsyncSupplier)r.get()).listen(that);
        }, sp, ondone));
        sp.onCancel(cancel -> ((AsyncSupplier)r.get()).unblockCancel((CancelException)cancel));
        return sp;
    }

    public static AsyncSupplier<ByteBuffersIO, IOException> readFullyAsync(IO.Readable io, int bufferSize) {
        ByteBuffersIO bb = new ByteBuffersIO(false, io.getSourceDescription(), io.getPriority());
        AsyncSupplier<ByteBuffersIO, IOException> result = new AsyncSupplier<ByteBuffersIO, IOException>();
        IOUtil.readFullyAsync(io, bufferSize, bb, ByteArrayCache.getInstance(), result);
        return result;
    }

    private static void readFullyAsync(IO.Readable io, int bufferSize, ByteBuffersIO bb, ByteArrayCache cache, AsyncSupplier<ByteBuffersIO, IOException> result) {
        byte[] buffer = (byte[])cache.get(bufferSize, true);
        AsyncSupplier<Integer, IOException> read = io.readFullyAsync(ByteBuffer.wrap(buffer));
        read.thenStart("readFully", io.getPriority(), t -> {
            int nb = (Integer)read.getResult();
            if (nb > 0) {
                bb.addBuffer(new ByteArray.Writable(buffer, 0, nb, true));
            }
            if (nb < bufferSize) {
                result.unblockSuccess(bb);
            } else {
                IOUtil.readFullyAsync(io, bufferSize, bb, cache, result);
            }
            return null;
        }, result);
    }

    public static AsyncSupplier<Integer, IOException> readAsyncUsingSync(IO.Readable io, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return Task.cpu(READING_FROM + io.getSourceDescription(), io.getPriority(), t -> io.readSync(buffer), ondone).start().getOutput();
    }

    public static AsyncSupplier<Integer, IOException> readAsyncUsingSync(IO.Readable.Seekable io, long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return Task.cpu(READING_FROM + io.getSourceDescription(), io.getPriority(), t -> io.readSync(pos, buffer), ondone).start().getOutput();
    }

    public static AsyncSupplier<Integer, IOException> readFullyAsyncUsingSync(IO.Readable io, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return Task.cpu(READING_FROM + io.getSourceDescription(), io.getPriority(), t -> io.readFullySync(buffer), ondone).start().getOutput();
    }

    public static AsyncSupplier<Integer, IOException> readFullyAsyncUsingSync(IO.Readable.Seekable io, long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return Task.cpu(READING_FROM + io.getSourceDescription(), io.getPriority(), t -> io.readFullySync(pos, buffer), ondone).start().getOutput();
    }

    public static long skipSyncByReading(IO.Readable io, long n) throws IOException {
        long total;
        int nb;
        if (n <= 0L) {
            return 0L;
        }
        int l = n > 65536L ? 65536 : (int)n;
        ByteBuffer b = ByteBuffer.allocate(l);
        for (total = 0L; total < n; total += (long)nb) {
            int len = n - total > (long)l ? l : (int)(n - total);
            b.clear();
            b.limit(len);
            nb = io.readSync(b);
            if (nb <= 0) break;
        }
        return total;
    }

    public static AsyncSupplier<Long, IOException> skipAsyncUsingSync(IO.Readable io, long n, Consumer<Pair<Long, IOException>> ondone) {
        return Task.cpu("Skipping bytes", io.getPriority(), t -> IOUtil.skipSyncByReading(io, n), ondone).start().getOutput();
    }

    public static AsyncSupplier<Long, IOException> skipAsyncByReading(IO.Readable io, long n, Consumer<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            if (ondone != null) {
                ondone.accept(new Pair<Long, Object>(0L, null));
            }
            return new AsyncSupplier<Long, Object>(0L, null);
        }
        ByteBuffer b = ByteBuffer.allocate(n > 65536L ? 65536 : (int)n);
        MutableLong done = new MutableLong(0L);
        AsyncSupplier<Long, IOException> result = new AsyncSupplier<Long, IOException>();
        io.readAsync(b).listen(new RecursiveAsyncSupplierListener<Integer>((nb, that) -> {
            AsyncSupplier<Integer, IOException> next;
            while (true) {
                int read;
                if ((read = nb.intValue()) <= 0) {
                    IOUtil.success(done.get(), result, ondone);
                    return;
                }
                done.add(nb.intValue());
                if (done.get() == n) {
                    IOUtil.success(n, result, ondone);
                    return;
                }
                b.clear();
                if (n - done.get() < (long)b.remaining()) {
                    b.limit((int)(n - done.get()));
                }
                if (!(next = io.readAsync(b)).isSuccessful()) break;
                nb = next.getResult();
            }
            next.listen(that);
        }, result, ondone));
        return result;
    }

    public static AsyncSupplier<File, IOException> toTempFile(IO.Readable io) {
        IO.Readable.Buffered bio = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new SimpleBufferedReadable(io, 65536);
        AsyncSupplier<FileIO.ReadWrite, IOException> createFile = TemporaryFiles.get().createAndOpenFileAsync("net.lecousin.framework.io", "streamtofile");
        AsyncSupplier<File, IOException> result = new AsyncSupplier<File, IOException>();
        createFile.onDone(() -> {
            File file = ((FileIO.ReadWrite)createFile.getResult()).getFile();
            IOUtil.copy(bio, (IO.Writable)createFile.getResult(), -1L, true, null, 0L).onDone(() -> result.unblockSuccess(file), (IAsync<IOException>)result);
        }, result);
        return result;
    }

    public static AsyncSupplier<File, IOException> toTempFile(byte[] bytes) {
        AsyncSupplier<FileIO.ReadWrite, IOException> createFile = TemporaryFiles.get().createAndOpenFileAsync("net.lecousin.framework.io", "bytestofile");
        AsyncSupplier<File, IOException> result = new AsyncSupplier<File, IOException>();
        createFile.onDone(() -> {
            File file = ((FileIO.ReadWrite)createFile.getResult()).getFile();
            ((FileIO.ReadWrite)createFile.getResult()).writeAsync(ByteBuffer.wrap(bytes)).onDone(() -> {
                try {
                    ((FileIO.ReadWrite)createFile.getResult()).close();
                    result.unblockSuccess(file);
                }
                catch (Exception e) {
                    result.error(IO.error(e));
                }
            });
        }, result);
        return result;
    }

    public static int readSyncUsingAsync(IO.Readable io, ByteBuffer buffer) throws IOException {
        AsyncSupplier<Integer, IOException> sp = io.readAsync(buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static int readSyncUsingAsync(IO.Readable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        AsyncSupplier<Integer, IOException> sp = io.readAsync(pos, buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static int readFullySyncUsingAsync(IO.Readable io, ByteBuffer buffer) throws IOException {
        AsyncSupplier<Integer, IOException> sp = io.readFullyAsync(buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static int readFullySyncUsingAsync(IO.Readable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        AsyncSupplier<Integer, IOException> sp = io.readFullyAsync(pos, buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static long skipSyncUsingAsync(IO.Readable io, long n) throws IOException {
        AsyncSupplier<Long, IOException> sp = io.skipAsync(n);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static int writeSyncUsingAsync(IO.Writable io, ByteBuffer buffer) throws IOException {
        AsyncSupplier<Integer, IOException> sp = io.writeAsync(buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static int writeSyncUsingAsync(IO.Writable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        AsyncSupplier<Integer, IOException> sp = io.writeAsync(pos, buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw IO.errorCancelled(e);
        }
    }

    public static AsyncSupplier<Integer, IOException> writeAsyncUsingSync(IO.Writable io, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return Task.cpu("Writing to " + io.getSourceDescription(), io.getPriority(), t -> io.writeSync(buffer), ondone).start().getOutput();
    }

    public static AsyncSupplier<Integer, IOException> writeAsyncUsingSync(IO.Writable.Seekable io, long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return Task.cpu("Writing to " + io.getSourceDescription(), io.getPriority(), t -> io.writeSync(pos, buffer), ondone).start().getOutput();
    }

    public static AsyncSupplier<CharArrayStringBuffer, IOException> readFullyAsString(IO.Readable io, Charset charset, Task.Priority priority) {
        AsyncSupplier<CharArrayStringBuffer, IOException> result = new AsyncSupplier<CharArrayStringBuffer, IOException>();
        if (io instanceof IO.KnownSize) {
            ((IO.KnownSize)((Object)io)).getSizeAsync().onDone(size -> Task.cpu("Prepare readFullyAsString", priority, t -> {
                byte[] buf = new byte[size.intValue()];
                io.readFullyAsync(ByteBuffer.wrap(buf)).thenStart(Task.cpu("readFullyAsString", priority, t2 -> {
                    try {
                        result.unblockSuccess(new CharArrayStringBuffer(charset.newDecoder().decode(ByteBuffer.wrap(buf))));
                    }
                    catch (IOException e) {
                        result.error(e);
                    }
                    return null;
                }), result);
                return null;
            }).start(), result);
            return result;
        }
        Task.cpu("Read file as string: " + io.getSourceDescription(), priority, t -> {
            BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream(io, charset, 1024, 128);
            CharArrayStringBuffer str = new CharArrayStringBuffer();
            IOUtil.readFullyAsString(stream, str, result, priority);
            return null;
        }).startOn(io.canStartReading(), true);
        return result;
    }

    private static void readFullyAsString(BufferedReadableCharacterStream stream, CharArrayStringBuffer str, AsyncSupplier<CharArrayStringBuffer, IOException> result, Task.Priority priority) {
        AsyncSupplier<Chars.Readable, IOException> read;
        while ((read = stream.readNextBufferAsync()).isDone()) {
            if (read.hasError()) {
                result.error(read.getError());
                return;
            }
            if (read.getResult() == null) {
                result.unblockSuccess(str);
                return;
            }
            read.getResult().get(str, read.getResult().remaining());
        }
        read.thenStart("readFullyAsString: " + stream.getDescription(), priority, t -> {
            if (read.getResult() == null) {
                result.unblockSuccess(str);
                return null;
            }
            ((Chars.Readable)read.getResult()).get(str, ((Chars.Readable)read.getResult()).remaining());
            IOUtil.readFullyAsString(stream, str, result, priority);
            return null;
        }, result);
    }

    public static void readFullyAsStringSync(IO.Readable io, Charset charset, StringBuilder s) throws IOException {
        int nb;
        byte[] buf = new byte[1024];
        while ((nb = io.readFullySync(ByteBuffer.wrap(buf))) > 0) {
            s.append(new String(buf, 0, nb, charset));
            if (nb >= 1024) continue;
            break;
        }
    }

    public static void readFullyAsStringSync(InputStream input, Charset charset, StringBuilder s) throws IOException {
        int nb;
        byte[] buf = new byte[1024];
        while ((nb = input.read(buf)) > 0) {
            s.append(new String(buf, 0, nb, charset));
            if (nb >= 1024) continue;
            break;
        }
    }

    public static String readFullyAsStringSync(IO.Readable io, Charset charset) throws IOException {
        if (io instanceof IO.KnownSize) {
            byte[] bytes = new byte[(int)((IO.KnownSize)((Object)io)).getSizeSync()];
            io.readFullySync(ByteBuffer.wrap(bytes));
            return new String(bytes, charset);
        }
        StringBuilder s = new StringBuilder(1024);
        IOUtil.readFullyAsStringSync(io, charset, s);
        return s.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFullyAsStringSync(File file, Charset charset) throws IOException {
        try (FileIO.ReadOnly io = new FileIO.ReadOnly(file, Task.Priority.RATHER_IMPORTANT);){
            String string = IOUtil.readFullyAsStringSync(io, charset);
            return string;
        }
        catch (Exception e) {
            throw IO.error(e);
        }
    }

    public static String readFullyAsStringSync(InputStream input, Charset charset) throws IOException {
        StringBuilder s = new StringBuilder(1024);
        IOUtil.readFullyAsStringSync(input, charset, s);
        return s.toString();
    }

    public static AsyncSupplier<Long, IOException> seekAsyncUsingSync(IO.Seekable io, IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return Task.cpu("Seeking", io.getPriority(), t -> io.seekSync(type, move), ondone).start().getOutput();
    }

    public static long seekSyncUsingAsync(IO.Seekable io, IO.Seekable.SeekType type, long move) throws IOException {
        AsyncSupplier<Long, IOException> seek = io.seekAsync(type, move);
        seek.blockException(0L);
        return seek.getResult();
    }

    public static IAsync<IOException> setSizeAsyncUsingSync(IO.Resizable io, long newSize, Task.Priority priority) {
        return Task.cpu("Resizing " + io.getSourceDescription(), priority, t -> {
            io.setSizeSync(newSize);
            return null;
        }).start().getOutput();
    }

    public static AsyncSupplier<Long, IOException> copy(IO.Readable input, IO.Writable output, long size, boolean closeIOs, WorkProgress progress, long work) {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        IOUtil.copy(input, output, size, closeIOs, sp, progress, work);
        return sp;
    }

    private static void copy(IO.Readable input, IO.Writable output, long size, boolean closeIOs, AsyncSupplier<Long, IOException> sp, WorkProgress progress, long work) {
        TaskManager tmOut;
        if (size == 0L) {
            if (progress != null) {
                progress.progress(work);
            }
            IOUtil.copyEnd(input, output, sp, null, null, closeIOs, 0L);
            return;
        }
        if (size < 0L) {
            if (input instanceof IO.KnownSize) {
                AsyncSupplier<Long, IOException> getSize = ((IO.KnownSize)((Object)input)).getSizeAsync();
                getSize.onDone(() -> {
                    if (getSize.hasError()) {
                        IOUtil.copyEnd(input, output, sp, (IOException)getSize.getError(), null, closeIOs, 0L);
                    } else if (getSize.isCancelled()) {
                        IOUtil.copyEnd(input, output, sp, null, getSize.getCancelEvent(), closeIOs, 0L);
                    } else {
                        IOUtil.copy(input, output, (Long)getSize.getResult(), closeIOs, sp, progress, work);
                    }
                });
                return;
            }
            IOUtil.copyUnknownSize(input, output, closeIOs, sp, progress, work);
            return;
        }
        if (size <= 262144L) {
            IOUtil.copySameTM(input, output, (int)size, size, sp, closeIOs, progress, work);
            return;
        }
        TaskManager tmIn = IOUtil.getUnderlyingTaskManager(input);
        if (tmIn == (tmOut = IOUtil.getUnderlyingTaskManager(output))) {
            if (size <= 0x400000L) {
                IOUtil.copySameTM(input, output, (int)size, size, sp, closeIOs, progress, work);
                return;
            }
            if (size <= 0x800000L) {
                IOUtil.copySameTM(input, output, (int)(size / 2L + 1L), size, sp, closeIOs, progress, work);
                return;
            }
            IOUtil.copySameTM(input, output, 0x400000, size, sp, closeIOs, progress, work);
            return;
        }
        if (input instanceof IO.Readable.Buffered) {
            IOUtil.copyStep((IO.Readable.Buffered)input, output, sp, 0L, closeIOs, progress, work);
            return;
        }
        PreBufferedReadable binput = size <= 0x100000L ? new PreBufferedReadable(input, size, 65536, input.getPriority(), 131072, input.getPriority(), 6) : (size <= 0x1000000L ? new PreBufferedReadable(input, size, 131072, input.getPriority(), 524288, input.getPriority(), 8) : new PreBufferedReadable(input, size, 262144, input.getPriority(), 0x200000, input.getPriority(), 5));
        IOUtil.copyStep(binput, output, sp, 0L, closeIOs, progress, work);
    }

    private static void copyUnknownSize(IO.Readable input, IO.Writable output, boolean closeIOs, AsyncSupplier<Long, IOException> sp, WorkProgress progress, long work) {
        TaskManager tmOut;
        TaskManager tmIn = IOUtil.getUnderlyingTaskManager(input);
        if (tmIn == (tmOut = IOUtil.getUnderlyingTaskManager(output))) {
            IOUtil.copySameTM(input, output, 0x200000, -1L, sp, closeIOs, progress, work);
            return;
        }
        if (input instanceof IO.Readable.Buffered) {
            IOUtil.copyStep((IO.Readable.Buffered)input, output, sp, 0L, closeIOs, progress, work);
            return;
        }
        PreBufferedReadable binput = new PreBufferedReadable(input, 65536, input.getPriority(), 0x100000, input.getPriority(), 16);
        IOUtil.copyStep(binput, output, sp, 0L, closeIOs, progress, work);
    }

    private static void copyEnd(IO.Readable input, IO.Writable output, AsyncSupplier<Long, IOException> sp, IOException error, CancelException cancel, boolean closeIOs, long written) {
        if (!closeIOs) {
            if (error != null) {
                sp.error(error);
            } else if (cancel != null) {
                sp.cancel(cancel);
            } else {
                sp.unblockSuccess(written);
            }
            return;
        }
        IAsync sp1 = input.closeAsync();
        IAsync sp2 = output.closeAsync();
        JoinPoint.from(sp1, sp2).onDone(() -> {
            IOException e = error;
            if (e == null) {
                if (sp1.hasError()) {
                    e = sp1.getError();
                } else if (sp2.hasError()) {
                    e = sp2.getError();
                }
            }
            if (e != null) {
                sp.error(IO.error(e));
                return;
            }
            if (cancel != null) {
                sp.cancel(cancel);
            } else {
                sp.unblockSuccess(written);
            }
        });
    }

    private static void copySameTM(IO.Readable input, IO.Writable output, int bufferSize, long total, AsyncSupplier<Long, IOException> end, boolean closeIOs, WorkProgress progress, long work) {
        Task.cpu("Allocate buffers to copy IOs", input.getPriority(), t -> {
            IOUtil.copySameTMStep(input, output, ByteBuffer.allocate(bufferSize), 0L, total, end, closeIOs, progress, work);
            return null;
        }).start();
    }

    private static void copySameTMStep(final IO.Readable input, final IO.Writable output, final ByteBuffer buf, final long written, final long total, final AsyncSupplier<Long, IOException> end, final boolean closeIOs, final WorkProgress progress, final long work) {
        input.readFullyAsync(buf).listen(new AsyncSupplier.Listener<Integer, IOException>(){

            @Override
            public void ready(Integer result) {
                final int nb = result;
                if (nb <= 0) {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    IOUtil.copyEnd(input, output, end, null, null, closeIOs, written);
                } else {
                    buf.flip();
                    if (progress != null) {
                        progress.progress((long)nb * work / (total * 2L));
                    }
                    AsyncSupplier<Integer, IOException> write = output.writeAsync(buf);
                    write.listen(new AsyncSupplier.Listener<Integer, IOException>(){

                        @Override
                        public void ready(Integer result) {
                            long w;
                            if (progress != null) {
                                w = (long)nb * work / total;
                                progress.progress(w - (long)nb * work / (total * 2L));
                                w = work - w;
                            } else {
                                w = 0L;
                            }
                            if (nb < buf.capacity() || total > 0L && total == written + result.longValue()) {
                                IOUtil.copyEnd(input, output, end, null, null, closeIOs, written + result.longValue());
                            } else {
                                buf.clear();
                                IOUtil.copySameTMStep(input, output, buf, written + result.longValue(), total, end, closeIOs, progress, w);
                            }
                        }

                        @Override
                        public void error(IOException error) {
                            IOUtil.copyEnd(input, output, end, error, null, closeIOs, written);
                        }

                        @Override
                        public void cancelled(CancelException event) {
                            IOUtil.copyEnd(input, output, end, null, event, closeIOs, written);
                        }
                    });
                }
            }

            @Override
            public void error(IOException error) {
                IOUtil.copyEnd(input, output, end, error, null, closeIOs, written);
            }

            @Override
            public void cancelled(CancelException event) {
                IOUtil.copyEnd(input, output, end, null, event, closeIOs, written);
            }
        });
    }

    private static void copyStep(IO.Readable.Buffered input, IO.Writable output, AsyncSupplier<Long, IOException> sp, long written, boolean closeIOs, WorkProgress progress, long work) {
        AsyncSupplier<ByteBuffer, IOException> read = input.readNextBufferAsync();
        read.onDone(() -> {
            if (read.hasError()) {
                IOUtil.copyEnd(input, output, sp, (IOException)read.getError(), null, closeIOs, written);
                return;
            }
            if (read.isCancelled()) {
                IOUtil.copyEnd(input, output, sp, null, read.getCancelEvent(), closeIOs, written);
                return;
            }
            ByteBuffer buf = (ByteBuffer)read.getResult();
            if (buf == null) {
                if (progress != null) {
                    progress.progress(work);
                }
                IOUtil.copyEnd(input, output, sp, null, null, closeIOs, written);
                return;
            }
            if (progress != null && work >= 2L) {
                progress.progress(1L);
            }
            AsyncSupplier<Integer, IOException> write = output.writeAsync(buf);
            write.onDone(() -> {
                if (write.hasError()) {
                    IOUtil.copyEnd(input, output, sp, (IOException)write.getError(), null, closeIOs, written);
                    return;
                }
                if (write.isCancelled()) {
                    IOUtil.copyEnd(input, output, sp, null, write.getCancelEvent(), closeIOs, written);
                    return;
                }
                if (progress != null && work >= 1L) {
                    progress.progress(1L);
                }
                IOUtil.copyStep(input, output, sp, written + (long)((Integer)write.getResult()).intValue(), closeIOs, progress, work - 2L);
            });
        });
    }

    public static <T extends IO.Writable.Seekable & IO.Readable.Seekable> Async<IOException> copy(T io, long src, long dst, long len) {
        Async<IOException> sp = new Async<IOException>();
        if (len < 0x400000L) {
            ByteBuffer buffer = ByteBuffer.allocate((int)len);
            IOUtil.copy(io, src, dst, buffer, len, sp);
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(0x400000);
            IOUtil.copy(io, src, dst, buffer, len, sp);
        }
        return sp;
    }

    private static <T extends IO.Writable.Seekable & IO.Readable.Seekable> void copy(T io, long src, long dst, ByteBuffer buffer, long len, Async<IOException> sp) {
        ((IO.Readable.Seekable)io).readFullyAsync(src, buffer).onDone(() -> {
            buffer.flip();
            AsyncSupplier<Integer, IOException> write = io.writeAsync(dst, buffer);
            if (len <= 0x400000L) {
                write.onDone(sp);
            } else {
                write.onDone(() -> {
                    long nl = len - 0x400000L;
                    buffer.clear();
                    if (nl < 0x400000L) {
                        buffer.limit((int)nl);
                    }
                    IOUtil.copy(io, src + 0x400000L, dst + 0x400000L, buffer, nl, sp);
                });
            }
        });
    }

    public static AsyncSupplier<Long, IOException> copy(File src, File dst, Task.Priority priority, long knownSize, WorkProgress progress, long work, IAsync<?> startOn) {
        AsyncSupplier<Long, IOException> sp = new AsyncSupplier<Long, IOException>();
        Task task = Task.cpu("Start copying files", priority, t -> {
            FileIO.ReadOnly input = new FileIO.ReadOnly(src, priority);
            FileIO.WriteOnly output = new FileIO.WriteOnly(dst, priority);
            input.canStart().onDone(() -> {
                if (input.canStart().hasError()) {
                    IOUtil.copyEnd(input, output, sp, new IOException("Unable to open file " + src.getAbsolutePath(), input.canStart().getError()), null, true, 0L);
                    return;
                }
                output.canStartWriting().onDone(() -> {
                    if (output.canStartWriting().hasError()) {
                        IOUtil.copyEnd(input, output, sp, new IOException("Unable to open file " + dst.getAbsolutePath(), input.canStart().getError()), null, true, 0L);
                        return;
                    }
                    IOUtil.copy(input, output, knownSize, true, sp, progress, work);
                });
            });
            return null;
        });
        if (startOn == null) {
            task.start();
        } else {
            task.startOn(startOn, true);
        }
        return sp;
    }

    public static IAsync<IOException> closeAsync(Closeable toClose) {
        return Task.cpu("Closing resource", Task.Priority.RATHER_IMPORTANT, t -> {
            toClose.close();
            return null;
        }).start().getOutput();
    }

    public static AsyncSupplier<byte[], IOException> readFully(File file, Task.Priority priority) {
        final AsyncSupplier<byte[], IOException> result = new AsyncSupplier<byte[], IOException>();
        final FileIO.ReadOnly f = new FileIO.ReadOnly(file, priority);
        f.getSizeAsync().listen(new AsyncSupplier.Listener<Long, IOException>(){

            @Override
            public void error(IOException error) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result.error(error);
            }

            @Override
            public void cancelled(CancelException event) {
                try {
                    f.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                result.cancel(event);
            }

            @Override
            public void ready(Long size) {
                final byte[] buf = new byte[size.intValue()];
                f.readFullyAsync(ByteBuffer.wrap(buf)).listen(new AsyncSupplier.Listener<Integer, IOException>(){

                    @Override
                    public void error(IOException error) {
                        try {
                            f.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        result.error(error);
                    }

                    @Override
                    public void cancelled(CancelException event) {
                        try {
                            f.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        result.cancel(event);
                    }

                    @Override
                    public void ready(Integer read) {
                        if (read != buf.length) {
                            result.error(new IOException("Only " + read + " bytes read on file size " + buf.length));
                        } else {
                            try {
                                f.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            result.unblockSuccess(buf);
                        }
                    }
                });
            }
        });
        return result;
    }

    public static TaskManager getUnderlyingTaskManager(IO io) {
        io = IOUtil.getUnderlyingIO(io);
        return io.getTaskManager();
    }

    public static IO getUnderlyingIO(IO io) {
        IO parent;
        while ((parent = io.getWrappedIO()) != null) {
            io = parent;
        }
        return io;
    }

    public static <T> void listenOnDone(AsyncSupplier<T, IOException> toListen, AsyncSupplier<T, IOException> toUnblock, Consumer<Pair<T, IOException>> ondone) {
        toListen.onDone(result -> {
            if (ondone != null) {
                ondone.accept(new Pair<Object, Object>(result, null));
            }
            toUnblock.unblockSuccess(result);
        }, error -> {
            if (ondone != null) {
                ondone.accept(new Pair<Object, IOException>(null, (IOException)error));
            }
            toUnblock.error((IOException)error);
        }, toUnblock::cancel);
    }

    public static <T, T2> void listenOnDone(AsyncSupplier<T, IOException> toListen, Consumer<T> onReady, IAsync<IOException> onErrorOrCancel, Consumer<Pair<T2, IOException>> ondone) {
        toListen.onDone(onReady, error -> {
            if (ondone != null) {
                ondone.accept(new Pair<Object, IOException>(null, (IOException)error));
            }
            onErrorOrCancel.error((IOException)error);
        }, onErrorOrCancel::cancel);
    }

    public static <T, T2> void listenOnDone(AsyncSupplier<T, IOException> toListen, Task<?, ?> onReady, IAsync<IOException> onErrorOrCancel, Consumer<Pair<T2, IOException>> ondone) {
        toListen.onDone(() -> {
            if (toListen.isCancelled()) {
                if (onErrorOrCancel != null) {
                    onErrorOrCancel.cancel(toListen.getCancelEvent());
                }
            } else if (toListen.hasError()) {
                if (ondone != null) {
                    ondone.accept(new Pair(null, toListen.getError()));
                }
                if (onErrorOrCancel != null) {
                    onErrorOrCancel.error((IOException)toListen.getError());
                }
            } else {
                onReady.start();
            }
        });
    }

    public static <T> void listenOnDone(IAsync<IOException> toListen, Runnable onReady, IAsync<IOException> onErrorOrCancel, Consumer<Pair<T, IOException>> ondone) {
        toListen.onDone(onReady, error -> {
            if (ondone != null) {
                ondone.accept(new Pair<Object, IOException>(null, (IOException)error));
            }
            onErrorOrCancel.error((IOException)error);
        }, onErrorOrCancel::cancel);
    }

    public static <T> Consumer<IOException> errorConsumer(IAsync<IOException> async, Consumer<Pair<T, IOException>> ondone) {
        return error -> {
            async.error((IOException)error);
            ondone.accept(new Pair<Object, IOException>(null, (IOException)error));
        };
    }

    public static <TResult, TError extends Exception> void error(TError error, AsyncSupplier<TResult, TError> result, Consumer<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.accept(new Pair<Object, TError>(null, error));
        }
        result.error(error);
    }

    public static <TResult, TError extends Exception> AsyncSupplier<TResult, TError> error(TError error, Consumer<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.accept(new Pair<Object, TError>(null, error));
        }
        return new AsyncSupplier<Object, TError>(null, error);
    }

    public static <TResult, TError extends Exception> void success(TResult res, AsyncSupplier<TResult, TError> result, Consumer<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.accept(new Pair<TResult, Object>(res, null));
        }
        result.unblockSuccess(res);
    }

    public static <TResult, TError extends Exception> AsyncSupplier<TResult, TError> success(TResult result, Consumer<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.accept(new Pair<TResult, Object>(result, null));
        }
        return new AsyncSupplier<TResult, Object>(result, null);
    }

    public static <TResult, TError extends Exception> void notSuccess(IAsync<TError> sp, AsyncSupplier<TResult, TError> result, Consumer<Pair<TResult, TError>> ondone) {
        if (sp.hasError()) {
            IOUtil.error(sp.getError(), result, ondone);
        } else {
            result.cancel(sp.getCancelEvent());
        }
    }

    public static long getSizeSync(IO.Readable.Seekable io) throws IOException {
        if (io instanceof IO.KnownSize) {
            return ((IO.KnownSize)((Object)io)).getSizeSync();
        }
        long pos = io.getPosition();
        long size = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
        io.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, pos);
        return size;
    }

    public static class RecursiveAsyncSupplierListener<T>
    implements AsyncSupplier.Listener<T, IOException> {
        private OnSuccess<T> onSuccess;
        private IAsync<IOException> onErrorOrCancel;
        private Consumer ondone;

        public <T2> RecursiveAsyncSupplierListener(OnSuccess<T> onSuccess, IAsync<IOException> onErrorOrCancel, Consumer<Pair<T2, IOException>> ondone) {
            this.onSuccess = onSuccess;
            this.onErrorOrCancel = onErrorOrCancel;
            this.ondone = ondone;
        }

        @Override
        public void ready(T result) {
            this.onSuccess.accept(result, this);
        }

        @Override
        public void error(IOException error) {
            if (this.ondone != null) {
                this.ondone.accept(new Pair<Object, IOException>(null, error));
            }
            if (this.onErrorOrCancel != null) {
                this.onErrorOrCancel.error(error);
            }
        }

        @Override
        public void cancelled(CancelException event) {
            if (this.onErrorOrCancel != null) {
                this.onErrorOrCancel.cancel(event);
            }
        }

        public String toString() {
            return "IOUtil$RecursiveAsyncSupplierListener: " + this.onSuccess + " / " + this.ondone + " / " + this.onErrorOrCancel;
        }

        public static interface OnSuccess<T> {
            public void accept(T var1, RecursiveAsyncSupplierListener<T> var2);
        }
    }
}

