/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public abstract class SubIO
extends ConcurrentCloseable<IOException>
implements IO,
IO.KnownSize,
IO.PositionKnown {
    protected IO io;
    protected long pos;
    protected long start;
    protected long size;
    protected String description;
    protected boolean closeContainer;

    private SubIO(IO src, long start, long size, String description, boolean closeSrcOnClose) {
        this.io = src;
        this.pos = 0L;
        this.start = start;
        this.size = size;
        this.description = description;
        this.closeContainer = closeSrcOnClose;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public String getSourceDescription() {
        return this.description;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public Task.Priority getPriority() {
        return this.io != null ? this.io.getPriority() : Task.Priority.NORMAL;
    }

    @Override
    public void setPriority(Task.Priority priority) {
        if (this.io != null) {
            this.io.setPriority(priority);
        }
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        if (!this.closeContainer) {
            return null;
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        ondone.unblock();
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        return new AsyncSupplier<Long, Object>(this.size, null);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    protected IAsync<IOException> canStartReading() {
        return ((IO.Readable)this.io).canStartReading();
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        int limit = -1;
        if (this.pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - this.pos));
        }
        int nb = ((IO.Readable)this.io).readSync(buffer);
        this.pos += (long)nb;
        if (limit != -1) {
            buffer.limit(limit);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        int limit = -1;
        if (this.pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - this.pos));
        }
        int plimit = limit;
        return ((IO.Readable)this.io).readAsync(buffer, result -> {
            if (result.getValue1() != null) {
                this.pos += (long)((Integer)result.getValue1()).intValue();
            }
            if (plimit != -1) {
                buffer.limit(plimit);
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        int limit = -1;
        if (this.pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - this.pos));
        }
        int nb = ((IO.Readable)this.io).readFullySync(buffer);
        this.pos += (long)nb;
        if (limit != -1) {
            buffer.limit(limit);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        int limit = -1;
        if (this.pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - this.pos));
        }
        int plimit = limit;
        return ((IO.Readable)this.io).readFullyAsync(buffer, result -> {
            if (result.getValue1() != null) {
                this.pos += (long)((Integer)result.getValue1()).intValue();
            }
            if (plimit != -1) {
                buffer.limit(plimit);
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (pos >= this.size) {
            return -1;
        }
        int limit = -1;
        if (pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - pos));
        }
        int nb = ((IO.Readable.Seekable)this.io).readSync(this.start + pos, buffer);
        if (limit != -1) {
            buffer.limit(limit);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (pos > this.size) {
            if (ondone != null) {
                ondone.accept(new Pair<Integer, Object>(-1, null));
            }
            return new AsyncSupplier<Integer, Object>(-1, null);
        }
        int limit = -1;
        if (pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - pos));
        }
        int plimit = limit;
        return ((IO.Readable.Seekable)this.io).readAsync(this.start + pos, buffer, result -> {
            if (plimit != -1) {
                buffer.limit(plimit);
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        if (pos > this.size) {
            return -1;
        }
        int limit = -1;
        if (pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - pos));
        }
        int nb = ((IO.Readable.Seekable)this.io).readFullySync(this.start + pos, buffer);
        if (limit != -1) {
            buffer.limit(limit);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (pos > this.size) {
            return new AsyncSupplier<Integer, Object>(-1, null);
        }
        int limit = -1;
        if (pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - pos));
        }
        int plimit = limit;
        return ((IO.Readable.Seekable)this.io).readFullyAsync(this.start + pos, buffer, result -> {
            if (plimit != -1) {
                buffer.limit(plimit);
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                if (move < 0L) {
                    move = 0L;
                }
                if (move > this.size) {
                    move = this.size;
                }
                this.pos = move;
                return this.pos;
            }
            case FROM_END: {
                if (move < 0L) {
                    move = 0L;
                }
                if (this.size - move < 0L) {
                    move = this.size;
                }
                this.pos = this.size - move;
                return this.pos;
            }
        }
        if (this.pos + move < 0L) {
            move = -this.pos;
        }
        if (this.pos + move > this.size) {
            move = this.size - this.pos;
        }
        this.pos += move;
        return this.pos;
    }

    protected AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.seekAsyncUsingSync((IO.Seekable)((Object)this), type, move, ondone);
    }

    protected IAsync<IOException> canStartWriting() {
        return ((IO.Writable)this.io).canStartWriting();
    }

    protected int writeSync(ByteBuffer buffer) throws IOException {
        int limit = -1;
        if (this.pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - this.pos));
        }
        int nb = ((IO.Writable)this.io).writeSync(buffer);
        this.pos += (long)nb;
        if (limit != -1) {
            buffer.limit(limit);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        int limit = -1;
        if (this.pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - this.pos));
        }
        int plimit = limit;
        return ((IO.Writable)this.io).writeAsync(buffer, result -> {
            if (result.getValue1() != null) {
                this.pos += (long)((Integer)result.getValue1()).intValue();
            }
            if (plimit != -1) {
                buffer.limit(plimit);
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    protected int writeSync(long pos, ByteBuffer buffer) throws IOException {
        if (pos >= this.size) {
            return -1;
        }
        int limit = -1;
        if (pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - pos));
        }
        int nb = ((IO.Writable.Seekable)this.io).writeSync(this.start + pos, buffer);
        if (limit != -1) {
            buffer.limit(limit);
        }
        return nb;
    }

    protected AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (pos > this.size) {
            if (ondone != null) {
                ondone.accept(new Pair<Integer, Object>(-1, null));
            }
            return new AsyncSupplier<Integer, Object>(-1, null);
        }
        int limit = -1;
        if (pos + (long)buffer.remaining() > this.size) {
            limit = buffer.limit();
            buffer.limit((int)((long)buffer.position() + this.size - pos));
        }
        int plimit = limit;
        return ((IO.Writable.Seekable)this.io).writeAsync(this.start + pos, buffer, result -> {
            if (plimit != -1) {
                buffer.limit(plimit);
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)result);
            }
        });
    }

    public static class ReadWrite
    extends SubIO
    implements IO.Readable.Seekable,
    IO.Writable.Seekable {
        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(T src, long start, long size, String description, boolean closeSrcOnClose) {
            super(src, start, size, description, closeSrcOnClose);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public int readSync(long pos, ByteBuffer buffer) throws IOException {
            return super.readSync(pos, buffer);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            int nb = super.readSync(this.pos, buffer);
            if (nb > 0) {
                this.pos += (long)nb;
            }
            return nb;
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(pos, buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(this.pos, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.pos += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }

        @Override
        public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
            return super.readFullySync(pos, buffer);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            int nb = super.readFullySync(this.pos, buffer);
            if (nb > 0) {
                this.pos += (long)nb;
            }
            return nb;
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(pos, buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(this.pos, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.pos += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }

        @Override
        public long seekSync(IO.Seekable.SeekType type, long move) {
            return super.seekSync(type, move);
        }

        @Override
        public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
            return super.seekAsync(type, move, ondone);
        }

        @Override
        public long skipSync(long n) {
            if (this.pos + n < 0L) {
                n = -this.pos;
            }
            if (this.pos + n > this.size) {
                n = this.size - this.pos;
            }
            this.pos += n;
            return n;
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
            long l = this.skipSync(n);
            if (ondone != null) {
                ondone.accept(new Pair<Long, Object>(l, null));
            }
            return new AsyncSupplier<Long, Object>(l, null);
        }

        @Override
        public IAsync<IOException> canStartWriting() {
            return super.canStartWriting();
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            int nb = super.writeSync(this.pos, buffer);
            if (nb > 0) {
                this.pos += (long)nb;
            }
            return nb;
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(this.pos, buffer, res -> {
                if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                    this.pos += (long)((Integer)res.getValue1()).intValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Integer, IOException>)res);
                }
            });
        }
    }

    public static class Writable
    extends SubIO
    implements IO.Writable {
        public Writable(IO.Writable src, long start, long size, String description, boolean closeSrcOnClose) {
            super(src, start, size, description, closeSrcOnClose);
        }

        @Override
        public IAsync<IOException> canStartWriting() {
            return super.canStartWriting();
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(buffer, ondone);
        }

        public static class Seekable
        extends SubIO
        implements IO.Writable.Seekable {
            public Seekable(IO.Writable.Seekable src, long start, long size, String description, boolean closeSrcOnClose) {
                super(src, start, size, description, closeSrcOnClose);
            }

            @Override
            public IAsync<IOException> canStartWriting() {
                return super.canStartWriting();
            }

            @Override
            public int writeSync(long pos, ByteBuffer buffer) throws IOException {
                return super.writeSync(pos, buffer);
            }

            @Override
            public int writeSync(ByteBuffer buffer) throws IOException {
                int nb = super.writeSync(this.pos, buffer);
                if (nb > 0) {
                    this.pos += (long)nb;
                }
                return nb;
            }

            @Override
            public AsyncSupplier<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.writeAsync(pos, buffer, ondone);
            }

            @Override
            public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.writeAsync(this.pos, buffer, res -> {
                    if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                        this.pos += (long)((Integer)res.getValue1()).intValue();
                    }
                    if (ondone != null) {
                        ondone.accept((Pair<Integer, IOException>)res);
                    }
                });
            }

            @Override
            public long seekSync(IO.Seekable.SeekType type, long move) {
                return super.seekSync(type, move);
            }

            @Override
            public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
                return super.seekAsync(type, move, ondone);
            }
        }
    }

    public static class Readable
    extends SubIO
    implements IO.Readable {
        public Readable(IO.Readable src, long size, String description, boolean closeSrcOnClose) {
            super(src, 0L, size, description, closeSrcOnClose);
        }

        @Override
        public IAsync<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public long skipSync(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            if (this.pos + n > this.size) {
                n = this.size - this.pos;
            }
            long nb = ((IO.Readable)this.io).skipSync(n);
            this.pos += nb;
            return nb;
        }

        @Override
        public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
            if (n <= 0L) {
                if (ondone != null) {
                    ondone.accept(new Pair<Long, Object>(0L, null));
                }
                return new AsyncSupplier<Long, Object>(0L, null);
            }
            if (this.pos + n > this.size) {
                n = this.size - this.pos;
            }
            return ((IO.Readable)this.io).skipAsync(n, result -> {
                if (result.getValue1() != null) {
                    this.pos += ((Long)result.getValue1()).longValue();
                }
                if (ondone != null) {
                    ondone.accept((Pair<Long, IOException>)result);
                }
            });
        }

        public static class Seekable
        extends SubIO
        implements IO.Readable.Seekable {
            public Seekable(IO.Readable.Seekable src, long start, long size, String description, boolean closeSrcOnClose) {
                super(src, start, size, description, closeSrcOnClose);
            }

            @Override
            public IAsync<IOException> canStartReading() {
                return super.canStartReading();
            }

            @Override
            public int readSync(long pos, ByteBuffer buffer) throws IOException {
                return super.readSync(pos, buffer);
            }

            @Override
            public int readSync(ByteBuffer buffer) throws IOException {
                int nb = super.readSync(this.pos, buffer);
                if (nb > 0) {
                    this.pos += (long)nb;
                }
                return nb;
            }

            @Override
            public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readAsync(pos, buffer, ondone);
            }

            @Override
            public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readAsync(this.pos, buffer, res -> {
                    if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                        this.pos += (long)((Integer)res.getValue1()).intValue();
                    }
                    if (ondone != null) {
                        ondone.accept((Pair<Integer, IOException>)res);
                    }
                });
            }

            @Override
            public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
                return super.readFullySync(pos, buffer);
            }

            @Override
            public int readFullySync(ByteBuffer buffer) throws IOException {
                int nb = super.readFullySync(this.pos, buffer);
                if (nb > 0) {
                    this.pos += (long)nb;
                }
                return nb;
            }

            @Override
            public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readFullyAsync(pos, buffer, ondone);
            }

            @Override
            public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                return super.readFullyAsync(this.pos, buffer, res -> {
                    if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                        this.pos += (long)((Integer)res.getValue1()).intValue();
                    }
                    if (ondone != null) {
                        ondone.accept((Pair<Integer, IOException>)res);
                    }
                });
            }

            @Override
            public long seekSync(IO.Seekable.SeekType type, long move) {
                return super.seekSync(type, move);
            }

            @Override
            public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
                return super.seekAsync(type, move, ondone);
            }

            @Override
            public long skipSync(long n) {
                if (this.pos + n < 0L) {
                    n = -this.pos;
                }
                if (this.pos + n > this.size) {
                    n = this.size - this.pos;
                }
                this.pos += n;
                return n;
            }

            @Override
            public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
                long l = this.skipSync(n);
                if (ondone != null) {
                    ondone.accept(new Pair<Long, Object>(l, null));
                }
                return new AsyncSupplier<Long, Object>(l, null);
            }

            public static class Buffered
            extends Seekable
            implements IO.Readable.Buffered {
                public <T extends IO.Readable.Seekable & IO.Readable.Buffered> Buffered(T src, long start, long size, String description, boolean closeSrcOnClose) {
                    super(src, start, size, description, closeSrcOnClose);
                }

                @Override
                public IAsync<IOException> canStartReading() {
                    IAsync<IOException> sp = ((IO.Readable.Buffered)this.io).canStartReading();
                    if (!sp.isDone()) {
                        return sp;
                    }
                    try {
                        if (((IO.Readable.Seekable)this.io).getPosition() == this.start + this.pos) {
                            return sp;
                        }
                    }
                    catch (IOException e) {
                        return new Async<IOException>(e);
                    }
                    return ((IO.Readable.Seekable)this.io).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, this.start + this.pos);
                }

                @Override
                public int read() throws IOException {
                    if (this.pos == this.size) {
                        return -1;
                    }
                    ByteBuffer b = ByteBuffer.allocate(1);
                    int nb = this.readSync(b);
                    if (nb <= 0) {
                        return -1;
                    }
                    return b.array()[0] & 0xFF;
                }

                @Override
                public int read(byte[] buffer, int offset, int len) throws IOException {
                    if (this.pos + (long)len > this.size) {
                        len = (int)(this.size - this.pos);
                    }
                    ByteBuffer b = ByteBuffer.wrap(buffer, offset, len);
                    return this.readSync(b);
                }

                @Override
                public int readFully(byte[] buffer) throws IOException {
                    int len = buffer.length;
                    if (this.pos + (long)len > this.size) {
                        len = (int)(this.size - this.pos);
                    }
                    ByteBuffer b = ByteBuffer.wrap(buffer, 0, len);
                    return this.readFullySync(b);
                }

                @Override
                public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
                    int limit;
                    try {
                        if (((IO.Readable.Seekable)this.io).getPosition() != this.start + this.pos) {
                            return this.readFullyAsync(buffer, ondone);
                        }
                    }
                    catch (IOException e) {
                        if (ondone != null) {
                            ondone.accept(new Pair<Object, IOException>(null, e));
                        }
                        return new AsyncSupplier<Object, IOException>(null, e);
                    }
                    if ((long)buffer.remaining() > this.size - this.pos) {
                        limit = buffer.limit();
                        buffer.limit((int)((long)buffer.position() + this.size - this.pos));
                    } else {
                        limit = -1;
                    }
                    return ((IO.Readable.Buffered)this.io).readFullySyncIfPossible(buffer, res -> {
                        if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                            this.pos += (long)((Integer)res.getValue1()).intValue();
                        }
                        if (limit != -1) {
                            buffer.limit(limit);
                        }
                        if (ondone != null) {
                            ondone.accept((Pair<Integer, IOException>)res);
                        }
                    });
                }

                @Override
                public int readAsync() throws IOException {
                    int res;
                    if (this.pos == this.size) {
                        return -1;
                    }
                    if (((IO.Readable.Seekable)this.io).getPosition() != this.start + this.pos) {
                        AsyncSupplier<Long, IOException> seek = ((IO.Readable.Seekable)this.io).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, this.start + this.pos);
                        if (!seek.isDone()) {
                            return -2;
                        }
                        if (seek.hasError()) {
                            throw seek.getError();
                        }
                    }
                    if ((res = ((IO.Readable.Buffered)this.io).readAsync()) >= 0) {
                        ++this.pos;
                    }
                    return res;
                }

                @Override
                public int skip(int skip) {
                    return (int)this.skipSync(skip);
                }

                @Override
                public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
                    if (this.pos >= this.size) {
                        if (ondone != null) {
                            ondone.accept(new Pair<Object, Object>(null, null));
                        }
                        return new AsyncSupplier<Object, Object>(null, null);
                    }
                    AsyncSupplier<ByteBuffer, IOException> result = new AsyncSupplier<ByteBuffer, IOException>();
                    Task.cpu("Read next buffer", this.getPriority(), task -> {
                        int len = 16384;
                        if ((long)len > this.size - this.pos) {
                            len = (int)(this.size - this.pos);
                        }
                        ByteBuffer buf = ByteBuffer.allocate(len);
                        AsyncSupplier<Integer, IOException> read = ((IO.Readable.Seekable)this.io).readAsync(this.start + this.pos, buf);
                        read.onDone(() -> {
                            if (read.hasError()) {
                                if (ondone != null) {
                                    ondone.accept(new Pair(null, read.getError()));
                                }
                                result.error((IOException)read.getError());
                                return;
                            }
                            if ((Integer)read.getResult() > 0) {
                                this.pos += (long)((Integer)read.getResult()).intValue();
                            }
                            buf.flip();
                            if (ondone != null) {
                                ondone.accept(new Pair<ByteBuffer, Object>(buf, null));
                            }
                            result.unblockSuccess(buf);
                        });
                        return null;
                    }).start();
                    return result;
                }

                @Override
                public ByteBuffer readNextBuffer() throws IOException {
                    if (this.pos >= this.size) {
                        return null;
                    }
                    int len = 16384;
                    if ((long)len > this.size - this.pos) {
                        len = (int)(this.size - this.pos);
                    }
                    ByteBuffer buf = ByteBuffer.wrap((byte[])ByteArrayCache.getInstance().get(len, true));
                    buf.limit(len);
                    int nb = ((IO.Readable.Seekable)this.io).readSync(this.start + this.pos, buf);
                    if (nb > 0) {
                        this.pos += (long)nb;
                    }
                    buf.flip();
                    return buf;
                }
            }
        }
    }
}

