/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.concurrent.Executable;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.AbstractIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.util.Pair;

public class ByteBuffersIO
extends AbstractIO
implements IO.Readable.Buffered,
IO.Readable.Seekable,
IO.KnownSize,
IO.Writable {
    private boolean copyBuffers;
    private LinkedArrayList<ByteArray.Writable> buffers = new LinkedArrayList(10);
    private int pos = 0;
    private int bufferIndex = 0;
    private int bufferPos = 0;
    private int totalSize = 0;

    public ByteBuffersIO(boolean copyBuffers, String description, Task.Priority priority) {
        super(description, priority);
        this.copyBuffers = copyBuffers;
    }

    public LinkedArrayList<ByteArray.Writable> getBuffers() {
        return this.buffers;
    }

    public byte[] createSingleByteArray() {
        byte[] buf = new byte[this.totalSize];
        int bufPos = 0;
        for (ByteArray.Writable b : this.buffers) {
            int p = b.position();
            b.get(buf, bufPos, b.remaining());
            b.setPosition(p);
            bufPos += b.remaining();
        }
        return buf;
    }

    public synchronized void addBuffer(ByteArray.Writable array) {
        if (this.copyBuffers) {
            byte[] b = new byte[array.remaining()];
            array.get(b, 0, b.length);
            array = new ByteArray.Writable(b, false);
        }
        this.buffers.add(array);
        this.totalSize += array.remaining();
    }

    @Override
    public synchronized int readSync(ByteBuffer buffer) {
        if (this.bufferIndex == this.buffers.size()) {
            return -1;
        }
        int done = 0;
        while (this.bufferIndex < this.buffers.size() && buffer.hasRemaining()) {
            ByteArray.Writable b = this.buffers.get(this.bufferIndex);
            int len = buffer.remaining();
            if (len > b.remaining() - this.bufferPos) {
                len = b.remaining() - this.bufferPos;
            }
            buffer.put((byte[])b.getArray(), b.getCurrentArrayOffset() + this.bufferPos, len);
            this.bufferPos += len;
            this.pos += len;
            done += len;
            if (this.bufferPos != b.remaining()) continue;
            ++this.bufferIndex;
            this.bufferPos = 0;
        }
        return done;
    }

    @Override
    public synchronized int readSync(long pos, ByteBuffer buffer) {
        long rem;
        int readBufferIndex = this.bufferIndex;
        int readBufferPos = this.bufferPos;
        long n = pos - (long)this.pos;
        if (n > 0L) {
            int l;
            for (rem = n; readBufferIndex < this.buffers.size() && rem > 0L; rem -= (long)l, ++readBufferIndex) {
                l = this.buffers.get(readBufferIndex).remaining() - readBufferPos;
                if ((long)l > rem) {
                    readBufferPos = (int)((long)readBufferPos + rem);
                    break;
                }
                readBufferPos = 0;
            }
        } else {
            if ((long)this.pos + n < 0L) {
                n = -this.pos;
            }
            for (rem = -n; rem > 0L; rem -= (long)readBufferPos) {
                if ((long)readBufferPos >= rem) {
                    readBufferPos = (int)((long)readBufferPos - rem);
                    break;
                }
                if (readBufferIndex == 0) {
                    readBufferPos = 0;
                    break;
                }
                readBufferPos = this.buffers.get(--readBufferIndex).remaining();
            }
        }
        if (readBufferIndex == this.buffers.size()) {
            return -1;
        }
        int done = 0;
        while (readBufferIndex < this.buffers.size() && buffer.hasRemaining()) {
            ByteArray.Writable b = this.buffers.get(readBufferIndex);
            int len = buffer.remaining();
            if (len > b.remaining() - readBufferPos) {
                len = b.remaining() - readBufferPos;
            }
            buffer.put((byte[])b.getArray(), b.getCurrentArrayOffset() + readBufferPos, len);
            done += len;
            if ((readBufferPos += len) != b.remaining()) continue;
            ++readBufferIndex;
            readBufferPos = 0;
        }
        return done;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.success(this.readFullySync(buffer), ondone);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(Task.cpu("readAsync on ByteBuffersIO", this.getPriority(), t -> this.readSync(pos, buffer), ondone).start()).getOutput();
    }

    @Override
    public int readAsync() {
        return this.read();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone));
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        return this.operation(Task.cpu("Read next buffer", this.getPriority(), new Executable.FromSupplierThrows(this::readNextBuffer), ondone).start()).getOutput();
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        if (this.bufferIndex == this.buffers.size()) {
            return null;
        }
        ByteArray.Writable b = this.buffers.get(this.bufferIndex);
        int len = b.remaining() - this.bufferPos;
        ByteBuffer buf = ByteBuffer.wrap((byte[])b.getArray(), b.getCurrentArrayOffset() + this.bufferPos, len).asReadOnlyBuffer();
        this.pos += len;
        ++this.bufferIndex;
        this.bufferPos = 0;
        return buf;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) {
        return this.readSync(buffer);
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) {
        return this.readSync(pos, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(buffer, ondone);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(pos, buffer, ondone);
    }

    @Override
    public synchronized long skipSync(long n) {
        if (n == 0L) {
            return 0L;
        }
        if (n > 0L) {
            long rem = n;
            while (this.bufferIndex < this.buffers.size() && rem > 0L) {
                int l = this.buffers.get(this.bufferIndex).remaining() - this.bufferPos;
                if ((long)l > rem) {
                    this.bufferPos = (int)((long)this.bufferPos + rem);
                    rem = 0L;
                    break;
                }
                rem -= (long)l;
                this.bufferPos = 0;
                ++this.bufferIndex;
            }
            this.pos = (int)((long)this.pos + (n - rem));
            return n - rem;
        }
        if ((long)this.pos + n < 0L) {
            n = -this.pos;
        }
        long rem = -n;
        while (rem > 0L) {
            if ((long)this.bufferPos >= rem) {
                this.bufferPos = (int)((long)this.bufferPos - rem);
                break;
            }
            rem -= (long)this.bufferPos;
            if (this.bufferIndex == 0) {
                this.bufferPos = 0;
                n += rem;
                break;
            }
            --this.bufferIndex;
            this.bufferPos = this.buffers.get(this.bufferIndex).remaining();
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.skipSync(n), ondone);
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public synchronized int read() {
        if (this.bufferIndex == this.buffers.size()) {
            return -1;
        }
        ByteArray.Writable buf = this.buffers.get(this.bufferIndex);
        byte b = buf.getForward(this.bufferPos);
        if (++this.bufferPos == buf.remaining()) {
            ++this.bufferIndex;
            this.bufferPos = 0;
        }
        ++this.pos;
        return b & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) {
        return this.readSync(ByteBuffer.wrap(buffer, offset, len));
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return new Async<boolean>(true);
    }

    @Override
    public long getSizeSync() {
        return this.totalSize;
    }

    @Override
    public AsyncSupplier<Long, IOException> getSizeAsync() {
        return new AsyncSupplier<Long, Object>(Long.valueOf(this.totalSize), null);
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.skipSync(move - (long)this.pos);
                break;
            }
            case FROM_CURRENT: {
                this.skipSync(move);
                break;
            }
            default: {
                this.skipSync((long)this.totalSize - move - (long)this.pos);
            }
        }
        return this.pos;
    }

    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        return IOUtil.success(this.seekSync(type, move), ondone);
    }

    @Override
    public int readFully(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int skip(int skip) {
        return (int)this.skipSync(skip);
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return null;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.buffers = null;
        ondone.unblock();
    }

    @Override
    public int writeSync(ByteBuffer buffer) {
        this.addBuffer(ByteArray.Writable.fromByteBuffer(buffer));
        this.pos = this.totalSize;
        this.bufferIndex = this.buffers.size();
        this.bufferPos = 0;
        int len = buffer.remaining();
        buffer.position(buffer.position() + len);
        return len;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (!this.copyBuffers) {
            return IOUtil.success(this.writeSync(buffer), ondone);
        }
        return this.operation(IOUtil.writeAsyncUsingSync(this, buffer, ondone));
    }
}

