/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class SimpleBufferedReadable
extends ConcurrentCloseable<IOException>
implements IO.Readable.Buffered {
    private IO.Readable io;
    private ByteBuffer readBuffer;
    private AtomicState state;
    private ByteBuffer bb;
    private AsyncSupplier<Integer, IOException> readTask;

    public SimpleBufferedReadable(IO.Readable io, int bufferSize) {
        this.io = io;
        this.readBuffer = ByteBuffer.allocate(bufferSize);
        this.readTask = io.readAsync(this.readBuffer);
        this.bb = ByteBuffer.allocate(bufferSize);
        this.state = new AtomicState();
        this.state.pos = (this.state.len = 0);
        AtomicState.access$302(this.state, this.bb.array());
    }

    @Override
    public IAsync<IOException> canStartReading() {
        Future<Object> sp = this.readTask;
        if (sp == null) {
            sp = new Async<boolean>(true);
        }
        return sp;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public Task.Priority getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.io.setPriority(priority);
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        AsyncSupplier<Integer, IOException> currentRead = this.readTask;
        if (currentRead != null && !currentRead.isDone()) {
            currentRead.cancel(new CancelException("IO closed"));
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.readTask = null;
        AtomicState.access$302(this.state, null);
        this.bb = null;
        this.readBuffer = null;
        ondone.unblock();
    }

    public void stop() {
        AsyncSupplier<Integer, IOException> currentRead = this.readTask;
        if (currentRead != null && !currentRead.isDone()) {
            currentRead.cancel(new CancelException("SimpleBufferedReadable.stop"));
        }
    }

    private void fill() throws IOException, CancelException {
        AsyncSupplier<Integer, IOException> currentRead = this.readTask;
        if (currentRead == null) {
            return;
        }
        currentRead.block(0L);
        if (!currentRead.isSuccessful()) {
            if (currentRead.isCancelled()) {
                throw currentRead.getCancelEvent();
            }
            IOException e = currentRead.getError();
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        int nb = currentRead.getResult();
        if (nb <= 0) {
            this.state.pos = (this.state.len = 0);
            AtomicState.access$302(this.state, null);
            this.bb = null;
            this.readBuffer = null;
            this.readTask = null;
            return;
        }
        if (this.readTask == null) {
            return;
        }
        AtomicState s = new AtomicState();
        AtomicState.access$302(s, this.readBuffer.array());
        s.pos = 0;
        s.len = this.readBuffer.position();
        this.state = s;
        ByteBuffer b = this.readBuffer;
        this.readBuffer = this.bb;
        this.bb = b;
        this.readBuffer.clear();
        this.readTask = this.io.readAsync(this.readBuffer);
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int l;
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                return -1;
            }
            if (this.state.pos == this.state.len) {
                return -1;
            }
        }
        if ((l = buffer.remaining()) > this.state.len - this.state.pos) {
            l = this.state.len - this.state.pos;
        }
        buffer.put(this.state.buffer, this.state.pos, l);
        AtomicState atomicState = this.state;
        atomicState.pos = atomicState.pos + l;
        return l;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return IOUtil.success(-1, ondone);
            }
            return this.readFullyAsync(buffer, ondone);
        }
        int l = buffer.remaining();
        if (l > this.state.len - this.state.pos) {
            l = this.state.len - this.state.pos;
        }
        buffer.put(this.state.buffer, this.state.pos, l);
        AtomicState atomicState = this.state;
        atomicState.pos = atomicState.pos + l;
        if (!buffer.hasRemaining()) {
            return IOUtil.success(l, ondone);
        }
        return IOUtil.readFullyAsync(this, buffer, l, ondone);
    }

    @Override
    public int readAsync() throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            AsyncSupplier<Integer, IOException> currentRead = this.readTask;
            if (currentRead != null && currentRead.isDone()) {
                try {
                    this.fill();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception t) {
                    return -1;
                }
            }
            return -2;
        }
        return s.buffer[s.pos++] & 0xFF;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone));
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)this, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(this, buffer, ondone);
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        AtomicState s = this.state;
        if (s.pos == s.len && s.buffer == null) {
            return IOUtil.success(null, ondone);
        }
        return this.operation(Task.cpu("Read next buffer", this.getPriority(), task -> {
            ByteBuffer buf;
            AtomicState st = this.state;
            if (st.pos == st.len) {
                if (st.buffer == null) {
                    return null;
                }
                this.fill();
                if (this.state.pos == this.state.len) {
                    return null;
                }
            }
            try {
                buf = ByteBuffer.wrap(this.state.buffer, this.state.pos, this.state.len - this.state.pos).asReadOnlyBuffer();
                this.state.pos = this.state.len;
                this.bb = ByteBuffer.allocate(this.state.buffer.length);
            }
            catch (NullPointerException e) {
                throw new CancelException("IO closed");
            }
            return buf;
        }, ondone).start()).getOutput();
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        ByteBuffer buf;
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return null;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                throw new ClosedChannelException();
            }
            if (this.state.pos == this.state.len) {
                return null;
            }
        }
        try {
            buf = ByteBuffer.wrap(this.state.buffer, this.state.pos, this.state.len - this.state.pos).asReadOnlyBuffer();
            this.state.pos = this.state.len;
            this.bb = ByteBuffer.allocate(this.state.buffer.length);
        }
        catch (NullPointerException e) {
            throw new ClosedChannelException();
        }
        return buf;
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    @Override
    public long skipSync(long n) throws IOException {
        if (this.state.buffer == null || n <= 0L) {
            return 0L;
        }
        if (n <= (long)(this.state.len - this.state.pos)) {
            AtomicState atomicState = this.state;
            atomicState.pos = atomicState.pos + (int)n;
            return n;
        }
        AsyncSupplier<Integer, IOException> currentRead = this.readTask;
        if (currentRead == null) {
            return 0L;
        }
        currentRead.block(0L);
        if (!currentRead.isSuccessful()) {
            if (currentRead.isCancelled()) {
                return 0L;
            }
            IOException e = currentRead.getError();
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        int avail = currentRead.getResult();
        if (avail < 0) {
            avail = 0;
        }
        if (n <= (long)(this.state.len - this.state.pos + avail)) {
            int i = this.state.len - this.state.pos;
            try {
                this.fill();
            }
            catch (CancelException e) {
                return 0L;
            }
            return this.skipSync(n - (long)i) + (long)i;
        }
        n = this.io.skipSync(n - (long)(this.state.len - this.state.pos + avail));
        n += (long)(this.state.len - this.state.pos);
        n += (long)avail;
        this.state.len = (this.state.pos = 0);
        this.readBuffer.clear();
        this.readTask = this.io.readAsync(this.readBuffer);
        return n;
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        if (this.state.buffer == null || n <= 0L) {
            return IOUtil.success(0L, ondone);
        }
        if (n <= (long)(this.state.len - this.state.pos)) {
            AtomicState atomicState = this.state;
            atomicState.pos = atomicState.pos + (int)n;
            if (ondone != null) {
                ondone.accept(new Pair<Long, Object>(n, null));
            }
            return new AsyncSupplier<Long, Object>(n, null);
        }
        AsyncSupplier<Integer, IOException> currentRead = this.readTask;
        if (currentRead == null) {
            return IOUtil.success(0L, ondone);
        }
        Task task = Task.cpu("Skipping bytes", this.io.getPriority(), taskCtx -> {
            if (currentRead.isCancelled()) {
                return 0L;
            }
            if (!currentRead.isSuccessful()) {
                if (currentRead.isCancelled()) {
                    throw currentRead.getCancelEvent();
                }
                throw (IOException)currentRead.getError();
            }
            int avail = (Integer)currentRead.getResult();
            if (avail < 0) {
                avail = 0;
            }
            if (n <= (long)(this.state.len - this.state.pos + avail)) {
                int i = this.state.len - this.state.pos;
                this.fill();
                return this.skipSync(n - (long)i) + (long)i;
            }
            long res = this.io.skipSync(n - (long)(this.state.len - this.state.pos + avail));
            res += (long)(this.state.len - this.state.pos);
            res += (long)avail;
            this.state.len = (this.state.pos = 0);
            this.readBuffer.clear();
            this.readTask = this.io.readAsync(this.readBuffer);
            return res;
        }, ondone);
        this.operation(task).startOn(this.readTask, true);
        return task.getOutput();
    }

    @Override
    public int read() throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                return -1;
            }
            if (this.state.pos == this.state.len) {
                return -1;
            }
        }
        return this.state.buffer[this.state.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int l) throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                return -1;
            }
            if (this.state.pos == this.state.len) {
                return -1;
            }
        }
        if (l > this.state.len - this.state.pos) {
            l = this.state.len - this.state.pos;
        }
        System.arraycopy(this.state.buffer, this.state.pos, buffer, offset, l);
        AtomicState atomicState = this.state;
        atomicState.pos = atomicState.pos + l;
        return l;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    private static class AtomicState {
        private byte[] buffer;
        private int pos;
        private int len;

        private AtomicState() {
        }

        static /* synthetic */ byte[] access$302(AtomicState x0, byte[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

