/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lecousin.framework.io.data.DataBuffer;

public abstract class AbstractComposite<T extends DataBuffer>
implements DataBuffer {
    protected ArrayList<T> list;
    protected int position;
    protected int index;
    protected int length;

    public AbstractComposite() {
        this.list = new ArrayList();
        this.init();
    }

    @SafeVarargs
    public AbstractComposite(T ... elements) {
        this.list = new ArrayList(elements.length);
        Collections.addAll(this.list, elements);
        this.init();
    }

    public AbstractComposite(List<T> elements) {
        this.list = new ArrayList<T>(elements);
        this.init();
    }

    private void init() {
        this.position = 0;
        this.index = 0;
        this.length = 0;
        for (DataBuffer b : this.list) {
            b.setPosition(0);
            this.length += b.remaining();
        }
    }

    public List<T> getWrappedBuffers() {
        return this.list;
    }

    public void add(T buffer) {
        this.list.add(buffer);
        buffer.setPosition(0);
        this.length += buffer.remaining();
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        int r;
        if (position == this.position) {
            return;
        }
        if (position < this.position) {
            int toMove = this.position - position;
            if (this.index == this.list.size()) {
                --this.index;
            }
            while (true) {
                DataBuffer elements;
                int p;
                if (toMove <= (p = (elements = (DataBuffer)this.list.get(this.index)).position())) {
                    elements.setPosition(p - toMove);
                    this.position = position;
                    return;
                }
                toMove -= p;
                --this.index;
                elements.setPosition(0);
            }
        }
        int toMove = position - this.position;
        do {
            DataBuffer elements;
            if (toMove < (r = (elements = (DataBuffer)this.list.get(this.index)).remaining())) {
                elements.moveForward(toMove);
                this.position = position;
                return;
            }
            elements.moveForward(r);
            ++this.index;
        } while ((toMove -= r) > 0);
        this.position = position;
    }

    @Override
    public int remaining() {
        return this.length - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.position < this.length;
    }

    @Override
    public void free() {
        for (DataBuffer data : this.list) {
            data.free();
        }
        this.list = null;
    }
}

