/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.ByteBuffer;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.CharArray;

public class BytesFromIso8859CharArray
implements Bytes.Readable {
    protected CharArray array;
    protected boolean freeCharArrayOnFree;

    public BytesFromIso8859CharArray(CharArray array, boolean freeCharArrayOnFree) {
        this.array = array;
        this.freeCharArrayOnFree = freeCharArrayOnFree;
    }

    @Override
    public void setPosition(int position) {
        this.array.setPosition(position);
    }

    @Override
    public int length() {
        return this.array.length();
    }

    @Override
    public int remaining() {
        return this.array.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.array.hasRemaining();
    }

    @Override
    public int position() {
        return this.array.position();
    }

    public CharArray getOriginalBuffer() {
        return this.array;
    }

    @Override
    public byte getForward(int offset) {
        return (byte)this.array.getForward(offset);
    }

    @Override
    public void get(byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[offset + i] = this.get();
        }
    }

    @Override
    public byte get() {
        return (byte)this.array.get();
    }

    @Override
    public ByteBuffer toByteBuffer() {
        byte[] bytes = new byte[this.remaining()];
        this.get(bytes, 0, bytes.length);
        return ByteBuffer.wrap(bytes);
    }

    @Override
    public BytesFromIso8859CharArray subBuffer(int startPosition, int length) {
        return new BytesFromIso8859CharArray(this.array.subBuffer(startPosition, length), false);
    }

    @Override
    public void free() {
        if (this.freeCharArrayOnFree) {
            this.array.free();
        }
    }

    public static class Writable
    extends BytesFromIso8859CharArray
    implements Bytes.Writable {
        public Writable(CharArray.Writable array, boolean freeCharArrayOnFree) {
            super(array, freeCharArrayOnFree);
        }

        @Override
        public CharArray.Writable getOriginalBuffer() {
            return (CharArray.Writable)this.array;
        }

        @Override
        public Writable subBuffer(int startPosition, int length) {
            return new Writable(((CharArray.Writable)this.array).subBuffer(startPosition, length), false);
        }

        @Override
        public void put(byte b) {
            ((CharArray.Writable)this.array).put((char)(b & 0xFF));
        }

        @Override
        public void put(byte[] buffer, int offset, int length) {
            for (int i = 0; i < length; ++i) {
                ((CharArray.Writable)this.array).put((char)(buffer[offset + i] & 0xFF));
            }
        }

        @Override
        public ByteBuffer toByteBuffer() {
            throw new UnsupportedOperationException();
        }
    }
}

