/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.data;

import java.nio.CharBuffer;
import net.lecousin.framework.io.data.AbstractDataBufferFromString;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.text.IString;

public class CharsFromString
extends AbstractDataBufferFromString
implements Chars.Readable {
    public CharsFromString(CharSequence str) {
        super(str);
    }

    public CharsFromString(CharSequence str, int offset, int length) {
        super(str, offset, length);
    }

    @Override
    public char get() {
        return this.str.charAt(this.offset + this.pos++);
    }

    @Override
    public void get(char[] buffer, int offset, int length) {
        if (this.str instanceof String) {
            ((String)this.str).getChars(this.offset + this.pos, this.offset + this.pos + length, buffer, offset);
        } else if (this.str instanceof IString) {
            IString s = (IString)this.str;
            s.substring(offset, length).fill(buffer, offset);
        } else {
            for (int i = 0; i < length; ++i) {
                buffer[offset + i] = this.str.charAt(i);
            }
        }
        this.pos += length;
    }

    @Override
    public void get(IString string, int length) {
        string.append(this.str, this.offset + this.pos, this.offset + this.pos + length);
        this.pos += length;
    }

    @Override
    public char getForward(int offset) {
        return this.str.charAt(this.offset + this.pos + offset);
    }

    @Override
    public CharBuffer toCharBuffer() {
        CharBuffer b = CharBuffer.allocate(this.length);
        int p = this.pos;
        this.pos = 0;
        this.get(b.array(), 0, this.length);
        b.position(p);
        this.pos = p;
        return b;
    }

    @Override
    public void free() {
    }

    @Override
    public CharsFromString subBuffer(int startPosition, int length) {
        return new CharsFromString(this.str, this.offset + startPosition, length);
    }
}

