/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.out2in;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.LockPoint;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.out2in.OutputToInputTransferException;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.Runnables;

public class OutputToInput
extends ConcurrentCloseable<IOException>
implements IO.OutputToInput,
IO.Writable,
IO.Readable.Seekable {
    private IO io;
    private String sourceDescription;
    private boolean eof = false;
    private Async<IOException> waitForData = new Async();
    private long writePos = 0L;
    private long readPos = 0L;
    private LockPoint<NoException> lockIO = new LockPoint();

    public <T extends IO.Writable.Seekable & IO.Readable.Seekable> OutputToInput(T io, String sourceDescription) {
        this.io = io;
        this.sourceDescription = sourceDescription;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        this.eof = true;
        this.waitForData.error(new EOFException());
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        ondone.unblock();
    }

    @Override
    public Task.Priority getPriority() {
        return this.io != null ? this.io.getPriority() : Task.Priority.NORMAL;
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.io.setPriority(priority);
    }

    @Override
    public String getSourceDescription() {
        return "OutputToInput from " + this.sourceDescription;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public void endOfData() {
        this.eof = true;
        this.waitForData.error(new EOFException());
    }

    @Override
    public void signalErrorBeforeEndOfData(IOException error) {
        this.waitForData.error(error);
        this.lockIO.unlock();
    }

    @Override
    public boolean isFullDataAvailable() {
        return this.eof;
    }

    @Override
    public long getAvailableDataSize() {
        try {
            if (this.io instanceof IO.KnownSize) {
                return ((IO.KnownSize)this.io).getSizeSync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        return ((IO.Writable)this.io).canStartWriting();
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        this.lockIO.lock();
        int nb = ((IO.Writable.Seekable)this.io).writeSync(this.writePos, buffer);
        this.writePos += (long)nb;
        this.lockIO.unlock();
        this.waitForData.unblock();
        return nb;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier result = new AsyncSupplier();
        this.operation(Task.cpu("OutputToInput.writeAsync", this.getPriority(), t -> {
            this.lockIO.lock();
            AsyncSupplier<Integer, IOException> write = ((IO.Writable.Seekable)this.io).writeAsync(this.writePos, buffer, param -> {
                if (param.getValue1() != null) {
                    this.writePos += (long)((Integer)param.getValue1()).intValue();
                    this.lockIO.unlock();
                    this.waitForData.unblock();
                    if (ondone != null) {
                        ondone.accept((Pair<Integer, IOException>)param);
                    }
                } else {
                    this.lockIO.unlock();
                    if (ondone != null) {
                        ondone.accept((Pair<Integer, IOException>)param);
                    }
                    this.waitForData.error((IOException)((Exception)param.getValue2()));
                }
            });
            write.onCancel(this.waitForData::cancel);
            write.forward(result);
            return null;
        })).start();
        return this.operation(result);
    }

    @Override
    public IAsync<IOException> canStartReading() {
        if (this.eof) {
            return new Async<boolean>(true);
        }
        if (this.waitForData.hasError()) {
            return this.waitForData;
        }
        if (this.readPos < this.writePos) {
            return new Async<boolean>(true);
        }
        return this.waitForData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (this.waitForData.hasError() && !this.eof) {
            throw new OutputToInputTransferException(this.waitForData.getError());
        }
        while (pos >= this.writePos) {
            if (this.eof) {
                return -1;
            }
            if (this.waitForData.hasError() && !this.eof) {
                throw new OutputToInputTransferException(this.waitForData.getError());
            }
            Async<IOException> async = this.waitForData;
            synchronized (async) {
                if (pos >= this.writePos && this.waitForData.isSuccessful()) {
                    this.waitForData.reset();
                }
            }
            this.waitForData.block(0L);
        }
        this.lockIO.lock();
        int lim = buffer.limit();
        if (this.writePos - pos < (long)buffer.remaining()) {
            buffer.limit(buffer.position() + (int)(this.writePos - pos));
        }
        int nb = ((IO.Readable.Seekable)this.io).readSync(pos, buffer);
        buffer.limit(lim);
        this.lockIO.unlock();
        return nb;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.readSync(this.readPos, buffer);
        if (nb > 0) {
            this.readPos += (long)nb;
        }
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)this, buffer);
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return IOUtil.readFullySync(this, pos, buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.readPos, buffer, res -> {
            if (res.getValue1() != null && (Integer)res.getValue1() > 0) {
                this.readPos += (long)((Integer)res.getValue1()).intValue();
            }
            if (ondone != null) {
                ondone.accept((Pair<Integer, IOException>)res);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Integer, IOException> readAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        if (this.waitForData.hasError() && !this.eof) {
            OutputToInputTransferException e = new OutputToInputTransferException(this.waitForData.getError());
            if (ondone != null) {
                ondone.accept(new Pair<Object, OutputToInputTransferException>(null, e));
            }
            return new AsyncSupplier<Object, OutputToInputTransferException>(null, e);
        }
        if (pos >= this.writePos) {
            if (this.eof && pos >= this.writePos) {
                if (ondone != null) {
                    ondone.accept(new Pair<Integer, Object>(-1, null));
                }
                return new AsyncSupplier<Integer, Object>(-1, null);
            }
            AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
            Async<IOException> async = this.waitForData;
            synchronized (async) {
                if (pos >= this.writePos && this.waitForData.isSuccessful()) {
                    this.waitForData.reset();
                }
            }
            this.waitForData.thenStart(this.operation(this.taskSyncToAsync("OutputToInput.readAsync", result, ondone, () -> this.readSync(pos, buffer))), true);
            return result;
        }
        AsyncSupplier result = new AsyncSupplier();
        Task.cpu("OutputToInput.readAsync", this.io.getPriority(), t -> {
            this.lockIO.lock();
            int lim = buffer.limit();
            if (this.writePos - pos < (long)buffer.remaining()) {
                buffer.limit(buffer.position() + (int)(this.writePos - pos));
            }
            ((IO.Readable.Seekable)this.io).readAsync(pos, buffer, res -> {
                buffer.limit(lim);
                this.lockIO.unlock();
                if (ondone != null) {
                    ondone.accept((Pair<Pair<Object, OutputToInputTransferException>, IOException>)res);
                }
            }).forward(result);
            return null;
        }).start();
        return this.operation(result);
    }

    private <T> Task<T, IOException> taskSyncToAsync(String description, AsyncSupplier<T, IOException> result, Consumer<Pair<T, IOException>> ondone, Runnables.SupplierThrows<T, IOException> sync) {
        return Task.cpu(description, this.io.getPriority(), task -> {
            try {
                Object res = sync.get();
                if (ondone != null) {
                    ondone.accept(new Pair(res, null));
                }
                result.unblockSuccess(res);
                return res;
            }
            catch (IOException e) {
                if (ondone != null) {
                    ondone.accept(new Pair<Object, IOException>(null, e));
                }
                result.unblockError(e);
                throw e;
            }
        }).setMaxBlockingTimeInNanoBeforeToLog(1000000000L);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, pos, buffer, ondone));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skipSync(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n < 0L) {
            if (this.readPos + n < 0L) {
                n = -this.readPos;
            }
            this.readPos += n;
            return n;
        }
        if (this.readPos + n > this.writePos) {
            if (this.waitForData.hasError() && !this.eof) {
                throw new OutputToInputTransferException(this.waitForData.getError());
            }
            while (this.readPos + n > this.writePos) {
                if (this.eof) {
                    n = this.writePos - this.readPos;
                    this.readPos = this.writePos;
                    return n;
                }
                if (this.waitForData.hasError() && !this.eof) {
                    throw new OutputToInputTransferException(this.waitForData.getError());
                }
                Async<IOException> async = this.waitForData;
                synchronized (async) {
                    if (this.readPos + n > this.writePos && this.waitForData.isSuccessful()) {
                        this.waitForData.reset();
                    }
                }
                this.waitForData.block(0L);
            }
        }
        this.readPos += n;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        if (n <= 0L || this.readPos + n <= this.writePos) {
            try {
                Long r = this.skipSync(n);
                if (ondone != null) {
                    ondone.accept(new Pair<Long, Object>(r, null));
                }
                return new AsyncSupplier<Long, Object>(r, null);
            }
            catch (IOException e) {
                if (ondone != null) {
                    ondone.accept(new Pair<Object, IOException>(null, e));
                }
                return new AsyncSupplier<Object, IOException>(null, e);
            }
        }
        if (this.eof) {
            long m = this.writePos - this.readPos;
            if (m > n) {
                m = n;
            }
            this.readPos += m;
            if (ondone != null) {
                ondone.accept(new Pair<Long, Object>(m, null));
            }
            return new AsyncSupplier<Long, Object>(m, null);
        }
        if (this.waitForData.hasError()) {
            return IOUtil.error(this.waitForData.getError(), ondone);
        }
        AsyncSupplier<Long, IOException> result = new AsyncSupplier<Long, IOException>();
        Async<IOException> async = this.waitForData;
        synchronized (async) {
            if (this.readPos + n > this.writePos && this.waitForData.isSuccessful()) {
                this.waitForData.reset();
            }
        }
        this.waitForData.thenStart(this.operation(this.taskSyncToAsync("OutputToInput.skipAsync", result, ondone, () -> this.skipSync(n))), true);
        return result;
    }

    @Override
    public long getPosition() {
        return this.readPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_BEGINNING: {
                this.readPos = 0L;
                this.skipSync(move);
                return this.readPos;
            }
            case FROM_CURRENT: {
                this.skipSync(move);
                return this.readPos;
            }
        }
        while (!this.eof && !this.waitForData.hasError()) {
            Async<IOException> async = this.waitForData;
            synchronized (async) {
                if (!this.eof && this.waitForData.isSuccessful()) {
                    this.waitForData.reset();
                }
            }
            this.waitForData.block(0L);
        }
        if (this.eof) {
            this.readPos = this.writePos;
            this.skipSync(-move);
            return this.readPos;
        }
        throw new OutputToInputTransferException(this.waitForData.getError());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncSupplier<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, Consumer<Pair<Long, IOException>> ondone) {
        AsyncSupplier<Long, IOException> res = new AsyncSupplier<Long, IOException>();
        switch (type) {
            case FROM_BEGINNING: {
                this.readPos = 0L;
                this.skipAsync(move).onDone(() -> {
                    if (ondone != null) {
                        ondone.accept(new Pair<Long, Object>(this.readPos, null));
                    }
                    res.unblockSuccess(this.readPos);
                }, res);
                return res;
            }
            case FROM_CURRENT: {
                this.skipAsync(move).onDone(() -> {
                    if (ondone != null) {
                        ondone.accept(new Pair<Long, Object>(this.readPos, null));
                    }
                    res.unblockSuccess(this.readPos);
                }, res);
                return res;
            }
            case FROM_END: {
                if (this.waitForData.hasError() && !this.eof) {
                    return IOUtil.error(new OutputToInputTransferException(this.waitForData.getError()), ondone);
                }
                if (this.eof) {
                    this.readPos = move <= 0L ? this.writePos : this.writePos - move;
                    if (this.readPos < 0L) {
                        this.readPos = 0L;
                    }
                    return IOUtil.success(this.readPos, ondone);
                }
                AsyncSupplier<Long, IOException> result = new AsyncSupplier<Long, IOException>();
                Async<IOException> async = this.waitForData;
                synchronized (async) {
                    if (!this.eof && this.waitForData.isSuccessful()) {
                        this.waitForData.reset();
                    }
                }
                this.waitForData.thenStart(this.operation(Task.cpu("OutputToInput.seekAsync", this.io.getPriority(), t -> {
                    try {
                        Long nb = this.seekSync(type, move);
                        if (ondone != null) {
                            ondone.accept(new Pair<Long, Object>(nb, null));
                        }
                        result.unblockSuccess(nb);
                    }
                    catch (IOException e) {
                        if (ondone != null) {
                            ondone.accept(new Pair<Object, IOException>(null, e));
                        }
                        result.unblockError(e);
                    }
                    return null;
                })), true);
                return result;
            }
        }
        return new AsyncSupplier<Object, IOException>(null, new IOException("Unknown SeekType " + (Object)((Object)type)));
    }
}

