/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.provider.FileIOProvider;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFrom;

public class IOProviderFromURI
implements IOProviderFrom<URI> {
    private static IOProviderFromURI instance = new IOProviderFromURI();
    private Map<String, IOProviderFrom<URI>> protocols = new HashMap<String, IOProviderFrom<URI>>();

    public static IOProviderFromURI getInstance() {
        return instance;
    }

    public void registerProtocol(String protocol, IOProviderFrom<URI> provider) {
        this.protocols.put(protocol.toLowerCase(), provider);
    }

    private IOProviderFromURI() {
        this.protocols.put("file", from -> {
            File file;
            try {
                file = new File((URI)from);
            }
            catch (Exception e) {
                return null;
            }
            if (!file.exists()) {
                return null;
            }
            return new FileIOProvider(file);
        });
    }

    @Override
    public IOProvider get(final URI from) {
        String protocol = from.getScheme().toLowerCase();
        IOProviderFrom<URI> p = this.protocols.get(protocol);
        if (p != null) {
            return p.get(from);
        }
        return new IOProvider.Readable(){

            @Override
            public String getDescription() {
                return from.toString();
            }

            @Override
            public IO.Readable provideIOReadable(Task.Priority priority) throws IOException {
                InputStream in = from.toURL().openStream();
                return new IOFromInputStream(in, from.toString(), Threading.getUnmanagedTaskManager(), priority);
            }
        };
    }
}

