/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import java.nio.charset.Charset;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.data.Chars;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.text.IString;
import net.lecousin.framework.util.ConcurrentCloseable;

public class BufferedReadableCharacterStreamLocation
extends ConcurrentCloseable<IOException>
implements ICharacterStream.Readable.Buffered,
ICharacterStream.Readable.PositionInText {
    private ICharacterStream.Readable.Buffered stream;
    private int line;
    private int pos;
    private int lastLinePos;

    public BufferedReadableCharacterStreamLocation(ICharacterStream.Readable.Buffered stream) {
        this(stream, 1, 0);
    }

    public BufferedReadableCharacterStreamLocation(ICharacterStream.Readable.Buffered stream, int line, int posInLine) {
        this.stream = stream;
        this.line = line;
        this.lastLinePos = this.pos = posInLine;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getPositionInLine() {
        return this.pos;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.stream.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.stream = null;
        ondone.unblock();
    }

    @Override
    public String getDescription() {
        return this.stream.getDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.stream.getEncoding();
    }

    @Override
    public Task.Priority getPriority() {
        return this.stream.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.stream.setPriority(priority);
    }

    @Override
    public char read() throws IOException {
        char c = this.stream.read();
        if (c == '\n') {
            ++this.line;
            this.lastLinePos = this.pos;
            this.pos = 0;
        } else if (c != '\r') {
            ++this.pos;
        }
        return c;
    }

    @Override
    public int readSync(char[] buf, int offset, int length) throws IOException {
        int nb = this.stream.readSync(buf, offset, length);
        for (int i = 0; i < nb; ++i) {
            if (buf[offset + i] == '\n') {
                ++this.line;
                this.lastLinePos = this.pos;
                this.pos = 0;
                continue;
            }
            if (buf[offset + i] == '\r') continue;
            ++this.pos;
        }
        return nb;
    }

    @Override
    public void back(char c) {
        if (c == '\n') {
            --this.line;
            this.pos = this.lastLinePos;
        } else {
            --this.pos;
        }
        this.stream.back(c);
    }

    @Override
    public int readAsync() throws IOException {
        int c = this.stream.readAsync();
        if (c < 0) {
            return c;
        }
        if (c == 10) {
            ++this.line;
            this.lastLinePos = this.pos;
            this.pos = 0;
        } else if (c != 13) {
            ++this.pos;
        }
        return c;
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(char[] buf, int offset, int length) {
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        AsyncSupplier<Integer, IOException> read = this.stream.readAsync(buf, offset, length);
        read.thenStart(this.operation(Task.cpu("Calculate new location of BufferedReadableCharacterStreamLocation", this.stream.getPriority(), t -> {
            if (read.hasError()) {
                result.error((IOException)read.getError());
            } else if (read.isCancelled()) {
                result.cancel(read.getCancelEvent());
            } else {
                int nb = (Integer)read.getResult();
                for (int i = 0; i < nb; ++i) {
                    if (buf[offset + i] == '\n') {
                        ++this.line;
                        this.lastLinePos = this.pos;
                        this.pos = 0;
                        continue;
                    }
                    if (buf[offset + i] == '\r') continue;
                    ++this.pos;
                }
                result.unblockSuccess((Integer)read.getResult());
            }
            return null;
        })), true);
        return result;
    }

    @Override
    public AsyncSupplier<Chars.Readable, IOException> readNextBufferAsync() {
        AsyncSupplier<Chars.Readable, IOException> result = new AsyncSupplier<Chars.Readable, IOException>();
        AsyncSupplier<Chars.Readable, IOException> read = this.stream.readNextBufferAsync();
        read.thenStart(Task.cpu("Calculate new location of BufferedReadableCharacterStreamLocation", this.stream.getPriority(), t -> {
            Chars.Readable str = (Chars.Readable)read.getResult();
            if (str == null) {
                result.unblockSuccess(null);
                return null;
            }
            this.processLocation(str);
            result.unblockSuccess(str);
            return null;
        }), result);
        return result;
    }

    @Override
    public Chars.Readable readNextBuffer() throws IOException {
        Chars.Readable str = this.stream.readNextBuffer();
        if (str == null) {
            return null;
        }
        this.processLocation(str);
        return str;
    }

    private void processLocation(Chars.Readable str) {
        int len = str.remaining();
        block4: for (int i = 0; i < len; ++i) {
            switch (str.getForward(i)) {
                case '\n': {
                    ++this.line;
                    this.lastLinePos = this.pos;
                    this.pos = 0;
                    continue block4;
                }
                case '\r': {
                    continue block4;
                }
                default: {
                    ++this.pos;
                }
            }
        }
    }

    private void processLocation(int start, IString string) {
        int i;
        while ((i = string.indexOf('\n', start)) >= 0) {
            this.lastLinePos = this.pos;
            this.pos = 0;
            ++this.line;
            start = i + 1;
        }
        this.pos += string.length() - start;
    }

    @Override
    public boolean readUntil(char endChar, IString string) throws IOException {
        int start = string.length();
        boolean result = this.stream.readUntil(endChar, string);
        this.processLocation(start, string);
        return result;
    }

    @Override
    public AsyncSupplier<Boolean, IOException> readUntilAsync(char endChar, IString string) {
        int start = string.length();
        AsyncSupplier<Boolean, IOException> read = this.stream.readUntilAsync(endChar, string);
        AsyncSupplier<Boolean, IOException> result = new AsyncSupplier<Boolean, IOException>();
        read.thenStart("BufferedReadableCharacterStreamLocation.readUntilAsync", this.stream.getPriority(), t -> {
            this.processLocation(start, string);
            result.unblockSuccess((Boolean)read.getResult());
            return null;
        }, result);
        return result;
    }

    @Override
    public boolean endReached() {
        return this.stream.endReached();
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return this.stream.canStartReading();
    }
}

