/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.text.CharArrayStringBuffer;

public abstract class FullReadLines<T> {
    protected String description;
    protected Task.Priority priority;
    private ICharacterStream.Readable.Buffered stream;
    private IO.OperationType closeStreamAtEnd;
    private CharArrayStringBuffer line = null;

    public FullReadLines(String description, ICharacterStream.Readable.Buffered stream, Task.Priority priority, IO.OperationType closeStreamAtEnd) {
        this.description = description;
        this.priority = priority;
        this.stream = stream;
        this.closeStreamAtEnd = closeStreamAtEnd;
    }

    public String getSourceDescription() {
        return this.stream.getDescription();
    }

    public final AsyncSupplier<T, Exception> start() {
        AsyncSupplier result = new AsyncSupplier();
        this.resume(result);
        return result;
    }

    private void resume(AsyncSupplier<T, Exception> result) {
        this.stream.canStartReading().thenStart(Task.cpu(this.description, this.priority, t -> this.scan(result, t)), true);
    }

    private Void scan(AsyncSupplier<T, Exception> result, Task<?, Exception> taskContext) throws CancelException {
        while (true) {
            int c;
            if (taskContext.isCancelling()) {
                throw taskContext.getCancelEvent();
            }
            if (this.line == null) {
                this.line = new CharArrayStringBuffer();
            }
            try {
                c = this.stream.readAsync();
            }
            catch (Exception e) {
                this.error(e, result);
                return null;
            }
            if (c == -1) {
                if (this.line.length() > 0) {
                    try {
                        this.processLine(this.line);
                    }
                    catch (Exception e) {
                        this.error(e, result);
                        return null;
                    }
                }
                this.finish(result);
                return null;
            }
            if (c == -2) {
                this.resume(result);
                return null;
            }
            if (c == 13) continue;
            if (c == 10) {
                try {
                    this.processLine(this.line);
                }
                catch (Exception e) {
                    this.error(e, result);
                    return null;
                }
                this.line = null;
                continue;
            }
            this.line.append((char)c);
        }
    }

    private void finish(AsyncSupplier<T, Exception> result) {
        Object r;
        try {
            r = this.generateResult();
        }
        catch (Exception e) {
            this.error(e, result);
            return;
        }
        if (this.closeStreamAtEnd == null) {
            result.unblockSuccess(r);
        } else if (IO.OperationType.SYNCHRONOUS.equals((Object)this.closeStreamAtEnd)) {
            this.stream.closeAsync().onDone(() -> result.unblockSuccess(r));
        } else {
            result.unblockSuccess(r);
            this.stream.closeAsync();
        }
    }

    private void error(Exception error, AsyncSupplier<T, Exception> result) {
        if (this.closeStreamAtEnd == null) {
            result.error(error);
        } else if (IO.OperationType.SYNCHRONOUS.equals((Object)this.closeStreamAtEnd)) {
            this.stream.closeAsync().onDone(() -> result.error(error));
        } else {
            result.error(error);
            this.stream.closeAsync();
        }
    }

    protected abstract void processLine(CharArrayStringBuffer var1) throws Exception;

    protected abstract T generateResult() throws Exception;
}

