/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;

public class WritableCharacterStream
extends ConcurrentCloseable<IOException>
implements ICharacterStream.Writable {
    private IO.Writable output;
    private CharsetEncoder encoder;

    public WritableCharacterStream(IO.Writable output, Charset charset) {
        this(output, charset.newEncoder());
    }

    public WritableCharacterStream(IO.Writable output, CharsetEncoder encoder) {
        this.output = output;
        this.encoder = encoder;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.output.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.encoder = null;
        this.output = null;
        ondone.unblock();
    }

    @Override
    public Task.Priority getPriority() {
        return this.output.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.output.setPriority(priority);
    }

    @Override
    public String getDescription() {
        return this.output.getSourceDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.encoder.charset();
    }

    @Override
    public void writeSync(char[] c, int off, int len) throws IOException {
        CharBuffer cb = CharBuffer.wrap(c, off, len);
        ByteBuffer bb = this.encoder.encode(cb);
        this.output.writeSync(bb);
    }

    @Override
    public IAsync<IOException> writeAsync(char[] c, int offset, int length) {
        Async<IOException> result = new Async<IOException>();
        this.operation(Task.cpu("Encoding characters", this.getPriority(), t -> {
            ByteBuffer bb;
            CharBuffer cb = CharBuffer.wrap(c, offset, length);
            try {
                bb = this.encoder.encode(cb);
            }
            catch (CharacterCodingException e) {
                result.error(e);
                return null;
            }
            this.output.writeAsync(bb).onDone(result);
            return null;
        })).start();
        return result;
    }
}

