/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class BroadcastIO
extends ConcurrentCloseable<IOException>
implements IO.Writable {
    private IO.Writable[] ios;
    private Task.Priority priority;
    private boolean closeIOs;

    public BroadcastIO(IO.Writable[] ios, Task.Priority priority, boolean closeIOs) {
        this.ios = ios;
        this.closeIOs = closeIOs;
        this.setPriority(priority);
    }

    @Override
    public Task.Priority getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.priority = priority;
        for (int i = 0; i < this.ios.length; ++i) {
            this.ios[i].setPriority(priority);
        }
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public String getSourceDescription() {
        return "BroadcastIO";
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        if (!this.closeIOs) {
            return new Async<boolean>(true);
        }
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        for (int i = 0; i < this.ios.length; ++i) {
            jp.addToJoin(this.ios[i].closeAsync());
        }
        jp.start();
        return jp;
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.ios = null;
        ondone.unblock();
    }

    @Override
    public IAsync<IOException> canStartWriting() {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        for (int i = 0; i < this.ios.length; ++i) {
            jp.addToJoin(this.ios[i].canStartWriting());
        }
        jp.start();
        return jp;
    }

    private JoinPoint<IOException> write(ByteBuffer buffer, final int nb) {
        final JoinPoint<IOException> jp = new JoinPoint<IOException>();
        jp.addToJoin(this.ios.length);
        for (int i = 0; i < this.ios.length; ++i) {
            this.ios[i].writeAsync(i == this.ios.length - 1 ? buffer : buffer.duplicate()).listen(new AsyncSupplier.Listener<Integer, IOException>(){

                @Override
                public void ready(Integer result) {
                    if (result != nb) {
                        jp.error(new IOException("Only " + result + " byte(s) written instead of " + nb));
                    } else {
                        jp.joined();
                    }
                }

                @Override
                public void error(IOException error) {
                    jp.error(error);
                }

                @Override
                public void cancelled(CancelException event) {
                    jp.cancel(event);
                }
            });
        }
        jp.start();
        return jp;
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        int nb = buffer.remaining();
        this.write(buffer, nb).blockException(0L);
        return nb;
    }

    @Override
    public AsyncSupplier<Integer, IOException> writeAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        AsyncSupplier<Integer, IOException> result = new AsyncSupplier<Integer, IOException>();
        Task.cpu("BroadcastIO.writeAsync", this.priority, t -> {
            int nb = buffer.remaining();
            this.write(buffer, nb).onDone(() -> result.unblockSuccess(nb), result);
            return null;
        }).start();
        return result;
    }
}

