/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;

public class NonBufferedReadableIOAsBuffered
extends ConcurrentCloseable<IOException>
implements IO.Readable.Buffered {
    private IO.Readable io;
    private byte[] b1 = new byte[1];
    private ByteBuffer bb1 = ByteBuffer.wrap(this.b1);

    public NonBufferedReadableIOAsBuffered(IO.Readable io) {
        this.io = io;
    }

    @Override
    protected IAsync<IOException> closeUnderlyingResources() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(Async<IOException> ondone) {
        this.io = null;
        ondone.unblock();
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public Task.Priority getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(Task.Priority priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        return this.io.readSync(buffer);
    }

    @Override
    public int readAsync() throws IOException {
        return this.read();
    }

    @Override
    public AsyncSupplier<Integer, IOException> readAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.io.readAsync(buffer, ondone);
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return this.io.readFullySync(buffer);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullyAsync(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.io.readFullyAsync(buffer, ondone);
    }

    @Override
    public AsyncSupplier<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, Consumer<Pair<Integer, IOException>> ondone) {
        return this.io.readAsync(buffer, ondone);
    }

    @Override
    public long skipSync(long n) throws IOException {
        return this.io.skipSync(n);
    }

    @Override
    public AsyncSupplier<Long, IOException> skipAsync(long n, Consumer<Pair<Long, IOException>> ondone) {
        return this.io.skipAsync(n, ondone);
    }

    @Override
    public int read() throws IOException {
        this.bb1.clear();
        int nb = this.io.readSync(this.bb1);
        if (nb <= 0) {
            return -1;
        }
        return this.b1[0] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        return this.io.readSync(ByteBuffer.wrap(buffer, offset, len));
    }

    @Override
    public IAsync<IOException> canStartReading() {
        return new Async<boolean>(true);
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return this.io.readFullySync(ByteBuffer.wrap(buffer));
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.io.skipSync(skip);
    }

    @Override
    public AsyncSupplier<ByteBuffer, IOException> readNextBufferAsync(Consumer<Pair<ByteBuffer, IOException>> ondone) {
        AsyncSupplier<ByteBuffer, IOException> result = new AsyncSupplier<ByteBuffer, IOException>();
        this.operation(Task.cpu("Read next buffer", this.getPriority(), t -> {
            ByteBuffer buf = ByteBuffer.allocate(4096);
            AsyncSupplier<Integer, IOException> read = this.readAsync(buf);
            read.onDone(() -> {
                if (read.hasError()) {
                    if (ondone != null) {
                        ondone.accept(new Pair(null, read.getError()));
                    }
                    result.unblockError((IOException)read.getError());
                    return;
                }
                int nb = (Integer)read.getResult();
                if (nb <= 0) {
                    if (ondone != null) {
                        ondone.accept(new Pair<Object, Object>(null, null));
                    }
                    result.unblockSuccess(null);
                    return;
                }
                buf.flip();
                if (ondone != null) {
                    ondone.accept(new Pair<ByteBuffer, Object>(buf, null));
                }
                result.unblockSuccess(buf);
            });
            return null;
        }).start());
        return result;
    }

    @Override
    public ByteBuffer readNextBuffer() throws IOException {
        ByteBuffer buf = ByteBuffer.wrap((byte[])ByteArrayCache.getInstance().get(4096, true));
        int nb = this.readSync(buf);
        if (nb <= 0) {
            return null;
        }
        buf.flip();
        return buf;
    }
}

