/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale;

import java.io.Serializable;
import java.util.Arrays;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.locale.ILocalizableString;

public class LocalizableString
implements ILocalizableString {
    private static final long serialVersionUID = 1L;
    private String namespace;
    private String string;
    private Serializable[] values;

    public LocalizableString(String namespace, String string, Serializable ... values) {
        this.namespace = namespace;
        this.string = string;
        this.values = values;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getString() {
        return this.string;
    }

    public Serializable[] getValues() {
        return this.values;
    }

    @Override
    public AsyncSupplier<String, NoException> localize(String[] languageTag) {
        return LCCore.getApplication().getLocalizedProperties().localize(languageTag, this.namespace, this.string, this.values);
    }

    @Override
    public String localizeSync(String[] languageTag) {
        return LCCore.getApplication().getLocalizedProperties().localizeSync(languageTag, this.namespace, this.string, this.values);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LocalizableString)) {
            return false;
        }
        LocalizableString o = (LocalizableString)obj;
        return this.namespace.equals(o.namespace) && this.string.equals(o.string) && Arrays.equals(this.values, o.values);
    }

    public int hashCode() {
        return this.string.hashCode();
    }
}

