/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.locale.annotations;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import net.lecousin.framework.locale.FixedLocalizedString;
import net.lecousin.framework.locale.ILocalizableString;
import net.lecousin.framework.locale.LocalizableString;
import net.lecousin.framework.locale.annotations.LocalizableNamespace;
import net.lecousin.framework.locale.annotations.LocalizableProperty;
import net.lecousin.framework.properties.Property;

public final class LocalizableAnnotations {
    private LocalizableAnnotations() {
    }

    public static ILocalizableString get(AnnotatedElement element, String name) {
        for (LocalizableProperty localizableProperty : (LocalizableProperty[])element.getAnnotationsByType(LocalizableProperty.class)) {
            if (!localizableProperty.name().equals(name)) continue;
            String ns = localizableProperty.namespace();
            if (ns.isEmpty()) {
                LocalizableNamespace lns = element.getAnnotation(LocalizableNamespace.class);
                if (lns == null && element instanceof Member) {
                    lns = ((Member)((Object)element)).getDeclaringClass().getAnnotation(LocalizableNamespace.class);
                }
                if (lns != null) {
                    ns = lns.value();
                }
            }
            String[] values = localizableProperty.values();
            Serializable[] v = new Serializable[values.length];
            System.arraycopy(values, 0, v, 0, values.length);
            return new LocalizableString(ns, localizableProperty.key(), v);
        }
        for (Annotation annotation : (Property[])element.getAnnotationsByType(Property.class)) {
            if (!annotation.name().equals(name)) continue;
            return new FixedLocalizedString(annotation.value());
        }
        return null;
    }
}

