/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.DebugUtil;

public class LogPattern {
    private Section[] parts;
    private boolean needsThreadName = false;
    private boolean needsLocation = false;

    public LogPattern(String pattern) {
        this.parsePattern(pattern);
    }

    public boolean needsThreadName() {
        return this.needsThreadName;
    }

    public boolean needsLocation() {
        return this.needsLocation;
    }

    public StringBuilder generate(Log log) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].append(s, log);
        }
        if (log.trace != null) {
            LogPattern.appendStack(s, log.trace);
        }
        return s;
    }

    private static void appendStack(StringBuilder s, Throwable t) {
        s.append('\n');
        DebugUtil.createStackTrace(s, t, true);
    }

    private void parsePattern(String pattern) {
        LinkedList<Section> sections = new LinkedList<Section>();
        int pos = 0;
        int len = pattern.length();
        block12: while (pos < len) {
            int i = pattern.indexOf(37, pos);
            if (i > pos) {
                sections.add(new StringSection(pattern.substring(pos, i)));
                pos = i;
            } else if (i < 0) {
                sections.add(new StringSection(pattern.substring(pos)));
                break;
            }
            if (pos == len - 1) {
                sections.add(new StringSection("%"));
                break;
            }
            char c = pattern.charAt(pos + 1);
            switch (c) {
                case 'a': {
                    pos = LogPattern.parsePatternA(pattern, pos, len, sections);
                    continue block12;
                }
                case 'd': {
                    pos = LogPattern.parsePatternD(pattern, pos, len, sections);
                    continue block12;
                }
                case 'f': {
                    sections.add(new FileNameSection());
                    this.needsLocation = true;
                    pos += 2;
                    continue block12;
                }
                case 't': {
                    sections.add(new ThreadNameSection());
                    this.needsThreadName = true;
                    pos += 2;
                    continue block12;
                }
                case 'l': {
                    pos = LogPattern.parsePatternL(pattern, pos, len, sections);
                    continue block12;
                }
                case 'm': {
                    sections.add(new MessageSection());
                    pos += 2;
                    continue block12;
                }
                case 'C': {
                    sections.add(new ClassNameSection());
                    this.needsLocation = true;
                    pos += 2;
                    continue block12;
                }
                case 'L': {
                    sections.add(new LineSection());
                    this.needsLocation = true;
                    pos += 2;
                    continue block12;
                }
                case 'M': {
                    sections.add(new MethodNameSection());
                    this.needsLocation = true;
                    pos += 2;
                    continue block12;
                }
                case '%': {
                    sections.add(new StringSection("%"));
                    pos += 2;
                    continue block12;
                }
            }
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            pos += 2;
        }
        LogPattern.concatenateStrings(sections);
        this.parts = sections.toArray(new Section[sections.size()]);
    }

    private static void concatenateStrings(List<Section> sections) {
        StringSection previous = null;
        Iterator<Section> it = sections.iterator();
        while (it.hasNext()) {
            Section s = it.next();
            if (s instanceof StringSection) {
                if (previous == null) {
                    previous = (StringSection)s;
                    continue;
                }
                StringSection stringSection = previous;
                stringSection.str = stringSection.str + ((StringSection)s).str;
                it.remove();
                continue;
            }
            previous = null;
        }
    }

    private static boolean isMatching(String pattern, int pos, int len, String toMatch, int from) {
        if (pos > len - (from + toMatch.length())) {
            return false;
        }
        for (int i = 0; i < toMatch.length(); ++i) {
            if (pattern.charAt(pos + from + i) == toMatch.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static int parsePatternA(String pattern, int pos, int len, List<Section> sections) {
        if (pos + 10 >= len) {
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            return pos + 2;
        }
        char c = pattern.charAt(pos + 2);
        switch (c) {
            case 'p': {
                if (!LogPattern.isMatching(pattern, pos, len, "plication", 3)) break;
                if (pos <= len - 13 && pattern.charAt(pos + 12) == '{') {
                    int i = pattern.indexOf(125, pos + 13);
                    if (i < 0) {
                        sections.add(new ApplicationSection(-1));
                        return pos + 12;
                    }
                    int size = -1;
                    try {
                        size = Integer.parseInt(pattern.substring(pos + 13, i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sections.add(new ApplicationSection(size));
                    return i + 1;
                }
                sections.add(new ApplicationSection(-1));
                return pos + 12;
            }
            case 'r': {
                if (!LogPattern.isMatching(pattern, pos, len, "tifactId", 3)) break;
                if (pos <= len - 12 && pattern.charAt(pos + 11) == '{') {
                    int i = pattern.indexOf(125, pos + 12);
                    if (i < 0) {
                        sections.add(new ArtifactIdSection(-1));
                        return pos + 11;
                    }
                    int size = -1;
                    try {
                        size = Integer.parseInt(pattern.substring(pos + 12, i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sections.add(new ArtifactIdSection(size));
                    return i + 1;
                }
                sections.add(new ArtifactIdSection(-1));
                return pos + 11;
            }
        }
        sections.add(new StringSection(pattern.substring(pos, pos + 2)));
        return pos + 2;
    }

    private static int parsePatternD(String pattern, int pos, int len, List<Section> sections) {
        if (pos + 3 >= len || pattern.charAt(pos + 2) != '{') {
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            return pos + 2;
        }
        int i = pattern.indexOf(125, pos + 3);
        if (i < 0) {
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            return pos + 2;
        }
        String format = pattern.substring(pos + 3, i);
        sections.add(new DateSection(format));
        return i + 1;
    }

    private static int parsePatternL(String pattern, int pos, int len, List<Section> sections) {
        if (pos + 5 >= len) {
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            return pos + 2;
        }
        char c = pattern.charAt(pos + 2);
        if (c == 'e') {
            if (pattern.charAt(pos + 3) == 'v' && pattern.charAt(pos + 4) == 'e' && pattern.charAt(pos + 5) == 'l') {
                sections.add(new LevelSection());
                return pos + 6;
            }
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            return pos + 2;
        }
        if (c == 'o') {
            if (LogPattern.isMatching(pattern, pos, len, "gger", 3)) {
                if (pos <= len - 8 && pattern.charAt(pos + 7) == '{') {
                    int i = pattern.indexOf(125, pos + 8);
                    if (i < 0) {
                        sections.add(new LoggerSection(-1));
                        return pos + 7;
                    }
                    int size = -1;
                    try {
                        size = Integer.parseInt(pattern.substring(pos + 8, i));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    sections.add(new LoggerSection(size));
                    return i + 1;
                }
                sections.add(new LoggerSection(-1));
                return pos + 7;
            }
            sections.add(new StringSection(pattern.substring(pos, pos + 2)));
            return pos + 2;
        }
        sections.add(new StringSection(pattern.substring(pos, pos + 2)));
        return pos + 2;
    }

    private static class ArtifactIdSection
    implements Section {
        private int fixedSize;

        private ArtifactIdSection(int fixedSize) {
            if (fixedSize > 0 && fixedSize < 3) {
                fixedSize = 3;
            }
            this.fixedSize = fixedSize;
        }

        @Override
        public void append(StringBuilder s, Log log) {
            String artifactId = log.app.getArtifactId();
            int len = artifactId.length();
            if (len == this.fixedSize || this.fixedSize <= 0) {
                s.append(artifactId);
            } else if (len < this.fixedSize) {
                s.append(artifactId);
                for (int i = len; i < this.fixedSize; ++i) {
                    s.append(' ');
                }
            } else {
                s.append("..").append(artifactId.substring(len - this.fixedSize + 2));
            }
        }
    }

    private static class ApplicationSection
    implements Section {
        private int fixedSize;

        private ApplicationSection(int fixedSize) {
            if (fixedSize > 0 && fixedSize < 3) {
                fixedSize = 3;
            }
            this.fixedSize = fixedSize;
        }

        @Override
        public void append(StringBuilder s, Log log) {
            String applicationName = log.app.getFullName();
            int len = applicationName.length();
            if (len == this.fixedSize || this.fixedSize <= 0) {
                s.append(applicationName);
            } else if (len < this.fixedSize) {
                s.append(applicationName);
                for (int i = len; i < this.fixedSize; ++i) {
                    s.append(' ');
                }
            } else {
                s.append("..").append(applicationName.substring(len - this.fixedSize + 2));
            }
        }
    }

    private static class LoggerSection
    implements Section {
        private int fixedSize;

        private LoggerSection(int fixedSize) {
            if (fixedSize > 0 && fixedSize < 3) {
                fixedSize = 3;
            }
            this.fixedSize = fixedSize;
        }

        @Override
        public void append(StringBuilder s, Log log) {
            int len = log.loggerName.length();
            if (len == this.fixedSize || this.fixedSize <= 0) {
                s.append(log.loggerName);
            } else if (len < this.fixedSize) {
                s.append(log.loggerName);
                for (int i = len; i < this.fixedSize; ++i) {
                    s.append(' ');
                }
            } else {
                s.append("..").append(log.loggerName.substring(len - this.fixedSize + 2));
            }
        }
    }

    private static class LevelSection
    implements Section {
        private LevelSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            String name = log.level.name();
            s.append(name);
            for (int i = name.length(); i < 5; ++i) {
                s.append(' ');
            }
        }
    }

    private static class FileNameSection
    implements Section {
        private FileNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getFileName());
        }
    }

    private static class LineSection
    implements Section {
        private LineSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getLineNumber());
        }
    }

    private static class MethodNameSection
    implements Section {
        private MethodNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getMethodName());
        }
    }

    private static class ClassNameSection
    implements Section {
        private ClassNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.location.getClassName());
        }
    }

    private static class DateSection
    implements Section {
        private SimpleDateFormat format;

        public DateSection(String format) {
            this.format = new SimpleDateFormat(format);
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(this.format.format(new Date(log.timestamp)));
        }
    }

    private static class ThreadNameSection
    implements Section {
        private ThreadNameSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.threadName);
        }
    }

    private static class MessageSection
    implements Section {
        private MessageSection() {
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(log.message);
        }
    }

    private static class StringSection
    implements Section {
        private String str;

        public StringSection(String str) {
            this.str = str;
        }

        @Override
        public void append(StringBuilder s, Log log) {
            s.append(this.str);
        }
    }

    private static interface Section {
        public void append(StringBuilder var1, Log var2);
    }

    public static class Log {
        public Logger.Level level;
        public String message;
        public Throwable trace;
        public String loggerName;
        public long timestamp;
        public String threadName;
        public StackTraceElement location;
        public Application app;
    }
}

