/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.log.appenders;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.lecousin.framework.concurrent.Console;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.log.LogPattern;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.log.LoggerConfigurationException;
import net.lecousin.framework.log.LoggerFactory;
import net.lecousin.framework.log.appenders.Appender;

public class ConsoleAppender
implements Appender {
    private Console console;
    private Logger.Level level;
    private LogPattern pattern;

    public ConsoleAppender(Console console, Logger.Level level, LogPattern pattern) {
        this.console = console;
        this.level = level;
        this.pattern = pattern;
    }

    public ConsoleAppender(LoggerFactory factory, XMLStreamReader reader, Map<String, Appender> appenders) throws LoggerConfigurationException, XMLStreamException {
        this.console = factory.getApplication().getConsole();
        String levelStr = null;
        String patternStr = null;
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String attrName = reader.getAttributeLocalName(i);
            String attrValue = reader.getAttributeValue(i);
            if ("level".equals(attrName)) {
                levelStr = attrValue;
                continue;
            }
            if ("pattern".equals(attrName)) {
                patternStr = attrValue;
                continue;
            }
            if ("name".equals(attrName) || "class".equals(attrName)) continue;
            throw new LoggerConfigurationException("Unknown attribute " + attrName);
        }
        if (levelStr == null) {
            throw new LoggerConfigurationException("Missing attribute level on console Appender");
        }
        try {
            this.level = Logger.Level.valueOf(levelStr);
        }
        catch (Exception t) {
            throw new LoggerConfigurationException("Invalid level " + levelStr);
        }
        if (patternStr == null) {
            throw new LoggerConfigurationException("Missing attribute pattern on console Appender");
        }
        this.pattern = new LogPattern(patternStr);
        reader.next();
        while (reader.getEventType() != 2) {
            if (reader.getEventType() == 1) {
                throw new LoggerConfigurationException("Unexpected inner element " + reader.getLocalName());
            }
            reader.next();
            if (reader.hasNext()) continue;
        }
    }

    @Override
    public void append(LogPattern.Log log) {
        String s = this.pattern.generate(log).toString();
        if (log.level.ordinal() >= Logger.Level.ERROR.ordinal()) {
            this.console.err(s);
        } else {
            this.console.out(s);
        }
    }

    @Override
    public int level() {
        return this.level.ordinal();
    }

    @Override
    public boolean needsThreadName() {
        return this.pattern.needsThreadName();
    }

    @Override
    public boolean needsLocation() {
        return this.pattern.needsLocation();
    }

    public IAsync<Exception> flush() {
        return new Async<boolean>(true);
    }
}

