/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import java.math.BigInteger;
import java.text.ParseException;
import net.lecousin.framework.text.StringParser;
import net.lecousin.framework.util.Pair;

public class RangeBigInteger {
    public BigInteger min;
    public BigInteger max;

    public RangeBigInteger(BigInteger min, BigInteger max) {
        this.min = min;
        this.max = max;
    }

    public RangeBigInteger(RangeBigInteger copy) {
        this.min = copy.min;
        this.max = copy.max;
    }

    @StringParser.Parse
    public RangeBigInteger(String string) throws ParseException {
        if (string == null || string.isEmpty()) {
            throw new ParseException("Empty string", 0);
        }
        char c = string.charAt(0);
        if (c == ']' || c == '[') {
            int sep = string.indexOf(45);
            if (sep < 0) {
                throw new ParseException("Must start with [ or ], followed by a number, a -, a number, and finally [ or ]", 1);
            }
            try {
                this.min = new BigInteger(string.substring(1, sep));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number: " + e.getMessage(), 1);
            }
            if (c == ']') {
                this.min = this.min.add(BigInteger.ONE);
            }
            if ((c = string.charAt(string.length() - 1)) != ']' && c != '[') {
                throw new ParseException("Must start with [ or ], followed by a number, a -, a number, and finally [ or ]", string.length() - 1);
            }
            try {
                this.max = new BigInteger(string.substring(sep + 1, string.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number! " + e.getMessage(), sep + 1);
            }
            if (c == '[') {
                this.max = this.max.subtract(BigInteger.ONE);
            }
            if (this.max.compareTo(this.min) < 0) {
                BigInteger i = this.min;
                this.min = this.max;
                this.max = i;
            }
        } else {
            try {
                this.min = this.max = new BigInteger(string);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number: " + e.getMessage(), 0);
            }
        }
    }

    public RangeBigInteger copy() {
        return new RangeBigInteger(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeBigInteger)) {
            return false;
        }
        RangeBigInteger r = (RangeBigInteger)obj;
        return r.min.equals(this.min) && r.max.equals(this.max);
    }

    public int hashCode() {
        return this.min.intValue();
    }

    public boolean contains(BigInteger value) {
        return value.compareTo(this.min) >= 0 && value.compareTo(this.max) <= 0;
    }

    public RangeBigInteger intersect(RangeBigInteger r) {
        if (this.min.compareTo(r.max) > 0) {
            return null;
        }
        if (this.max.compareTo(r.min) < 0) {
            return null;
        }
        return new RangeBigInteger(this.min.compareTo(r.min) <= 0 ? r.min : this.min, this.max.compareTo(r.max) <= 0 ? this.max : r.max);
    }

    public Pair<RangeBigInteger, RangeBigInteger> removeIntersect(RangeBigInteger o) {
        if (o.max.compareTo(this.min) < 0 || o.min.compareTo(this.max) > 0) {
            return new Pair<RangeBigInteger, Object>(this.copy(), null);
        }
        if (o.min.compareTo(this.min) <= 0) {
            if (o.max.compareTo(this.max) >= 0) {
                return new Pair<Object, Object>(null, null);
            }
            return new Pair<Object, RangeBigInteger>(null, new RangeBigInteger(o.max.add(BigInteger.ONE), this.max));
        }
        if (o.max.compareTo(this.max) >= 0) {
            return new Pair<RangeBigInteger, Object>(new RangeBigInteger(this.min, o.min.subtract(BigInteger.ONE)), null);
        }
        return new Pair<RangeBigInteger, RangeBigInteger>(new RangeBigInteger(this.min, o.min.subtract(BigInteger.ONE)), new RangeBigInteger(o.max.add(BigInteger.ONE), this.max));
    }

    public BigInteger getLength() {
        return this.max.subtract(this.min).add(BigInteger.ONE);
    }

    public String toString() {
        return "[" + this.min.toString() + "-" + this.max.toString() + "]";
    }

    public static class Parser
    implements StringParser<RangeBigInteger> {
        @Override
        public RangeBigInteger parse(String string) throws ParseException {
            return new RangeBigInteger(string);
        }
    }
}

