/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import java.text.ParseException;
import net.lecousin.framework.text.StringParser;
import net.lecousin.framework.util.Pair;

public class RangeLong {
    public long min;
    public long max;

    public RangeLong(long min, long max) {
        this.min = min;
        this.max = max;
    }

    public RangeLong(RangeLong copy) {
        this.min = copy.min;
        this.max = copy.max;
    }

    @StringParser.Parse
    public RangeLong(String string) throws ParseException {
        if (string == null || string.isEmpty()) {
            throw new ParseException("Empty string", 0);
        }
        char c = string.charAt(0);
        if (c == ']' || c == '[') {
            int sep = string.indexOf(45);
            if (sep < 0) {
                throw new ParseException("Must start with [ or ], followed by a number, a -, a number, and finally [ or ]", 1);
            }
            try {
                this.min = Long.parseLong(string.substring(1, sep));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number: " + e.getMessage(), 1);
            }
            if (c == ']') {
                ++this.min;
            }
            if ((c = string.charAt(string.length() - 1)) != ']' && c != '[') {
                throw new ParseException("Must start with [ or ], followed by a number, a -, a number, and finally [ or ]", string.length() - 1);
            }
            try {
                this.max = Long.parseLong(string.substring(sep + 1, string.length() - 1));
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number: " + e.getMessage(), sep + 1);
            }
            if (c == '[') {
                --this.max;
            }
            if (this.max < this.min) {
                long i = this.min;
                this.min = this.max;
                this.max = i;
            }
        } else {
            try {
                this.min = this.max = Long.parseLong(string);
            }
            catch (NumberFormatException e) {
                throw new ParseException("Invalid number: " + e.getMessage(), 0);
            }
        }
    }

    public RangeLong copy() {
        return new RangeLong(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RangeLong)) {
            return false;
        }
        RangeLong r = (RangeLong)obj;
        return r.min == this.min && r.max == this.max;
    }

    public int hashCode() {
        return (int)(this.min + this.max);
    }

    public boolean contains(long value) {
        return value >= this.min && value <= this.max;
    }

    public long getLength() {
        return this.max - this.min + 1L;
    }

    public RangeLong intersect(RangeLong r) {
        if (this.min > r.max) {
            return null;
        }
        if (this.max < r.min) {
            return null;
        }
        return new RangeLong(Math.max(this.min, r.min), Math.min(this.max, r.max));
    }

    public Pair<RangeLong, RangeLong> removeIntersect(RangeLong o) {
        if (o.max < this.min || o.min > this.max) {
            return new Pair<RangeLong, Object>(this.copy(), null);
        }
        if (o.min <= this.min) {
            if (o.max >= this.max) {
                return new Pair<Object, Object>(null, null);
            }
            return new Pair<Object, RangeLong>(null, new RangeLong(o.max + 1L, this.max));
        }
        if (o.max >= this.max) {
            return new Pair<RangeLong, Object>(new RangeLong(this.min, o.min - 1L), null);
        }
        return new Pair<RangeLong, RangeLong>(new RangeLong(this.min, o.min - 1L), new RangeLong(o.max + 1L, this.max));
    }

    public String toString() {
        return "[" + this.min + "-" + this.max + "]";
    }

    public static class Parser
    implements StringParser<RangeLong> {
        @Override
        public RangeLong parse(String string) throws ParseException {
            return new RangeLong(string);
        }
    }
}

