/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.collections.sort.RedBlackTreeInteger;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;

public abstract class ArrayCache<T>
implements IMemoryManageable {
    private int maxBuffersBySizeUnder128KB = 20;
    private int maxBuffersBySizeAbove128KB = 8;
    private int maxTotalSize = 0x4000000;
    private long timeBeforeToRemove = 300000L;
    private RedBlackTreeInteger<ArraysBySize<T>> arraysBySize = new RedBlackTreeInteger();
    private int totalSize = 0;
    private boolean debug = LCCore.getApplication().isDebugMode();

    public int getMaxBuffersBySizeUnder128KB() {
        return this.maxBuffersBySizeUnder128KB;
    }

    public void setMaxBuffersBySizeUnder128KB(int maxBuffersBySizeUnder128KB) {
        this.maxBuffersBySizeUnder128KB = maxBuffersBySizeUnder128KB;
    }

    public int getMaxBuffersBySizeAbove128KB() {
        return this.maxBuffersBySizeAbove128KB;
    }

    public void setMaxBuffersBySizeAbove128KB(int maxBuffersBySizeAbove128KB) {
        this.maxBuffersBySizeAbove128KB = maxBuffersBySizeAbove128KB;
    }

    public int getMaxTotalSize() {
        return this.maxTotalSize;
    }

    public void setMaxTotalSize(int maxTotalSize) {
        this.maxTotalSize = maxTotalSize;
    }

    public long getTimeBeforeToRemove() {
        return this.timeBeforeToRemove;
    }

    public void setTimeBeforeToRemove(long timeBeforeToRemove) {
        this.timeBeforeToRemove = timeBeforeToRemove;
    }

    protected ArrayCache() {
        MemoryManager.register(this);
    }

    protected abstract T allocate(int var1);

    protected abstract int length(T var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int size, boolean acceptGreater) {
        T buf;
        RedBlackTreeInteger<ArraysBySize<T>> redBlackTreeInteger = this.arraysBySize;
        synchronized (redBlackTreeInteger) {
            RedBlackTreeInteger.Node<ArraysBySize<Object>> node = acceptGreater ? this.arraysBySize.searchNearestHigher(size, true) : this.arraysBySize.get(size);
            if (node != null && acceptGreater && node.getValue() > size * 3 / 2) {
                node = null;
            }
            if (node == null) {
                buf = null;
            } else {
                ArraysBySize<T> arrays = node.getElement();
                ((ArraysBySize)arrays).lastUsageTime = System.currentTimeMillis();
                buf = ((ArraysBySize)arrays).arrays.poll();
                if (((ArraysBySize)arrays).arrays.isEmpty()) {
                    this.arraysBySize.remove(node);
                }
            }
        }
        if (buf == null) {
            try {
                return this.allocate(size);
            }
            catch (OutOfMemoryError e) {
                MemoryManager.freeMemory(IMemoryManageable.FreeMemoryLevel.URGENT);
                return this.allocate(size);
            }
        }
        this.totalSize -= this.length(buf);
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(T array) {
        int len = this.length(array);
        if (len < 16) {
            return;
        }
        RedBlackTreeInteger<ArraysBySize<T>> redBlackTreeInteger = this.arraysBySize;
        synchronized (redBlackTreeInteger) {
            if (this.totalSize + len > this.maxTotalSize) {
                return;
            }
            RedBlackTreeInteger.Node<ArraysBySize<T>> node = this.arraysBySize.get(len);
            if (node == null) {
                ArraysBySize arrays = new ArraysBySize();
                arrays.arrays = new TurnArray(len >= 131072 ? this.maxBuffersBySizeAbove128KB : this.maxBuffersBySizeUnder128KB);
                arrays.arrays.add(array);
                arrays.lastCachedTime = System.currentTimeMillis();
                this.arraysBySize.add(len, arrays);
                this.totalSize += len;
                return;
            }
            ArraysBySize<T> arrays = node.getElement();
            if (this.debug && ((ArraysBySize)arrays).arrays.contains(array)) {
                throw new IllegalStateException("Array already in cache!");
            }
            ((ArraysBySize)arrays).lastCachedTime = System.currentTimeMillis();
            if (((ArraysBySize)arrays).arrays.isFull()) {
                return;
            }
            this.totalSize += len;
            ((ArraysBySize)arrays).arrays.add(array);
        }
    }

    @Override
    public List<String> getItemsDescription() {
        return Arrays.asList("Total cached size: " + this.totalSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        long now = System.currentTimeMillis();
        switch (level) {
            default: {
                this.freeMemory(now - this.timeBeforeToRemove, 2);
                break;
            }
            case LOW: {
                this.freeMemory(now - this.timeBeforeToRemove / 2L, 4);
                break;
            }
            case MEDIUM: {
                this.freeMemory(now - this.timeBeforeToRemove / 3L, 10);
                break;
            }
            case URGENT: {
                RedBlackTreeInteger<ArraysBySize<T>> redBlackTreeInteger = this.arraysBySize;
                synchronized (redBlackTreeInteger) {
                    this.arraysBySize.clear();
                    this.totalSize = 0;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeMemory(long beforeTime, int nbToRemove) {
        LinkedList<RedBlackTreeInteger.Node> toRemove = new LinkedList<RedBlackTreeInteger.Node>();
        RedBlackTreeInteger<ArraysBySize<T>> redBlackTreeInteger = this.arraysBySize;
        synchronized (redBlackTreeInteger) {
            Iterator<RedBlackTreeInteger.Node<ArraysBySize<T>>> it = this.arraysBySize.nodeIterator();
            while (it.hasNext()) {
                RedBlackTreeInteger.Node node = it.next();
                ArraysBySize<T> arrays = node.getElement();
                if (((ArraysBySize)arrays).lastUsageTime >= beforeTime || ((ArraysBySize)arrays).lastCachedTime > beforeTime && ((ArraysBySize)arrays).arrays.size() <= 2) continue;
                for (int i = 0; i < nbToRemove && !((ArraysBySize)arrays).arrays.isEmpty(); ++i) {
                    ((ArraysBySize)arrays).arrays.poll();
                    this.totalSize -= node.getValue();
                }
                if (!((ArraysBySize)arrays).arrays.isEmpty()) continue;
                toRemove.add(node);
            }
            for (RedBlackTreeInteger.Node node : toRemove) {
                this.arraysBySize.remove(node);
            }
        }
    }

    private static class ArraysBySize<T> {
        private TurnArray<T> arrays;
        private long lastCachedTime;
        private long lastUsageTime;

        private ArraysBySize() {
        }
    }
}

