/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.lecousin.framework.memory.CacheManager;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.CloseableListenable;

public class Cache<Key, Value>
implements CacheManager {
    private String description;
    private Consumer<Value> freer;
    private HashMap<Key, Data<Value>> map = new HashMap();
    private HashMap<Value, Data<Value>> values = new HashMap();

    public Cache(String description, Consumer<Value> freer) {
        this.description = description;
        this.freer = freer;
        MemoryManager.register(this);
    }

    public synchronized Value get(Key key, CloseableListenable user) {
        final Data<Value> data = this.map.get(key);
        if (data == null) {
            return null;
        }
        ((Data)data).users.add(user);
        if (user != null) {
            user.addCloseListener(new Consumer<CloseableListenable>(){

                @Override
                public void accept(CloseableListenable event) {
                    event.removeCloseListener(this);
                    Cache.this.free(data.value, event);
                }
            });
        }
        return (Value)((Data)data).value;
    }

    public synchronized void free(Value value, CloseableListenable user) {
        Data<Value> data = this.values.get(value);
        if (data == null) {
            return;
        }
        ((Data)data).lastUsage = System.currentTimeMillis();
        ((Data)data).users.remove(user);
    }

    public synchronized void put(Key key, Value value, CloseableListenable firstUser) {
        if (this.map.containsKey(key)) {
            throw new IllegalStateException("Cannot put a value in Cache with an existing key: " + key);
        }
        if (this.values.containsKey(value)) {
            throw new IllegalStateException("Cannot put 2 times the same value in Cache: " + value);
        }
        Data data = new Data();
        data.value = value;
        data.lastUsage = System.currentTimeMillis();
        data.users.add(firstUser);
        this.map.put(key, data);
        this.values.put(value, data);
    }

    @Override
    public Collection<? extends CacheManager.CachedData> getCachedData() {
        return this.map.values();
    }

    @Override
    public synchronized boolean free(CacheManager.CachedData data) {
        Object value = ((Data)data).value;
        this.values.remove(value);
        Object key = null;
        for (Map.Entry<Key, Data<Value>> e : this.map.entrySet()) {
            if (e.getValue() != data) continue;
            key = e.getKey();
            break;
        }
        this.map.remove(key);
        if (this.freer != null) {
            this.freer.accept(value);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public synchronized List<String> getItemsDescription() {
        ArrayList<String> list = new ArrayList<String>(this.values.size());
        for (Data<Value> d : this.values.values()) {
            StringBuilder s = new StringBuilder();
            s.append(((Data)d).value.toString());
            s.append(" (last used ").append(System.currentTimeMillis() - ((Data)d).lastUsage).append("ms. ago)");
            s.append(" ").append(d.cachedDataCurrentUsage()).append(" users:");
            for (CloseableListenable user : ((Data)d).users) {
                s.append("\r\n    => " + user);
            }
            list.add(s.toString());
        }
        return list;
    }

    public synchronized void close() {
        for (Data<Value> d : this.map.values()) {
            this.freer.accept(((Data)d).value);
        }
        this.map.clear();
        this.values.clear();
        MemoryManager.unregister(this);
    }

    private static class Data<Value>
    implements CacheManager.CachedData {
        private ArrayList<CloseableListenable> users = new ArrayList();
        private Value value;
        private long lastUsage = 0L;

        private Data() {
        }

        @Override
        public int cachedDataCurrentUsage() {
            return this.users.size();
        }

        @Override
        public long cachedDataLastUsage() {
            return this.lastUsage;
        }
    }
}

