/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import net.lecousin.framework.io.data.ByteArray;
import net.lecousin.framework.io.data.Bytes;
import net.lecousin.framework.io.data.CharArray;
import net.lecousin.framework.memory.ByteArrayCache;
import net.lecousin.framework.text.ArrayStringBuffer;
import net.lecousin.framework.text.ByteArrayStringIso8859;
import net.lecousin.framework.text.IString;

public class ByteArrayStringIso8859Buffer
extends ArrayStringBuffer<ByteArrayStringIso8859, ByteArrayStringIso8859Buffer> {
    public ByteArrayStringIso8859Buffer() {
    }

    public ByteArrayStringIso8859Buffer(ByteArrayStringIso8859 string) {
        super(string);
    }

    public ByteArrayStringIso8859Buffer(Collection<ByteArrayStringIso8859> strings) {
        super(strings);
    }

    public ByteArrayStringIso8859Buffer(String s) {
        this.strings = new ByteArrayStringIso8859[1];
        this.lastUsed = 0;
        ((ByteArrayStringIso8859[])this.strings)[0] = new ByteArrayStringIso8859(s);
    }

    public ByteArrayStringIso8859Buffer(CharSequence s) {
        this.strings = new ByteArrayStringIso8859[1];
        this.lastUsed = 0;
        ((ByteArrayStringIso8859[])this.strings)[0] = new ByteArrayStringIso8859(s);
    }

    public ByteArrayStringIso8859Buffer(IString s) {
        this.strings = new ByteArrayStringIso8859[1];
        this.lastUsed = 0;
        ((ByteArrayStringIso8859[])this.strings)[0] = new ByteArrayStringIso8859(s);
    }

    protected ByteArrayStringIso8859[] allocateArray(int arraySize) {
        return new ByteArrayStringIso8859[arraySize];
    }

    @Override
    protected ByteArrayStringIso8859 createString(int initialCapacity) {
        return new ByteArrayStringIso8859(initialCapacity);
    }

    @Override
    protected ByteArrayStringIso8859 createString(CharSequence s) {
        return new ByteArrayStringIso8859(s);
    }

    @Override
    protected ByteArrayStringIso8859 createString(CharSequence s, int startPos, int endPos) {
        return new ByteArrayStringIso8859(s, startPos, endPos);
    }

    @Override
    protected ByteArrayStringIso8859 createString(char singleChar) {
        return new ByteArrayStringIso8859((byte)singleChar);
    }

    @Override
    protected ByteArrayStringIso8859 createString(char[] chars) {
        ByteArrayStringIso8859 s = new ByteArrayStringIso8859(chars.length);
        s.append(chars);
        return s;
    }

    @Override
    protected ByteArrayStringIso8859Buffer createBuffer() {
        return new ByteArrayStringIso8859Buffer();
    }

    @Override
    protected ByteArrayStringIso8859Buffer createBuffer(ByteArrayStringIso8859 s) {
        return new ByteArrayStringIso8859Buffer(s);
    }

    @Override
    protected ByteArrayStringIso8859Buffer createBuffer(List<ByteArrayStringIso8859> list) {
        return new ByteArrayStringIso8859Buffer((Collection<ByteArrayStringIso8859>)list);
    }

    @Override
    protected Class<ByteArrayStringIso8859> getArrayType() {
        return ByteArrayStringIso8859.class;
    }

    public ByteArrayStringIso8859Buffer append(byte c) {
        if (this.strings == null) {
            this.strings = this.allocateArray(8);
            ((ByteArrayStringIso8859[])this.strings)[0] = this.createString(this.newArrayStringCapacity);
            ((ByteArrayStringIso8859[])this.strings)[0].append(c);
            this.lastUsed = 0;
            return this;
        }
        if (((ByteArrayStringIso8859[])this.strings)[this.lastUsed].appendNoEnlarge(c)) {
            return this;
        }
        if (this.lastUsed < ((ByteArrayStringIso8859[])this.strings).length - 1) {
            ((ByteArrayStringIso8859[])this.strings)[++this.lastUsed] = this.createString(this.newArrayStringCapacity);
            ((ByteArrayStringIso8859[])this.strings)[this.lastUsed].append(c);
            return this;
        }
        ByteArrayStringIso8859[] a = this.allocateArray(++this.lastUsed + 8);
        System.arraycopy(this.strings, 0, a, 0, this.lastUsed);
        a[this.lastUsed] = this.createString(this.newArrayStringCapacity);
        a[this.lastUsed].append(c);
        this.strings = a;
        return this;
    }

    @Override
    public ByteArrayStringIso8859 copy() {
        byte[] copy = new byte[this.length()];
        this.fillIso8859Bytes(copy, 0);
        return new ByteArrayStringIso8859(copy);
    }

    @Override
    public CharArray[] asCharBuffers() {
        if (this.strings == null) {
            return new CharArray[0];
        }
        CharArray[] chars = new CharArray[this.lastUsed + 1];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = new CharArray(((ByteArrayStringIso8859[])this.strings)[i].toChars());
        }
        return chars;
    }

    public ByteArray[] asByteArrays() {
        if (this.strings == null) {
            return new ByteArray[0];
        }
        ByteArray[] chars = new ByteArray[this.lastUsed + 1];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = ((ByteArrayStringIso8859[])this.strings)[i].asByteArray();
        }
        return chars;
    }

    public ByteArray asByteArray() {
        if (this.strings == null) {
            return new ByteArray(new byte[0]);
        }
        if (this.lastUsed == 0) {
            return ((ByteArrayStringIso8859[])this.strings)[0].asByteArray();
        }
        int len = this.length();
        byte[] bytes = (byte[])ByteArrayCache.getInstance().get(len, true);
        this.fillIso8859Bytes(bytes);
        return new ByteArray.Writable(bytes, 0, len, true);
    }

    public ByteBuffer[] asByteBuffers() {
        if (this.strings == null) {
            return new ByteBuffer[0];
        }
        ByteBuffer[] chars = new ByteBuffer[this.lastUsed + 1];
        for (int i = 0; i <= this.lastUsed; ++i) {
            chars[i] = ((ByteArrayStringIso8859[])this.strings)[i].asByteBuffer();
        }
        return chars;
    }

    public ByteBuffer asByteBuffer() {
        return this.asByteArray().toByteBuffer();
    }

    public Bytes.Readable asReadableBytes() {
        return new ReadableBytes(0, this.length());
    }

    public Bytes.Writable asWritableBytes() {
        return new WritableBytes(this.length(), Integer.MAX_VALUE);
    }

    private class WritableBytes
    implements Bytes.Writable {
        private int pos;
        private int len;

        public WritableBytes(int pos, int length) {
            this.pos = pos;
            this.len = length;
        }

        @Override
        public ByteBuffer toByteBuffer() {
            return ByteArrayStringIso8859Buffer.this.asByteBuffer();
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public int position() {
            return this.pos;
        }

        @Override
        public void setPosition(int position) {
            if (position > ByteArrayStringIso8859Buffer.this.length()) {
                throw new IllegalArgumentException();
            }
            this.pos = position;
        }

        @Override
        public int remaining() {
            return this.len - this.pos;
        }

        @Override
        public void free() {
        }

        @Override
        public void put(byte b) {
            ByteArrayStringIso8859Buffer.this.append(b);
            ++this.pos;
        }

        @Override
        public void put(byte[] buffer, int offset, int length) {
            ByteArrayStringIso8859Buffer.this.append(new ByteArrayStringIso8859(buffer, offset, length, length));
            this.pos += length;
        }

        @Override
        public Bytes.Writable subBuffer(int startPosition, int length) {
            return new WritableBytes(startPosition, length);
        }
    }

    private class ReadableBytes
    implements Bytes.Readable {
        private int pos;
        private int len;

        private ReadableBytes(int pos, int len) {
            this.pos = pos;
            this.len = len;
        }

        @Override
        public void setPosition(int position) {
            this.pos = position;
        }

        @Override
        public int remaining() {
            return this.len - this.pos;
        }

        @Override
        public int position() {
            return this.pos;
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public void free() {
        }

        @Override
        public ByteBuffer toByteBuffer() {
            ByteBuffer b = ByteArrayStringIso8859Buffer.this.asByteBuffer();
            b.position(this.pos);
            return b;
        }

        @Override
        public Bytes.Readable subBuffer(int startPosition, int length) {
            return new ReadableBytes(startPosition, length);
        }

        @Override
        public byte getForward(int offset) {
            return (byte)ByteArrayStringIso8859Buffer.this.charAt(this.pos + offset);
        }

        @Override
        public void get(byte[] buffer, int offset, int length) {
            int p = 0;
            for (int i = 0; i <= ByteArrayStringIso8859Buffer.this.lastUsed; ++i) {
                int l = ((ByteArrayStringIso8859[])ByteArrayStringIso8859Buffer.this.strings)[i].length();
                if (p + l > this.pos) {
                    int o = this.pos - p;
                    int l2 = Math.min(l - o, length);
                    System.arraycopy(((ByteArrayStringIso8859[])ByteArrayStringIso8859Buffer.this.strings)[i].chars, ((ByteArrayStringIso8859[])ByteArrayStringIso8859Buffer.this.strings)[i].start + o, buffer, offset, l2);
                    if ((length -= l2) == 0) {
                        return;
                    }
                    offset += l2;
                    this.pos += l2;
                }
                p += l;
            }
        }

        @Override
        public byte get() {
            return (byte)ByteArrayStringIso8859Buffer.this.charAt(this.pos++);
        }
    }
}

