/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.lecousin.framework.text.IStringPattern;
import net.lecousin.framework.text.WildcardFilePattern;

public class PathPattern
implements IStringPattern {
    private ArrayList<WildcardFilePattern> patterns = new ArrayList();
    private int nbWildcards = 0;
    private int nbAny = 0;

    public PathPattern(String pattern) {
        int i;
        do {
            if ((i = pattern.indexOf(47)) < 0) {
                this.patterns.add(new WildcardFilePattern(pattern));
                ++this.nbWildcards;
                break;
            }
            String s = pattern.substring(0, i);
            if ("**".equals(s)) {
                this.patterns.add(null);
                ++this.nbAny;
                continue;
            }
            this.patterns.add(new WildcardFilePattern(s));
            ++this.nbWildcards;
        } while ((pattern = pattern.substring(i + 1)).length() > 0);
    }

    @Override
    public boolean matches(String path) {
        return this.matches(Arrays.asList(path.split("/")));
    }

    public boolean matches(List<String> path) {
        if (this.nbAny == 0 && path.size() != this.nbWildcards) {
            return false;
        }
        if (path.size() < this.nbWildcards) {
            return false;
        }
        return this.check(path, 0, 0, this.nbWildcards, this.nbAny);
    }

    public boolean matches(String[] path) {
        if (this.nbAny == 0 && path.length != this.nbWildcards) {
            return false;
        }
        if (path.length < this.nbWildcards) {
            return false;
        }
        return this.check(path, 0, 0, this.nbWildcards, this.nbAny);
    }

    private boolean check(List<String> path, int pathIndex, int pattIndex, int remainingWildcards, int remainingAny) {
        if (pattIndex >= this.patterns.size()) {
            return false;
        }
        WildcardFilePattern wc = this.patterns.get(pattIndex);
        if (wc != null) {
            if (!wc.matches(path.get(pathIndex))) {
                return false;
            }
            if (pathIndex == path.size() - 1) {
                return true;
            }
            return this.check(path, pathIndex + 1, pattIndex + 1, remainingWildcards - 1, remainingAny);
        }
        if (pattIndex == this.patterns.size() - 1) {
            return true;
        }
        int maxToSkip = path.size() - pathIndex - remainingWildcards;
        for (int i = 0; i <= maxToSkip; ++i) {
            if (!this.check(path, pathIndex + i, pattIndex + 1, remainingWildcards, remainingAny - 1)) continue;
            return true;
        }
        return false;
    }

    private boolean check(String[] path, int pathIndex, int pattIndex, int remainingWildcards, int remainingAny) {
        if (pattIndex >= this.patterns.size()) {
            return false;
        }
        WildcardFilePattern wc = this.patterns.get(pattIndex);
        if (wc != null) {
            if (!wc.matches(path[pathIndex])) {
                return false;
            }
            if (pathIndex == path.length - 1) {
                return true;
            }
            return this.check(path, pathIndex + 1, pattIndex + 1, remainingWildcards - 1, remainingAny);
        }
        if (pattIndex == this.patterns.size() - 1) {
            return true;
        }
        int maxToSkip = path.length - pathIndex - remainingWildcards;
        for (int i = 0; i <= maxToSkip; ++i) {
            if (!this.check(path, pathIndex + i, pattIndex + 1, remainingWildcards, remainingAny - 1)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Collection<PathPattern> patterns, List<String> path) {
        for (PathPattern pattern : patterns) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(Collection<PathPattern> patterns, String[] path) {
        for (PathPattern pattern : patterns) {
            if (!pattern.matches(path)) continue;
            return true;
        }
        return false;
    }
}

