/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.ListOfArrays;

public final class ClassUtil {
    private ClassUtil() {
    }

    public static Iterable<Field> getAllFields(Class<?> cl) {
        Field[] fields = cl.getDeclaredFields();
        ListOfArrays<Field> list = new ListOfArrays<Field>();
        if (fields.length > 0) {
            list.add(fields);
        }
        while ((cl = cl.getSuperclass()) != null) {
            fields = cl.getDeclaredFields();
            if (fields.length <= 0) continue;
            list.add((Field[])fields);
        }
        return list;
    }

    public static ArrayList<Field> getAllFieldsInheritedFirst(Class<?> cl) {
        ArrayList<Field[]> all = new ArrayList<Field[]>();
        Field[] fields = cl.getDeclaredFields();
        int total = fields.length;
        if (fields.length > 0) {
            all.add(fields);
        }
        while ((cl = cl.getSuperclass()) != null) {
            fields = cl.getDeclaredFields();
            total += fields.length;
            if (fields.length <= 0) continue;
            all.add(fields);
        }
        ArrayList<Field> result = new ArrayList<Field>(total);
        for (int i = all.size() - 1; i >= 0; --i) {
            Collections.addAll(result, (Object[])all.get(i));
        }
        return result;
    }

    public static ArrayList<Method> getAllMethodsInheritedFirst(Class<?> cl) {
        ArrayList<Method[]> all = new ArrayList<Method[]>();
        Method[] methods = cl.getDeclaredMethods();
        int total = methods.length;
        if (methods.length > 0) {
            all.add(methods);
        }
        while ((cl = cl.getSuperclass()) != null) {
            methods = cl.getDeclaredMethods();
            total += methods.length;
            if (methods.length <= 0) continue;
            all.add(methods);
        }
        ArrayList<Method> result = new ArrayList<Method>(total);
        for (int i = all.size() - 1; i >= 0; --i) {
            Collections.addAll(result, (Object[])all.get(i));
        }
        return result;
    }

    public static Field getField(Class<?> cl, String name) {
        do {
            Field[] fields;
            for (Field f : fields = cl.getDeclaredFields()) {
                if (!f.getName().equals(name)) continue;
                return f;
            }
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public static Method getSetter(Class<?> cl, String name) {
        name = name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method m : cl.getMethods()) {
            if (!m.getName().equals("set" + name) || m.getParameterTypes().length != 1 || (m.getModifiers() & 9) != 1) continue;
            return m;
        }
        return null;
    }

    public static Method getGetter(Class<?> cl, String name) {
        String n = name.substring(0, 1).toUpperCase() + name.substring(1);
        for (Method m : cl.getMethods()) {
            if (!m.getName().equals("get" + n) || m.getParameterTypes().length != 0 || (m.getModifiers() & 9) != 1) continue;
            return m;
        }
        Field f = ClassUtil.getField(cl, name);
        if (f == null) {
            return null;
        }
        if (Boolean.TYPE.equals(f.getType()) || Boolean.class.equals(f.getType())) {
            for (Method m : cl.getMethods()) {
                if (!m.getName().equals("is" + n) || m.getParameterTypes().length != 0 || (m.getModifiers() & 9) != 1 || !Boolean.TYPE.equals(m.getReturnType()) && !Boolean.class.equals(m.getReturnType())) continue;
                return m;
            }
        }
        return null;
    }

    public static String getPackageName(Class<?> cl) {
        String n = cl.getName();
        int i = n.lastIndexOf(46);
        if (i < 0) {
            return "";
        }
        return n.substring(0, i);
    }

    public static Method getMethodFor(Class<?> cl, String name, Object ... params) {
        Method[] methods;
        for (Method m : methods = cl.getMethods()) {
            Class<?>[] types;
            if (!m.getName().equals(name) || (types = m.getParameterTypes()).length != params.length) continue;
            boolean ok = true;
            for (int i = 0; i < params.length; ++i) {
                if (ClassUtil.isMethodParameterCompatibleWith(types[i], params[i])) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            return m;
        }
        return null;
    }

    public static boolean isMethodParameterCompatibleWith(Class<?> paramType, Object paramValue) {
        if (paramValue == null) {
            return !paramType.isPrimitive();
        }
        if (paramType.isAssignableFrom(paramValue.getClass())) {
            return true;
        }
        if (paramType.isPrimitive()) {
            if (paramType.equals(Boolean.TYPE) && paramValue instanceof Boolean) {
                return true;
            }
            if (paramType.equals(Byte.TYPE) && paramValue instanceof Byte) {
                return true;
            }
            if (paramType.equals(Short.TYPE) && paramValue instanceof Short) {
                return true;
            }
            if (paramType.equals(Integer.TYPE) && paramValue instanceof Integer) {
                return true;
            }
            if (paramType.equals(Long.TYPE) && paramValue instanceof Long) {
                return true;
            }
            if (paramType.equals(Float.TYPE) && paramValue instanceof Float) {
                return true;
            }
            if (paramType.equals(Double.TYPE) && paramValue instanceof Double) {
                return true;
            }
        }
        return false;
    }

    public static Method getMethod(Class<?> cl, String name) {
        for (Method m : cl.getMethods()) {
            if (!m.getName().equals(name)) continue;
            return m;
        }
        return null;
    }

    public static Method getMethod(Class<?> cl, String name, int nbParameters) {
        for (Method m : cl.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != nbParameters) continue;
            return m;
        }
        return null;
    }

    public static List<Method> getMethods(Class<?> cl, String name, int nbParameters) {
        LinkedList<Method> list = new LinkedList<Method>();
        for (Method m : cl.getMethods()) {
            if (!m.getName().equals(name) || m.getParameterTypes().length != nbParameters) continue;
            list.add(m);
        }
        return list;
    }

    public static boolean setFieldFromPath(Object object, String path, Object value) {
        String[] names = path.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            try {
                try {
                    Field f = object.getClass().getField(names[i]);
                    if ((f.getModifiers() & 1) != 0) {
                        if (i < names.length - 1) {
                            object = f.get(object);
                            continue;
                        }
                        f.set(object, value);
                        return true;
                    }
                }
                catch (NoSuchFieldException f) {
                    // empty catch block
                }
                if (i < names.length - 1) {
                    Method getter = ClassUtil.getGetter(object.getClass(), names[i]);
                    if (getter == null) {
                        return false;
                    }
                    object = getter.invoke(object, new Object[0]);
                    continue;
                }
                Method setter = ClassUtil.getSetter(object.getClass(), names[i]);
                if (setter == null) {
                    return false;
                }
                setter.invoke(object, value);
                continue;
            }
            catch (Exception t) {
                return false;
            }
        }
        return false;
    }

    public static Object getFieldFromPath(Object object, String path) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        String[] names = path.split("\\.");
        for (int i = 0; i < names.length; ++i) {
            Method getter;
            Object obj;
            try {
                Field f = object.getClass().getField(names[i]);
                if ((f.getModifiers() & 1) != 0) {
                    obj = f.get(object);
                    if (i < names.length - 1) {
                        if (obj == null) {
                            throw new NoSuchFieldException("Cannot get field " + path + " because field " + names[i] + " is null in class " + object.getClass().getName());
                        }
                        object = obj;
                        continue;
                    }
                    return obj;
                }
            }
            catch (NoSuchFieldException f) {
                // empty catch block
            }
            if ((getter = ClassUtil.getGetter(object.getClass(), names[i])) == null) {
                throw new NoSuchFieldException("Unknown field '" + names[i] + "' in class " + object.getClass().getName());
            }
            obj = getter.invoke(object, new Object[0]);
            if (i == names.length - 1) {
                return obj;
            }
            if (obj == null) {
                throw new NoSuchFieldException("Cannot get field " + path + " because field " + names[i] + " is null in class " + object.getClass().getName());
            }
            object = obj;
        }
        throw new NoSuchFieldException("Unknown field path '" + path + "'");
    }

    public static List<Annotation> getAllAnnotations(Class<?> clazz) {
        LinkedList<Annotation> list = new LinkedList<Annotation>();
        ClassUtil.getAllAnnotations(clazz, list);
        return list;
    }

    private static void getAllAnnotations(Class<?> clazz, List<Annotation> list) {
        Collections.addAll(list, clazz.getDeclaredAnnotations());
        if (clazz.getSuperclass() != null) {
            ClassUtil.getAllAnnotations(clazz.getSuperclass(), list);
        }
        for (Class<?> i : clazz.getInterfaces()) {
            ClassUtil.getAllAnnotations(i, list);
        }
    }

    public static List<Annotation> expandRepeatableAnnotations(Annotation[] list) {
        return ClassUtil.expandRepeatableAnnotations(Arrays.asList(list));
    }

    public static List<Annotation> expandRepeatableAnnotations(Iterable<Annotation> list) {
        LinkedList<Annotation> result = new LinkedList<Annotation>();
        for (Annotation a : list) {
            try {
                Repeatable r;
                Class<?> t;
                Method m = a.annotationType().getMethod("value", new Class[0]);
                if (m != null && m.getReturnType().isArray() && Annotation.class.isAssignableFrom(t = m.getReturnType().getComponentType()) && (r = t.getAnnotation(Repeatable.class)) != null && r.value().isAssignableFrom(a.getClass())) {
                    Collections.addAll(result, (Annotation[])m.invoke((Object)a, new Object[0]));
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            result.add(a);
        }
        return result;
    }
}

