/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

public final class CommandLine {
    private CommandLine() {
    }

    public static String getOptionValue(String[] args, String optionName) {
        String opt = "-" + optionName + "=";
        for (String arg : args) {
            if (!arg.startsWith(opt)) continue;
            return arg.substring(opt.length());
        }
        return null;
    }

    public static <T> void parse(String[] args, T context, ArgumentsConsumer<T>[][] steps) throws Exception {
        int index = 0;
        int stepIndex = 0;
        while (index < args.length) {
            if (stepIndex == steps.length) {
                throw new IllegalArgumentException("Unexpected argument: " + args[index]);
            }
            boolean found = false;
            for (ArgumentsConsumer<T> consumer : steps[stepIndex]) {
                if (!consumer.matches(args[index], context)) continue;
                found = true;
                int eaten = consumer.consume(args, index, context);
                index += eaten;
                break;
            }
            if (found) continue;
            ++stepIndex;
        }
    }

    public static interface ArgumentsConsumer<T> {
        public boolean matches(String var1, T var2);

        public int consume(String[] var1, int var2, T var3) throws Exception;
    }
}

