/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.function.Consumer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.Async;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.event.Event;
import net.lecousin.framework.util.CloseableListenable;
import net.lecousin.framework.util.IConcurrentCloseable;

public abstract class ConcurrentCloseable<TError extends Exception>
implements IConcurrentCloseable<TError> {
    private boolean open = true;
    private HashSet<IAsync<?>> pendingOperations = new HashSet(5);
    private Async<TError> closing = null;
    private Event<CloseableListenable> closeEvent = null;
    private int closeLocked = 0;
    private Async<TError> waitForClose = null;

    public abstract Task.Priority getPriority();

    protected abstract IAsync<TError> closeUnderlyingResources();

    protected abstract void closeResources(Async<TError> var1);

    public boolean isClosing() {
        return this.open && this.closing != null;
    }

    @Override
    public boolean isClosed() {
        return !this.open;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseListener(Consumer<CloseableListenable> listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closing == null && this.open) {
                if (this.closeEvent == null) {
                    this.closeEvent = new Event();
                }
                this.closeEvent.addListener(listener);
                return;
            }
        }
        listener.accept(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addCloseListener(Runnable listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closing == null && this.open) {
                if (this.closeEvent == null) {
                    this.closeEvent = new Event();
                }
                this.closeEvent.addListener(listener);
                return;
            }
        }
        listener.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCloseListener(Consumer<CloseableListenable> listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closeEvent == null) {
                return;
            }
            this.closeEvent.removeListener(listener);
            if (!this.closeEvent.hasListeners()) {
                this.closeEvent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeCloseListener(Runnable listener) {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closeEvent == null) {
                return;
            }
            this.closeEvent.removeListener(listener);
            if (!this.closeEvent.hasListeners()) {
                this.closeEvent = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean lockClose() {
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closing != null) {
                return false;
            }
            ++this.closeLocked;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockClose() {
        boolean unblock = false;
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (--this.closeLocked == 0) {
                unblock = this.waitForClose != null;
            }
        }
        if (unblock) {
            this.closeAsync();
        }
    }

    @Override
    public void close() throws Exception {
        if (this.closeLocked > 0) {
            return;
        }
        this.closeAsync();
        this.closing.blockThrow(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IAsync<TError> closeAsync() {
        ArrayList pending;
        ConcurrentCloseable concurrentCloseable = this;
        synchronized (concurrentCloseable) {
            if (this.closeLocked > 0) {
                if (this.waitForClose == null) {
                    this.waitForClose = new Async();
                }
                return this.waitForClose;
            }
            if (this.closing != null) {
                return this.closing;
            }
            this.closing = new Async();
        }
        Task.Priority prio = this.getPriority();
        JoinPoint jp = new JoinPoint();
        HashSet<IAsync<?>> hashSet = this.pendingOperations;
        synchronized (hashSet) {
            pending = new ArrayList(this.pendingOperations);
            this.pendingOperations.clear();
        }
        for (IAsync iAsync : pending) {
            jp.addToJoinNoException(iAsync);
        }
        IAsync<TError> underlying = this.closeUnderlyingResources();
        if (underlying != null) {
            jp.addToJoinNoException(underlying);
        }
        jp.start();
        jp.thenStart(Task.cpu("Closing resources", prio, t -> {
            ConcurrentCloseable concurrentCloseable = this;
            synchronized (concurrentCloseable) {
                this.open = false;
            }
            if (this.closeEvent != null) {
                this.closeEvent.fire(this);
                this.closeEvent = null;
            }
            Async<TError> closed = new Async<TError>();
            try {
                this.closeResources(closed);
            }
            catch (Exception e) {
                closed.cancel(new CancelException("closeResources error", e));
            }
            closed.onDone(() -> {
                if (jp.forwardIfNotSuccessful(this.closing)) {
                    return;
                }
                if (underlying != null && underlying.forwardIfNotSuccessful(this.closing)) {
                    return;
                }
                if (closed.forwardIfNotSuccessful(this.closing)) {
                    return;
                }
                this.closing.unblock();
            }, this.closing);
            return null;
        }), true);
        jp.listenTime(60000L, () -> {
            StringBuilder s = new StringBuilder();
            s.append("Closeable still waiting for pending operations: ").append(this);
            for (IAsync op : pending) {
                if (op.isDone()) continue;
                s.append("\n - ").append(op);
                for (Object o : op.getAllListeners()) {
                    s.append("\n    - ").append(o);
                }
            }
            if (underlying != null && !underlying.isDone()) {
                s.append("\n - closeUnderlyingResources");
            }
            LCCore.getApplication().getDefaultLogger().error(s.toString());
            jp.cancel(new CancelException("Closeable still waiting for pending operations after 1 minute, close forced"));
        });
        if (this.waitForClose != null) {
            this.closing.onDone(this.waitForClose);
        }
        return this.closing;
    }

    private static CancelException createCancellation() {
        return new CancelException("Resource closed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <TE extends Exception, T extends IAsync<TE>> T operation(T op) {
        if (op.isDone()) {
            return op;
        }
        if (this.closing != null) {
            op.cancel(ConcurrentCloseable.createCancellation());
            return op;
        }
        HashSet<IAsync<?>> hashSet = this.pendingOperations;
        synchronized (hashSet) {
            if (this.closing == null) {
                this.pendingOperations.add(op);
            }
        }
        if (this.closing != null) {
            op.cancel(ConcurrentCloseable.createCancellation());
            return op;
        }
        op.onDone(() -> {
            HashSet<IAsync<?>> hashSet = this.pendingOperations;
            synchronized (hashSet) {
                this.pendingOperations.remove(op);
            }
        });
        return op;
    }

    protected <TE extends Exception, TR> Task<TR, TE> operation(Task<TR, TE> task) {
        this.operation(task.getOutput());
        return task;
    }
}

