/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.async.IAsync;
import net.lecousin.framework.concurrent.async.JoinPoint;
import net.lecousin.framework.concurrent.tasks.drives.DirectoryReader;
import net.lecousin.framework.concurrent.threads.Task;
import net.lecousin.framework.concurrent.threads.TaskManager;
import net.lecousin.framework.concurrent.threads.Threading;
import net.lecousin.framework.io.util.FileInfo;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.util.Triple;

public abstract class DirectoryWalker<T> {
    private File root;
    private T rootObject;
    private DirectoryReader.Request request;
    private TaskManager taskManager;

    public DirectoryWalker(File root, T rootObject, DirectoryReader.Request request) {
        this.root = root;
        this.rootObject = rootObject;
        this.request = request;
        this.taskManager = Threading.getDrivesManager().getTaskManager(root);
    }

    public IAsync<IOException> start(Task.Priority priority, WorkProgress progress, long work) {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        jp.addToJoin(1);
        this.processDirectory("", this.root, this.rootObject, jp, priority, progress, work);
        jp.start();
        return jp;
    }

    protected void accessDenied(File dir, String path) {
    }

    protected abstract T directoryFound(T var1, FileInfo var2, String var3);

    protected abstract void fileFound(T var1, FileInfo var2, String var3);

    private void processDirectory(final String path, File dir, T object, JoinPoint<IOException> jp, Task.Priority priority, final WorkProgress prog, long work) {
        DirectoryReader reader = new DirectoryReader(dir, this.request, null){

            @Override
            public DirectoryReader.Result execute(Task<DirectoryReader.Result, AccessDeniedException> taskContext) throws AccessDeniedException, CancelException {
                if (prog != null) {
                    prog.setSubText(path);
                }
                return super.execute((Task)taskContext);
            }
        };
        AsyncSupplier<DirectoryReader.Result, AccessDeniedException> read = new Task<DirectoryReader.Result, AccessDeniedException>(this.taskManager, "Reading directory " + dir.getAbsolutePath(), priority, reader, null).start().getOutput();
        read.thenStart("DirectoryWalker", priority, task -> {
            if (read.hasError()) {
                this.accessDenied(dir, path);
                if (prog != null) {
                    prog.progress(work);
                }
                jp.joined();
                return null;
            }
            DirectoryReader.Result result = (DirectoryReader.Result)read.getResult();
            ArrayList<Triple<File, Object, String>> dirs = new ArrayList<Triple<File, Object, String>>(result.getNbDirectories());
            for (FileInfo f : result.getFiles()) {
                String p;
                String string = p = path.isEmpty() ? f.file.getName() : path + '/' + f.file.getName();
                if (f.isDirectory) {
                    Object o = this.directoryFound(object, f, p);
                    if (o == null) continue;
                    dirs.add(new Triple<File, Object, String>(f.file, o, p));
                    continue;
                }
                this.fileFound(object, f, p);
            }
            jp.addToJoin(dirs.size());
            int steps = dirs.size() + 1;
            long step = work / (long)steps--;
            long w = work - step;
            if (prog != null) {
                prog.progress(step);
            }
            for (Triple triple : dirs) {
                if (task.isCancelling()) {
                    throw task.getCancelEvent();
                }
                step = w / (long)steps--;
                w -= step;
                this.processDirectory((String)triple.getValue3(), (File)triple.getValue1(), triple.getValue2(), jp, priority, prog, step);
            }
            jp.joined();
            return null;
        }, true);
    }
}

