/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.util;

import java.util.List;
import java.util.function.Consumer;
import net.lecousin.framework.concurrent.async.AsyncSupplier;
import net.lecousin.framework.concurrent.threads.Task;

public interface HierarchyProvider {

    public static interface Asynchronous<ElementType> {
        public ElementType getParent(ElementType var1);

        public boolean mayHaveChildren(ElementType var1);

        public AsyncSupplier<Boolean, Exception> hasChildren(ElementType var1, boolean var2, Task.Priority var3);

        public AsyncSupplier<List<? extends ElementType>, Exception> getChildren(ElementType var1, boolean var2, Task.Priority var3);
    }

    public static interface Synchronous<ElementType> {
        public ElementType getParent(ElementType var1);

        public boolean mayHaveChildren(ElementType var1);

        public boolean hasChildren(ElementType var1, boolean var2);

        public List<? extends ElementType> getChildren(ElementType var1, boolean var2);

        default public void goThrough(ElementType element, Consumer<ElementType> listener) {
            listener.accept(element);
            for (ElementType child : this.getChildren(element, true)) {
                this.goThrough(child, listener);
            }
        }
    }
}

