/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.adapter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import net.lecousin.framework.adapter.Adapter;
import net.lecousin.framework.adapter.FileInfoToFile;
import net.lecousin.framework.adapter.FileInfoToPath;
import net.lecousin.framework.adapter.FileToIO;
import net.lecousin.framework.adapter.LinkedAdapter;
import net.lecousin.framework.plugins.ExtensionPoint;

public class AdapterRegistry
implements ExtensionPoint<Adapter> {
    private static AdapterRegistry instance;
    private ArrayList<Adapter> adapters = new ArrayList();

    public static AdapterRegistry get() {
        return instance;
    }

    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    public AdapterRegistry() {
        if (instance != null) {
            return;
        }
        instance = this;
        this.adapters.add(new FileToIO.Writable());
        this.adapters.add(new FileToIO.Readable());
        this.adapters.add(new FileInfoToFile());
        this.adapters.add(new FileInfoToPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPlugin(Adapter plugin) {
        ArrayList<Adapter> arrayList = this.adapters;
        synchronized (arrayList) {
            this.adapters.add(plugin);
        }
    }

    @Override
    public void allPluginsLoaded() {
    }

    @Override
    public Collection<Adapter> getPlugins() {
        return this.adapters;
    }

    @Override
    public Class<Adapter> getPluginClass() {
        return Adapter.class;
    }

    public <Input, Output> Output adapt(Input input, Class<Output> outputType) throws Exception {
        Class<?> inputType = input.getClass();
        Adapter<?, Output> a = this.findAdapter(input, inputType, outputType);
        if (a == null) {
            return null;
        }
        return a.adapt(input);
    }

    public boolean canAdapt(Object input, Class<?> outputType) {
        Class<?> inputType = input.getClass();
        Adapter<?, ?> a = this.findAdapter(input, inputType, outputType);
        return a != null;
    }

    public <Input, Output> Adapter<Input, Output> findAdapter(Object in, Class<Input> input, Class<Output> output) {
        ArrayList<Adapter> acceptInput = new ArrayList<Adapter>();
        ArrayList<Adapter> matching = new ArrayList<Adapter>();
        for (Adapter a : this.adapters) {
            if (!a.getInputType().isAssignableFrom(input) || !a.canAdapt(in)) continue;
            acceptInput.add(a);
            if (output.equals(a.getOutputType())) {
                return a;
            }
            if (!output.isAssignableFrom(a.getOutputType())) continue;
            matching.add(a);
        }
        if (acceptInput.isEmpty()) {
            return null;
        }
        if (matching.size() == 1) {
            return (Adapter)matching.get(0);
        }
        if (!matching.isEmpty()) {
            return AdapterRegistry.getBest(matching);
        }
        LinkedList<LinkedList<Adapter>> paths = this.findPathsTo(input, acceptInput, output);
        LinkedList<Adapter> best = null;
        while (!paths.isEmpty()) {
            LinkedList<Adapter> path = paths.removeFirst();
            if (best != null && best.size() <= path.size()) continue;
            Object o = in;
            boolean valid = true;
            int i = 0;
            for (Adapter a : path) {
                if (!a.canAdapt(o)) {
                    valid = false;
                    break;
                }
                if (i == path.size() - 1) break;
                ++i;
                try {
                    o = a.adapt(o);
                }
                catch (Exception e) {
                    valid = false;
                    break;
                }
            }
            if (!valid) continue;
            best = path;
        }
        if (best == null) {
            return null;
        }
        return new LinkedAdapter(best);
    }

    private static Adapter getBest(ArrayList<Adapter> list) {
        Adapter best = list.get(0);
        Class bestType = best.getOutputType();
        for (int i = 1; i < list.size(); ++i) {
            Adapter a = list.get(i);
            Class type = a.getOutputType();
            if (!bestType.isAssignableFrom(type)) continue;
            bestType = type;
            best = a;
        }
        return best;
    }

    private LinkedList<LinkedList<Adapter>> findPathsTo(Class<?> origin, ArrayList<Adapter> canUse, Class<?> target) {
        LinkedList<LinkedList<Adapter>> paths = new LinkedList<LinkedList<Adapter>>();
        ArrayList used = new ArrayList(1);
        used.add(origin);
        for (Adapter a : canUse) {
            Class type = a.getOutputType();
            LinkedList<LinkedList<Adapter>> subPaths = this.findPaths(type, target, used);
            for (LinkedList linkedList : subPaths) {
                linkedList.addFirst(a);
                paths.add(linkedList);
            }
        }
        return paths;
    }

    private LinkedList<LinkedList<Adapter>> findPaths(Class<?> from, Class<?> to, ArrayList<Class<?>> used) {
        LinkedList<LinkedList<Adapter>> paths = new LinkedList<LinkedList<Adapter>>();
        ArrayList<Adapter> possible = new ArrayList<Adapter>();
        for (Adapter a : this.adapters) {
            if (!a.getInputType().isAssignableFrom(from)) continue;
            Class out = a.getOutputType();
            if (to.isAssignableFrom(out)) {
                LinkedList<Adapter> list = new LinkedList<Adapter>();
                list.add(a);
                paths.add(list);
                continue;
            }
            boolean already = false;
            for (Class clazz : used) {
                if (!clazz.isAssignableFrom(out) && !out.isAssignableFrom(clazz)) continue;
                already = true;
                break;
            }
            if (already) continue;
            possible.add(a);
        }
        if (possible.isEmpty()) {
            return paths;
        }
        ArrayList newUsed = new ArrayList(used.size() + 1);
        newUsed.addAll(used);
        newUsed.add(from);
        for (Adapter a : possible) {
            LinkedList<LinkedList<Adapter>> subPaths = this.findPaths(a.getOutputType(), to, newUsed);
            for (LinkedList linkedList : subPaths) {
                linkedList.addFirst(a);
                paths.add(linkedList);
            }
        }
        return paths;
    }
}

