/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.StandaloneLCCore;
import net.lecousin.framework.application.libraries.LibrariesManager;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.AsyncCloseable;

public final class LCCore {
    private static Environment instance = null;
    private static Thread mainThread = null;
    private static boolean stop = false;
    private static TurnArray<Runnable> toDoInMainThread = new TurnArray(5);
    private static MainThreadExecutor mainThreadExecutor = new MainThreadExecutor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable toExecute) {
            TurnArray turnArray = toDoInMainThread;
            synchronized (turnArray) {
                toDoInMainThread.push(toExecute);
                toDoInMainThread.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Runnable pop() {
            TurnArray turnArray = toDoInMainThread;
            synchronized (turnArray) {
                return (Runnable)toDoInMainThread.pollFirst();
            }
        }
    };

    private LCCore() {
    }

    public static Environment get() {
        return instance;
    }

    public static synchronized void init(Environment env) {
        String protocols;
        if (instance != null) {
            throw new IllegalStateException("LCCore environment already exists");
        }
        instance = env;
        if (System.getProperty("org.apache.commons.logging.Log") == null) {
            try {
                LCCore.class.getClassLoader().loadClass("net.lecousin.framework.log.bridges.ApacheCommonsLogging");
                System.setProperty("org.apache.commons.logging.Log", "net.lecousin.framework.log.bridges.ApacheCommonsLogging");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((protocols = System.getProperty("java.protocol.handler.pkgs")) == null) {
            protocols = "";
        }
        if (!protocols.contains("net.lecousin.framework.protocols")) {
            if (protocols.length() > 0) {
                protocols = protocols + "|";
            }
            protocols = protocols + "net.lecousin.framework.protocols";
            System.setProperty("java.protocol.handler.pkgs", protocols);
        }
        instance.start();
        new Task.Cpu<Void, Exception>("Initializing framework tools", 4){

            @Override
            public Void run() {
                MemoryManager.init();
                return null;
            }
        }.start();
    }

    static synchronized void init(Application app) {
        if (instance == null) {
            StandaloneLCCore env = new StandaloneLCCore();
            env.add(app);
            LCCore.init(env);
        } else {
            instance.add(app);
        }
    }

    public static Application getApplication() {
        return instance.getApplication();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public static void stop(boolean forceJvmToStop) {
        stop = true;
        TurnArray<Runnable> turnArray = toDoInMainThread;
        synchronized (turnArray) {
            toDoInMainThread.notify();
        }
        if (instance != null) {
            instance.stop();
        }
        if (forceJvmToStop) {
            System.out.println("Stop JVM.");
            System.exit(0);
        }
    }

    public static void keepMainThread(Runnable toContinue) {
        mainThread = Thread.currentThread();
        Thread thread = new Thread(toContinue, "LC Core - Main");
        thread.start();
        LCCore.mainThreadLoop();
    }

    public static Thread getMainThread() {
        return mainThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void mainThreadLoop() {
        while (!stop) {
            Runnable todo = null;
            TurnArray<Runnable> turnArray = toDoInMainThread;
            synchronized (turnArray) {
                if (toDoInMainThread.isEmpty()) {
                    try {
                        toDoInMainThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                todo = toDoInMainThread.pop();
            }
            todo.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeInMainThread(Runnable toExecute) {
        Class<LCCore> clazz = LCCore.class;
        synchronized (LCCore.class) {
            mainThreadExecutor.execute(toExecute);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceMainThreadExecutor(MainThreadExecutor executor) {
        Class<LCCore> clazz = LCCore.class;
        synchronized (LCCore.class) {
            Runnable toExecute;
            MainThreadExecutor previous = mainThreadExecutor;
            mainThreadExecutor = executor;
            // ** MonitorExit[var2_1] (shouldn't be in output)
            while ((toExecute = previous.pop()) != null) {
                executor.execute(toExecute);
            }
            return;
        }
    }

    public static interface MainThreadExecutor {
        public void execute(Runnable var1);

        public Runnable pop();
    }

    public static interface Environment {
        public void start();

        public void add(Application var1);

        public Application getApplication();

        public void toClose(Closeable var1);

        public void toClose(AsyncCloseable<?> var1);

        public void closed(Closeable var1);

        public void closed(AsyncCloseable<?> var1);

        public LibrariesManager getSystemLibraries();

        public Logger getSystemLogger(String var1);

        default public Logger getThreadingLogger() {
            return this.getSystemLogger("Threading");
        }

        default public Logger getMemoryLogger() {
            return this.getSystemLogger("Memory");
        }

        public void stop();

        public boolean isStopping();
    }
}

