/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.util.ObjectUtil;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> Enumeration<T> enumeration(Iterator<T> iterator) {
        return new IteratorToEnumeration<T>(iterator);
    }

    public static <T> Iterable<T> iterable(Enumeration<T> enumeration) {
        LinkedList<T> list = new LinkedList<T>();
        while (enumeration.hasMoreElements()) {
            list.add(enumeration.nextElement());
        }
        return list;
    }

    public static <T> Iterator<T> iterator(final Enumeration<T> enumeration) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }
        };
    }

    public static <T> Iterable<T> singleTimeIterable(final Enumeration<T> enumeration) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return CollectionsUtil.iterator(enumeration);
            }
        };
    }

    public static boolean equals(List<?> list1, List<?> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<?> it1 = list1.iterator();
        Iterator<?> it2 = list2.iterator();
        while (it1.hasNext()) {
            if (ObjectUtil.equalsOrNull(it1.next(), it2.next())) continue;
            return false;
        }
        return true;
    }

    public static <T> void addAll(Collection<T> col, Enumeration<T> e) {
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
    }

    public static class IteratorToEnumeration<T>
    implements Enumeration<T> {
        private Iterator<T> it;

        public IteratorToEnumeration(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasMoreElements() {
            return this.it.hasNext();
        }

        @Override
        public T nextElement() {
            return this.it.next();
        }
    }
}

