/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.map;

import net.lecousin.framework.collections.map.ByteMap;

public class HalfByteHashMap<T>
implements ByteMap<T> {
    private int size = 0;
    private HalfByteArray<T>[] hashmap = new HalfByteArray[16];

    @Override
    public T get(byte key) {
        HalfByteArray<T> array = this.hashmap[key & 0xF];
        if (array == null) {
            return null;
        }
        int b = ((HalfByteArray)array).bytes.length;
        if (b == 1) {
            if (((HalfByteArray)array).bytes[0] != key) {
                return null;
            }
            return (T)((HalfByteArray)array).elements[0];
        }
        int a = 0;
        while (true) {
            int m = a + (b - a) / 2;
            if (key == ((HalfByteArray)array).bytes[m]) {
                return (T)((HalfByteArray)array).elements[m];
            }
            if (key < ((HalfByteArray)array).bytes[m]) {
                if (m == a) {
                    return null;
                }
                b = m;
                continue;
            }
            if (m == b - 1) {
                return null;
            }
            a = m + 1;
        }
    }

    @Override
    public T put(byte key, T element) {
        int index;
        HalfByteArray<T> array = this.hashmap[key & 0xF];
        if (array == null) {
            array = new HalfByteArray();
            HalfByteArray.access$002(array, new byte[]{key});
            HalfByteArray.access$102(array, new Object[]{element});
            this.hashmap[key & 0xF] = array;
            ++this.size;
            return null;
        }
        int b = ((HalfByteArray)array).bytes.length;
        if (b == 1) {
            Object[] ne;
            byte[] nb;
            if (key < ((HalfByteArray)array).bytes[0]) {
                nb = new byte[]{key, ((HalfByteArray)array).bytes[0]};
                ne = new Object[]{element, ((HalfByteArray)array).elements[0]};
            } else if (key > ((HalfByteArray)array).bytes[0]) {
                nb = new byte[]{((HalfByteArray)array).bytes[0], key};
                ne = new Object[]{((HalfByteArray)array).elements[0], element};
            } else {
                Object previous = ((HalfByteArray)array).elements[0];
                ((HalfByteArray)array).elements[0] = element;
                ++this.size;
                return (T)previous;
            }
            HalfByteArray.access$002(array, nb);
            HalfByteArray.access$102(array, ne);
            ++this.size;
            return null;
        }
        int a = 0;
        while (true) {
            int m = a + (b - a) / 2;
            if (key == ((HalfByteArray)array).bytes[m]) {
                Object previous = ((HalfByteArray)array).elements[m];
                ((HalfByteArray)array).elements[m] = element;
                ++this.size;
                return (T)previous;
            }
            if (key < ((HalfByteArray)array).bytes[m]) {
                if (m == a) {
                    index = a;
                    break;
                }
                b = m;
                continue;
            }
            if (m == b - 1) {
                index = b;
                break;
            }
            a = m + 1;
        }
        byte[] nb = new byte[((HalfByteArray)array).bytes.length + 1];
        Object[] ne = new Object[((HalfByteArray)array).bytes.length + 1];
        if (index > 0) {
            System.arraycopy(((HalfByteArray)array).bytes, 0, nb, 0, index);
            System.arraycopy(((HalfByteArray)array).elements, 0, ne, 0, index);
        }
        nb[index] = key;
        ne[index] = element;
        if (index < ((HalfByteArray)array).bytes.length) {
            System.arraycopy(((HalfByteArray)array).bytes, index, nb, index + 1, ((HalfByteArray)array).bytes.length - index);
            System.arraycopy(((HalfByteArray)array).elements, index, ne, index + 1, ((HalfByteArray)array).bytes.length - index);
        }
        HalfByteArray.access$002(array, nb);
        HalfByteArray.access$102(array, ne);
        ++this.size;
        return null;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean containsKey(byte key) {
        HalfByteArray<T> array = this.hashmap[key & 0xF];
        if (array == null) {
            return false;
        }
        int b = ((HalfByteArray)array).bytes.length;
        if (b == 1) {
            return ((HalfByteArray)array).bytes[0] == key;
        }
        int a = 0;
        while (true) {
            int m = a + (b - a) / 2;
            if (key == ((HalfByteArray)array).bytes[m]) {
                return true;
            }
            if (key < ((HalfByteArray)array).bytes[m]) {
                if (m == a) {
                    return false;
                }
                b = m;
                continue;
            }
            if (m == b - 1) {
                return false;
            }
            a = m + 1;
        }
    }

    @Override
    public T remove(byte key) {
        int m;
        HalfByteArray<T> array = this.hashmap[key & 0xF];
        if (array == null) {
            return null;
        }
        int b = ((HalfByteArray)array).bytes.length;
        if (b == 1) {
            if (((HalfByteArray)array).bytes[0] != key) {
                return null;
            }
            Object e = ((HalfByteArray)array).elements[0];
            this.hashmap[key & 0xF] = null;
            --this.size;
            return (T)e;
        }
        int a = 0;
        int index = -1;
        while (true) {
            m = a + (b - a) / 2;
            if (key == ((HalfByteArray)array).bytes[m]) break;
            if (key < ((HalfByteArray)array).bytes[m]) {
                if (m == a) {
                    return null;
                }
                b = m;
                continue;
            }
            if (m == b - 1) {
                return null;
            }
            a = m + 1;
        }
        index = m;
        Object e = ((HalfByteArray)array).elements[index];
        byte[] nb = new byte[((HalfByteArray)array).bytes.length - 1];
        Object[] ne = new Object[((HalfByteArray)array).bytes.length - 1];
        if (index > 0) {
            System.arraycopy(((HalfByteArray)array).bytes, 0, nb, 0, index);
            System.arraycopy(((HalfByteArray)array).elements, 0, ne, 0, index);
        }
        if (index < nb.length) {
            System.arraycopy(((HalfByteArray)array).bytes, index + 1, nb, index, nb.length - index);
            System.arraycopy(((HalfByteArray)array).elements, index + 1, ne, index, ne.length - index);
        }
        HalfByteArray.access$002(array, nb);
        HalfByteArray.access$102(array, ne);
        --this.size;
        return (T)e;
    }

    private static class HalfByteArray<T> {
        private byte[] bytes;
        private T[] elements;

        private HalfByteArray() {
        }

        static /* synthetic */ byte[] access$002(HalfByteArray x0, byte[] x1) {
            x0.bytes = x1;
            return x1;
        }

        static /* synthetic */ Object[] access$102(HalfByteArray x0, Object[] x1) {
            x0.elements = x1;
            return x1;
        }
    }
}

