/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.PrintStream;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;

public class Console
implements Closeable {
    private TurnArray<Object> stdout = new TurnArray(100);
    private TurnArray<Object> stderr = new TurnArray(50);
    private Thread thread;
    private boolean stop = false;
    private SynchronizationPoint<Exception> stopped = new SynchronizationPoint();
    private PrintStream out = System.out;
    private PrintStream err = System.err;

    public synchronized void out(String line) {
        this.stdout.addLast(line);
        this.notify();
    }

    public synchronized void out(Throwable t) {
        this.stdout.addLast(t);
        this.notify();
    }

    public synchronized void err(String line) {
        this.stderr.addLast(line);
        this.notify();
    }

    public synchronized void err(Throwable t) {
        this.stderr.addLast(t);
        this.notify();
    }

    public Console(final Application app) {
        this.thread = app.getThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (!Console.this.stop) {
                    Object err;
                    Object out = null;
                    Console console = Console.this;
                    synchronized (console) {
                        err = Console.this.stderr.pollFirst();
                        if (err == null && (out = Console.this.stdout.pollFirst()) == null) {
                            try {
                                Console.this.wait();
                            }
                            catch (InterruptedException e) {
                                break;
                            }
                        }
                    }
                    if (err != null) {
                        if (err instanceof CharSequence) {
                            Console.this.err.println(err);
                            continue;
                        }
                        if (!(err instanceof Throwable)) continue;
                        ((Throwable)err).printStackTrace(Console.this.err);
                        continue;
                    }
                    if (out instanceof CharSequence) {
                        Console.this.out.println((Object)out);
                        continue;
                    }
                    if (!(out instanceof Throwable)) continue;
                    ((Throwable)out).printStackTrace(Console.this.out);
                }
                while (!Console.this.stderr.isEmpty()) {
                    Console.this.err.println(Console.this.stderr.removeFirst());
                }
                while (!Console.this.stdout.isEmpty()) {
                    Console.this.out.println(Console.this.stdout.removeFirst());
                }
                System.out.println("Console stopped for " + app.getGroupId() + '/' + app.getArtifactId());
                Console.this.stopped.unblock();
            }
        });
        this.thread.setName("Console for " + app.getGroupId() + "." + app.getArtifactId() + " " + app.getVersion().toString());
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"NN_NAKED_NOTIFY"})
    public void close() {
        this.stop = true;
        Console console = this;
        synchronized (console) {
            this.notify();
        }
        this.stopped.block(0L);
    }
}

