/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskPriorityManager;

public class StandaloneTaskPriorityManager
implements TaskPriorityManager {
    private TurnArray<Task<?, ?>>[] ready;
    private byte nextPriority = (byte)8;
    private long lastIdle = -1L;
    private TaskManager taskManager;

    public StandaloneTaskPriorityManager() {
        this.ready = new TurnArray[8];
        for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
            this.ready[i] = new TurnArray(25);
        }
    }

    @Override
    public void setTaskManager(TaskManager taskManager) {
        this.taskManager = taskManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Task<?, ?> task) {
        StandaloneTaskPriorityManager standaloneTaskPriorityManager = this;
        synchronized (standaloneTaskPriorityManager) {
            this.ready[task.priority].addLast(task);
            if (this.nextPriority > task.priority) {
                this.nextPriority = task.priority;
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Task<?, ?> task) {
        StandaloneTaskPriorityManager standaloneTaskPriorityManager = this;
        synchronized (standaloneTaskPriorityManager) {
            return this.ready[task.priority].removeInstance(task);
        }
    }

    @Override
    public Task<?, ?> peekNextOrWait() {
        Task<?, ?> t;
        block11: {
            while (true) {
                if (this.nextPriority == 8) {
                    if (this.lastIdle < 0L) {
                        this.lastIdle = System.currentTimeMillis();
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    return null;
                }
                if (this.nextPriority == 7) {
                    long wait;
                    if (this.lastIdle < 0L) {
                        this.lastIdle = System.currentTimeMillis();
                    }
                    if ((wait = this.lastIdle + 1000L - System.currentTimeMillis()) > 50L) {
                        if (!this.taskManager.isStopping() && this.taskManager.getTransferTarget() == null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            return null;
                        }
                        return null;
                    }
                }
                if ((t = this.ready[this.nextPriority].pollFirst()) != null) break;
                this.nextPriority = (byte)(this.nextPriority + 1);
            }
            if (this.nextPriority >= 7 || t.executeEvery > 0L) break block11;
            this.lastIdle = -1L;
        }
        return t;
    }

    @Override
    public Task<?, ?> peekNext() {
        Task<?, ?> t;
        block3: {
            while (true) {
                if (this.nextPriority == 8) {
                    if (this.lastIdle < 0L) {
                        this.lastIdle = System.currentTimeMillis();
                    }
                    return null;
                }
                t = this.ready[this.nextPriority].pollFirst();
                if (t != null) break;
                this.nextPriority = (byte)(this.nextPriority + 1);
            }
            if (this.nextPriority >= 7 || t.executeEvery > 0L) break block3;
            this.lastIdle = -1L;
        }
        return t;
    }

    @Override
    public List<Task<?, ?>> removeAllPendingTasks() {
        LinkedList list = new LinkedList();
        for (int p = 0; p < 8; p = (int)((byte)(p + 1))) {
            while (!this.ready[p].isEmpty()) {
                list.add(this.ready[p].removeFirst());
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceStop() {
        this.nextPriority = (byte)8;
        TurnArray<Task<?, ?>>[] turnArrayArray = this.ready;
        synchronized (this.ready) {
            this.ready.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.nextPriority = (byte)8;
            for (int p = 0; p < 8; p = (int)((byte)(p + 1))) {
                if (this.ready[p].isEmpty()) continue;
                for (Task<?, ?> t : this.ready[p]) {
                    System.err.println("Task Manager " + this.taskManager.getName() + " stopped while the following task was remaining: " + t.description);
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRemainingTasks(boolean includingBackground) {
        int nb = 0;
        StandaloneTaskPriorityManager standaloneTaskPriorityManager = this;
        synchronized (standaloneTaskPriorityManager) {
            for (int p = 0; p < 8; p = (int)((byte)(p + 1))) {
                if (!includingBackground && p == 7) continue;
                nb += this.ready[p].size();
            }
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasRemainingTasks(boolean includingBackground) {
        StandaloneTaskPriorityManager standaloneTaskPriorityManager = this;
        synchronized (standaloneTaskPriorityManager) {
            for (int p = 0; p < 8; p = (int)((byte)(p + 1))) {
                if (!includingBackground && p == 7 || this.ready[p].isEmpty()) continue;
                return true;
            }
            return false;
        }
    }
}

