/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.TaskScheduler;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.ThreadingDebugHelper;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class Task<T, TError extends Exception> {
    public static final byte PRIORITY_TOP = 0;
    public static final byte PRIORITY_URGENT = 1;
    public static final byte PRIORITY_IMPORTANT = 2;
    public static final byte PRIORITY_RATHER_IMPORTANT = 3;
    public static final byte PRIORITY_NORMAL = 4;
    public static final byte PRIORITY_RATHER_LOW = 5;
    public static final byte PRIORITY_LOW = 6;
    public static final byte PRIORITY_BACKGROUND = 7;
    public static final byte NB_PRIORITES = 8;
    public static final byte STATUS_NOT_STARTED = 0;
    public static final byte STATUS_STARTED_WAITING = 1;
    public static final byte STATUS_STARTED_READY = 2;
    public static final byte STATUS_RUNNING = 3;
    public static final byte STATUS_BLOCKED = 4;
    public static final byte STATUS_EXECUTED = 5;
    public static final byte STATUS_DONE = 6;
    Application app;
    TaskManager manager;
    byte status;
    Output result = new Output();
    CancelException cancelling = null;
    RunnableWithParameter<Pair<T, TError>> ondone = null;
    String description;
    byte priority;
    long executeEvery;
    long nextExecution;
    private List<ISynchronizationPoint<?>> holdSP = null;
    @SuppressFBWarnings(value={"UWF_NULL_FIELD"}, justification="To be set by sub-classes if needed")
    protected JoinPoint<TError> taskJoin = null;

    public Task(TaskManager manager, String description, byte priority) {
        this(manager, description, priority, null);
    }

    public Task(TaskManager manager, final String description, byte priority, RunnableWithParameter<Pair<T, TError>> ondone) {
        this.app = LCCore.getApplication();
        this.manager = manager;
        this.description = description;
        this.priority = priority;
        this.ondone = ondone;
        this.result.listenInline(new Runnable(){

            @Override
            public void run() {
                if (Task.this.app.isDebugMode() && Threading.traceTaskDone) {
                    Threading.logger.info("Task done: " + description);
                }
                if (Task.this.result.isCancelled() && Task.this.status < 3) {
                    Logger logger = Task.this.app.getLoggerFactory().getLogger("Threading");
                    if (logger.debug()) {
                        CancelException reason = Task.this.result.getCancelEvent();
                        logger.debug("Task cancelled: " + description + " => " + (reason != null ? reason.getMessage() : "No reason given"));
                    }
                    Task.this.cancel(Task.this.result.getCancelEvent());
                }
                Task.this.status = (byte)6;
            }
        });
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.newTask(this);
        }
    }

    public Task(Object resource, String description, byte priority, RunnableWithParameter<Pair<T, TError>> ondone) {
        this(Threading.get(resource), description, priority, ondone);
    }

    public Task(Object resource, String description, byte priority) {
        this(Threading.get(resource), description, priority, null);
    }

    public byte getStatus() {
        return this.status;
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String descr) {
        this.description = descr;
    }

    public Application getApplication() {
        return this.app;
    }

    public TaskManager getTaskManager() {
        return this.manager;
    }

    public abstract T run() throws TError, CancelException;

    void execute() {
        T res;
        if (this.cancelling != null) {
            this.status = (byte)6;
            this.result.cancelled(this.cancelling);
            this.checkSP();
            return;
        }
        try {
            res = this.run();
        }
        catch (CancelException e) {
            this.status = (byte)6;
            this.cancelling = e;
            this.result.cancelled(e);
            this.checkSP();
            return;
        }
        catch (Throwable t) {
            this.status = (byte)6;
            if (this.cancelling != null) {
                if (!this.result.isCancelled()) {
                    this.result.cancelled(this.cancelling);
                }
                if (this.app.isDebugMode()) {
                    this.app.getDefaultLogger().warn("Task " + this.description + " error while trying to cancel it: " + t.getMessage() + ", cancellation reason is " + this.result.getCancelEvent().getMessage(), t);
                }
            } else if (!this.result.isCancelled()) {
                if (this.app.isDebugMode()) {
                    this.app.getDefaultLogger().error("Task " + this.description + " error: " + t.getMessage(), t);
                }
                try {
                    Exception error = (Exception)t;
                    if (this.ondone != null) {
                        this.ondone.run(new Pair<Object, Exception>(null, error));
                    }
                    this.result.unblockError(error);
                }
                catch (ClassCastException e) {
                    this.cancelling = new CancelException("Unexpected exception thrown", t);
                    this.result.cancelled(this.cancelling);
                }
                catch (Throwable e) {
                    this.cancelling = new CancelException("Unexpected exception thrown", t);
                    this.result.cancelled(this.cancelling);
                }
            } else if (this.app.isDebugMode()) {
                this.app.getDefaultLogger().warn("Task " + this.description + " error after being cancelled: " + t.getMessage() + ", cancellation reason is " + this.result.getCancelEvent().getMessage(), t);
            }
            this.checkSP();
            return;
        }
        if (this.taskJoin == null) {
            this.status = (byte)6;
            try {
                if (this.ondone != null) {
                    this.ondone.run(new Pair<T, Object>(res, null));
                }
            }
            catch (Throwable t) {
                this.app.getDefaultLogger().error("Error while calling ondone on task " + this.description, t);
            }
            this.result.unblockSuccess(res);
            this.checkSP();
            return;
        }
        this.status = (byte)5;
        this.taskJoin.listenInline(new Runnable(){

            @Override
            public void run() {
                Task.this.status = (byte)6;
                if (Task.this.taskJoin.isCancelled()) {
                    Task.this.cancelling = Task.this.taskJoin.getCancelEvent();
                    Task.this.result.cancelled(Task.this.cancelling);
                } else if (Task.this.taskJoin.hasError()) {
                    if (Task.this.ondone != null) {
                        Task.this.ondone.run(new Pair(null, Task.this.taskJoin.getError()));
                    }
                    Task.this.result.unblockError(Task.this.taskJoin.getError());
                } else {
                    if (Task.this.ondone != null) {
                        Task.this.ondone.run(new Pair<Object, Object>(res, null));
                    }
                    Task.this.result.unblockSuccess(res);
                }
                Task.this.taskJoin = null;
                Task.this.checkSP();
            }
        });
        if (this.app.isDebugMode()) {
            this.taskJoin.listenTime(30000L, new Runnable(){

                @Override
                public void run() {
                    Task.this.app.getDefaultLogger().warn("Task " + Task.this.description + " is done, but still waiting for other works to be done after 30s.");
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleIfNeeded() {
        if (this.executeEvery > 0L && !TaskScheduler.stopping) {
            Task task = this;
            synchronized (task) {
                this.status = 0;
                this.executeIn(this.executeEvery);
            }
            TaskScheduler.schedule(this);
        } else if (this.nextExecution > 0L && !TaskScheduler.stopping) {
            Task task = this;
            synchronized (task) {
                this.status = 0;
            }
            TaskScheduler.schedule(this);
        }
    }

    private void checkSP() {
        if (this.holdSP == null) {
            return;
        }
        for (ISynchronizationPoint<?> sp : this.holdSP) {
            if (sp.isUnblocked()) continue;
            sp.cancel(new CancelException("Task " + this.description + " done without unblock this synchronization point"));
        }
        this.holdSP = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<T, TError> start() {
        if (this.cancelling != null) {
            this.result.cancelled(this.cancelling);
        }
        Task task = this;
        synchronized (task) {
            long now;
            if (this.result.isCancelled()) {
                return this;
            }
            if (this.status != 0) {
                if (this.status >= 6) {
                    throw new RuntimeException("Task already done: " + this.description + " with " + (this.result.getError() != null ? "error " + ((Throwable)this.result.getError()).getMessage() : "success"));
                }
                throw new RuntimeException("Task already started (" + this.status + "): " + this.description);
            }
            if (this.nextExecution > 0L && this.nextExecution > (now = System.currentTimeMillis())) {
                TaskScheduler.schedule(this);
                return this;
            }
            this.sendToTaskManager();
            return this;
        }
    }

    void sendToTaskManager() {
        while (this.manager.getTransferTarget() != null) {
            this.manager = this.manager.getTransferTarget();
        }
        this.status = (byte)2;
        this.manager.addReady(this);
    }

    public void cancel(CancelException reason) {
        if (this.cancelling != null) {
            return;
        }
        if (reason == null) {
            reason = new CancelException("No reason given");
        }
        this.cancelling = reason;
        if (TaskScheduler.cancel(this)) {
            this.status = (byte)6;
            this.result.cancelled(reason);
            return;
        }
        if (this.manager.remove(this)) {
            this.status = (byte)6;
            this.result.cancelled(reason);
            return;
        }
        if (this.status == 0) {
            this.status = (byte)6;
            this.result.cancelled(reason);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelIfExecutionNotStarted(CancelException reason) {
        Task task = this;
        synchronized (task) {
            if (this.status < 3) {
                this.cancel(reason);
                return true;
            }
        }
        return false;
    }

    public boolean isDone() {
        return this.status == 6 && this.result.isUnblocked();
    }

    public boolean isSuccessful() {
        return this.status == 6 && this.result.isSuccessful();
    }

    public boolean isCancelling() {
        return this.cancelling != null || this.result.isCancelled();
    }

    public boolean isCancelled() {
        return this.result.isCancelled();
    }

    public boolean isStarted() {
        return this.status > 0;
    }

    public boolean isRunning() {
        return this.status >= 3 && this.status < 6;
    }

    public T getResult() {
        return this.result.getResult();
    }

    public TError getError() {
        return this.result.getError();
    }

    public CancelException getCancelEvent() {
        return this.cancelling != null ? this.cancelling : this.result.getCancelEvent();
    }

    public boolean hasError() {
        return this.result.hasError();
    }

    @SuppressFBWarnings(value={"UG_SYNC_SET_UNSYNC_GET"})
    public byte getPriority() {
        return this.priority;
    }

    public synchronized void setPriority(byte priority) {
        if (this.priority == priority) {
            return;
        }
        if (this.status == 2 && this.manager.remove(this)) {
            this.priority = priority;
            while (this.manager.getTransferTarget() != null) {
                this.manager = this.manager.getTransferTarget();
            }
            this.manager.addReady(this);
            return;
        }
        this.priority = priority;
    }

    public Output getOutput() {
        return this.result;
    }

    public Task<T, TError> ensureUnblocked(ISynchronizationPoint<?> ... sp) {
        if (this.status == 6) {
            for (int i = 0; i < sp.length; ++i) {
                if (sp[i].isUnblocked()) continue;
                sp[i].cancel(new CancelException("Task " + this.description + " done without unblock this synchronization point"));
            }
            return this;
        }
        if (this.holdSP == null) {
            this.holdSP = new ArrayList(sp.length + 2);
        }
        for (int i = 0; i < sp.length; ++i) {
            this.holdSP.add(sp[i]);
        }
        return this;
    }

    public void executeAt(long time) {
        this.nextExecution = time;
    }

    public void executeIn(long delay) {
        this.executeAt(System.currentTimeMillis() + delay);
    }

    public void executeEvery(long delay, long initialDelay) {
        this.executeEvery = delay;
        this.executeIn(initialDelay);
    }

    public void stopRepeat() {
        this.executeEvery = 0L;
    }

    public void executeAgainIn(long delay) {
        this.executeAgainAt(System.currentTimeMillis() + delay);
    }

    public void executeAgainAt(long time) {
        this.nextExecution = time;
    }

    public synchronized void changeNextExecutionTime(long time) {
        if (this.status == 1) {
            TaskScheduler.changeNextExecutionTime(this, time);
        } else {
            this.nextExecution = time;
        }
    }

    public synchronized void executeNextOccurenceNow() {
        long now = System.currentTimeMillis();
        if (this.nextExecution > now) {
            this.changeNextExecutionTime(System.currentTimeMillis());
        }
    }

    public synchronized void executeNextOccurenceNow(byte priority) {
        this.setPriority(priority);
        this.executeNextOccurenceNow();
    }

    public void startOn(final ISynchronizationPoint<? extends Exception> sp, final boolean evenOnErrorOrCancel) {
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.waitingFor(this, sp);
        }
        sp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (evenOnErrorOrCancel) {
                    Task.this.start();
                    return;
                }
                if (sp.isCancelled()) {
                    Task.this.cancel(sp.getCancelEvent());
                } else if (sp.hasError()) {
                    try {
                        Object err = sp.getError();
                        Task.this.status = (byte)6;
                        Task.this.result.unblockError(err);
                    }
                    catch (ClassCastException e) {
                        Task.this.cancel(new CancelException("Error while waiting", (Throwable)sp.getError()));
                    }
                } else {
                    Task.this.start();
                }
            }
        });
    }

    public void startOn(final boolean evenOnErrorOrCancel, ISynchronizationPoint<?> ... list) {
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.waitingFor(this, list);
        }
        final JoinPoint jp = new JoinPoint();
        for (ISynchronizationPoint<?> sp : list) {
            if (sp == null) continue;
            jp.addToJoin(sp);
        }
        jp.start();
        jp.listenInline(new Runnable(){

            @Override
            public void run() {
                if (evenOnErrorOrCancel) {
                    Task.this.start();
                    return;
                }
                if (jp.isCancelled()) {
                    Task.this.cancel(jp.getCancelEvent());
                } else if (jp.hasError()) {
                    try {
                        Object err = jp.getError();
                        Task.this.status = (byte)6;
                        Task.this.result.unblockError(err);
                    }
                    catch (ClassCastException e) {
                        Task.this.cancel(new CancelException("Error while waiting", (Throwable)jp.getError()));
                    }
                } else {
                    Task.this.start();
                }
            }
        });
    }

    public void setDone(T result, TError error) {
        this.status = (byte)6;
        if (error == null) {
            this.result.unblockSuccess(result);
        } else {
            this.result.unblockError(error);
        }
    }

    public void ondone(Task<?, ?> todo, boolean evenIfErrorOrCancel) {
        if (this.app.isDebugMode() && Threading.traceTasksNotDone) {
            ThreadingDebugHelper.waitingFor(todo, this);
        }
        if (this.result.isCancelled()) {
            todo.cancel(this.result.getCancelEvent());
        } else if (this.result.hasError()) {
            todo.cancel(new CancelException((Throwable)this.result.getError()));
        } else if (this.result.isUnblocked()) {
            todo.start();
        } else {
            todo.startOn(this.result, evenIfErrorOrCancel);
        }
    }

    public String toString() {
        return super.toString() + "[" + this.description + "]";
    }

    public class Output
    extends AsyncWork<T, TError> {
        private Output() {
        }

        public Task<T, TError> getTask() {
            return Task.this;
        }

        @Override
        public void cancel(CancelException reason) {
            Task.this.cancel(reason);
        }

        void cancelled(CancelException reason) {
            super.cancel(reason);
        }

        public String toString() {
            return "Task synchronization point [" + Task.this.description + "]";
        }
    }

    public static class Done<T, TError extends Exception>
    extends Task<T, TError> {
        public Done(T result, TError error) {
            super(Threading.getCPUTaskManager(), "", (byte)4, null);
            this.setDone(result, error);
        }

        @Override
        public T run() {
            return null;
        }

        @Override
        public Task<T, TError> start() {
            return this;
        }
    }

    public static abstract class Parameter<TParam, TResult, TError extends Exception>
    extends Task<TResult, TError> {
        private TParam parameter;

        public Parameter(TaskManager tm, String description, byte priority, RunnableWithParameter<Pair<TResult, TError>> ondone) {
            super(tm, description, priority, ondone);
        }

        public Parameter(TaskManager tm, String description, byte priority) {
            super(tm, description, priority);
        }

        public TParam getParameter() {
            return this.parameter;
        }

        public void setParameter(TParam parameter) {
            this.parameter = parameter;
        }

        public void start(TParam parameter) {
            this.setParameter(parameter);
            this.start();
        }
    }

    public static abstract class Unmanaged<TResult, TError extends Exception>
    extends Task<TResult, TError> {
        public Unmanaged(String description, byte priority) {
            super(Threading.getUnmanagedTaskManager(), description, priority);
        }
    }

    public static abstract class OnFile<T, TError extends Exception>
    extends Task<T, TError> {
        public OnFile(File file, String description, byte priority, RunnableWithParameter<Pair<T, TError>> ondone) {
            super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority, ondone);
        }

        public OnFile(File file, String description, byte priority) {
            super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority);
        }

        public OnFile(TaskManager manager, String description, byte priority, RunnableWithParameter<Pair<T, TError>> ondone) {
            super(manager, description, priority, ondone);
        }

        public OnFile(TaskManager manager, String description, byte priority) {
            super(manager, description, priority);
        }

        public static abstract class Parameter<TParam, TResult, TError extends Exception>
        extends net.lecousin.framework.concurrent.Task$Parameter<TParam, TResult, TError> {
            public Parameter(File file, String description, byte priority, RunnableWithParameter<Pair<TResult, TError>> ondone) {
                super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority, ondone);
            }

            public Parameter(File file, String description, byte priority) {
                super(Threading.getDrivesTaskManager().getTaskManager(file), description, priority);
            }
        }
    }

    public static abstract class Cpu<T, TError extends Exception>
    extends Task<T, TError> {
        public Cpu(String description, byte priority, RunnableWithParameter<Pair<T, TError>> ondone) {
            super(Threading.getCPUTaskManager(), description, priority, ondone);
        }

        public Cpu(String description, byte priority) {
            super(Threading.getCPUTaskManager(), description, priority);
        }

        public static class FromRunnable
        extends Cpu<Void, NoException> {
            private Runnable runnable;

            public FromRunnable(Runnable runnable, String description, byte priority, RunnableWithParameter<Pair<Void, NoException>> ondone) {
                super(description, priority, ondone);
                this.runnable = runnable;
            }

            public FromRunnable(Runnable runnable, String description, byte priority) {
                super(description, priority);
                this.runnable = runnable;
            }

            public FromRunnable(String description, byte priority, Runnable runnable) {
                super(description, priority);
                this.runnable = runnable;
            }

            @Override
            public Void run() {
                this.runnable.run();
                return null;
            }
        }

        public static abstract class Parameter<TParam, TResult, TError extends Exception>
        extends net.lecousin.framework.concurrent.Task$Parameter<TParam, TResult, TError> {
            public Parameter(String description, byte priority, RunnableWithParameter<Pair<TResult, TError>> ondone) {
                super(Threading.getCPUTaskManager(), description, priority, ondone);
            }

            public Parameter(String description, byte priority) {
                super(Threading.getCPUTaskManager(), description, priority);
            }
        }
    }
}

