/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskPriorityManager;
import net.lecousin.framework.concurrent.Threading;

public abstract class TaskManager {
    private String name;
    private Object resource;
    protected ThreadFactory threadFactory;
    protected TaskPriorityManager taskPriorityManager;
    protected Object stopping = null;
    protected TaskManager transferredTo = null;
    protected boolean stopped = false;

    public TaskManager(String name, Object resource, ThreadFactory threadFactory, Class<? extends TaskPriorityManager> taskPriorityManager) {
        this.name = name;
        this.resource = resource;
        this.threadFactory = threadFactory;
        try {
            this.taskPriorityManager = taskPriorityManager.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException("Unable to instantiate TaskPriorityManager", t);
        }
        this.taskPriorityManager.setTaskManager(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object getResource() {
        return this.resource;
    }

    abstract void start();

    abstract void started();

    public TaskManager getTransferTarget() {
        return this.transferredTo;
    }

    final void shutdownWhenNoMoreTasks() {
        this.stopping = new Object();
        Thread t = new Thread("Stopping Task Manager: " + this.name){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                System.out.println("   * Stopping Task Manager: " + TaskManager.this.name);
                while (true) {
                    Object object = TaskManager.this.taskPriorityManager;
                    synchronized (object) {
                        if (!TaskManager.this.taskPriorityManager.hasRemainingTasks(false)) {
                            System.out.println("   * Task Manager has no more task to do: " + TaskManager.this.name);
                            TaskManager.this.finishAndStopThreads();
                            TaskManager.this.taskPriorityManager.notifyAll();
                            break;
                        }
                    }
                    System.out.println("   * Waiting for task manager " + TaskManager.this.name + " to finish its tasks");
                    object = TaskManager.this.stopping;
                    synchronized (object) {
                        try {
                            TaskManager.this.stopping.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            break;
                        }
                    }
                }
            }
        };
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void forceStop() {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.forceStopThreads();
            this.taskPriorityManager.forceStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void transferAndClose(TaskManager transferTo) {
        List<Task<?, ?>> list;
        Threading.logger.info("Transferring TaskManager " + this.name + " to " + transferTo.name);
        this.transferredTo = transferTo;
        Object object = this.taskPriorityManager;
        synchronized (object) {
            list = this.taskPriorityManager.removeAllPendingTasks();
        }
        for (Task task : list) {
            Threading.logger.debug("  - Task ready " + task.description + " transferred to " + transferTo.name);
            transferTo.addReady(task);
        }
        object = this.taskPriorityManager;
        synchronized (object) {
            this.finishAndStopThreads();
            this.taskPriorityManager.notifyAll();
        }
        this.finishTransfer();
        Threading.logger.info("End of transfer for TaskManager " + this.name + " to " + transferTo.name);
        this.stopped = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelAndStop() {
        List<Task<?, ?>> list;
        this.stopped = true;
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            this.forceStopThreads();
            this.taskPriorityManager.notifyAll();
        }
        TaskPriorityManager taskPriorityManager2 = this.taskPriorityManager;
        synchronized (taskPriorityManager2) {
            list = this.taskPriorityManager.removeAllPendingTasks();
        }
        for (Task task : list) {
            task.cancel(new CancelException("Stop Task Manager", null));
        }
    }

    final int getRemainingTasks(boolean includingBackground) {
        return this.taskPriorityManager.getRemainingTasks(includingBackground);
    }

    protected abstract void finishAndStopThreads();

    protected abstract void forceStopThreads();

    protected abstract void finishTransfer();

    abstract boolean isStopped();

    final boolean isStopping() {
        return this.stopping != null;
    }

    final void addReady(Task<?, ?> t) {
        if (this.stopped) {
            t.cancel(new CancelException("Task Manager already stopped", null));
        }
        this.add(t);
    }

    protected void add(Task<?, ?> t) {
        this.taskPriorityManager.add(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean remove(Task<?, ?> task) {
        TaskPriorityManager taskPriorityManager = this.taskPriorityManager;
        synchronized (taskPriorityManager) {
            if (this.taskPriorityManager.remove(task)) {
                return true;
            }
        }
        if (this.transferredTo != null) {
            do {
                task.manager = task.manager.transferredTo;
            } while (task.manager.transferredTo != null);
            taskPriorityManager = task.manager.taskPriorityManager;
            synchronized (taskPriorityManager) {
                return task.manager.taskPriorityManager.remove(task);
            }
        }
        return false;
    }

    public abstract void debug(StringBuilder var1);

    public abstract void printStats(StringBuilder var1);
}

