/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lecousin.framework.concurrent.Task;

public class FullReadFileTask
extends Task.OnFile<byte[], IOException> {
    private File file;

    public FullReadFileTask(File file, byte priority) {
        super(file, "Read full content of " + file.getAbsolutePath(), priority);
        this.file = file;
    }

    @Override
    public byte[] run() throws IOException {
        try (RandomAccessFile f = new RandomAccessFile(this.file, "r");){
            int nb;
            byte[] content = new byte[(int)this.file.length()];
            int pos = 0;
            while ((nb = f.read(content, pos, content.length - pos)) > 0 && (pos += nb) < content.length) {
            }
            f.close();
            byte[] byArray = content;
            return byArray;
        }
    }
}

