/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import net.lecousin.framework.collections.sort.RedBlackTreeInteger;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

class ReadFileTask
extends Task.OnFile<Integer, IOException> {
    private FileAccess file;
    private long pos;
    private ByteBuffer buffer;
    private boolean fully;
    private int nbRead = 0;
    private RedBlackTreeInteger<SynchronizationPoint<NoException>> waiting = null;
    private ArrayList<Listener<Integer>> onprogress = null;

    public ReadFileTask(FileAccess file, long pos, ByteBuffer buffer, boolean fully, byte priority, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        super(file.manager, "Read from file " + file.path + (pos >= 0L ? " at " + pos : ""), priority, ondone);
        this.file = file;
        this.pos = pos;
        this.buffer = buffer;
        this.fully = fully;
        file.openTask.ondone(this, false);
    }

    public int getCurrentNbRead() {
        return this.nbRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitNbRead(int nbRead) throws IOException {
        if (this.nbRead >= nbRead) {
            return this.nbRead;
        }
        if (this.getError() != null) {
            throw (IOException)this.getError();
        }
        if (this.isDone()) {
            return this.nbRead;
        }
        SynchronizationPoint sp = new SynchronizationPoint();
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (this.getError() != null) {
                throw (IOException)this.getError();
            }
            if (this.isDone()) {
                return this.nbRead;
            }
            if (this.waiting == null) {
                this.waiting = new RedBlackTreeInteger();
            }
            this.waiting.add(nbRead, sp);
        }
        sp.block(0L);
        if (this.getError() != null) {
            throw (IOException)this.getError();
        }
        return this.nbRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onprogress(Listener<Integer> listener) {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (this.nbRead > 0) {
                listener.fire(this.nbRead);
            }
            if (this.onprogress == null) {
                this.onprogress = new ArrayList(5);
            }
            this.onprogress.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer run() throws IOException, CancelException {
        try {
            if (!this.file.openTask.isSuccessful()) {
                throw (IOException)this.file.openTask.getError();
            }
            this.nbRead = 0;
            if (this.pos >= 0L) {
                try {
                    this.file.channel.position(this.pos);
                }
                catch (ClosedChannelException e) {
                    throw new CancelException("File has been closed");
                }
                catch (IOException e) {
                    throw new IOException("Unable to seek to position " + this.pos + " in file " + this.file.path, e);
                }
            }
            if (!this.fully) {
                try {
                    this.nbRead = this.file.channel.read(this.buffer);
                }
                catch (ClosedChannelException e) {
                    throw new CancelException("File has been closed");
                }
                this.callListeners();
            } else {
                this.nbRead = 0;
                while (this.buffer.remaining() > 0) {
                    int nb;
                    try {
                        nb = this.file.channel.read(this.buffer);
                    }
                    catch (ClosedChannelException e) {
                        throw new CancelException("File has been closed");
                    }
                    if (nb <= 0) break;
                    this.nbRead += nb;
                    this.callListeners();
                }
            }
            Integer n = this.nbRead;
            return n;
        }
        finally {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                if (this.waiting != null) {
                    for (SynchronizationPoint<NoException> sp : this.waiting) {
                        sp.unblock();
                    }
                    this.waiting = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callListeners() {
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (this.onprogress != null) {
                for (int i = this.onprogress.size() - 1; i >= 0; --i) {
                    this.onprogress.get(i).fire(this.nbRead);
                }
            }
            if (this.waiting != null) {
                RedBlackTreeInteger.Node<SynchronizationPoint<NoException>> min;
                while ((min = this.waiting.getMin()).getValue() <= this.nbRead) {
                    min.getElement().unblock();
                    this.waiting.removeMin();
                    if (!this.waiting.isEmpty()) continue;
                }
                if (this.waiting.isEmpty()) {
                    this.waiting = null;
                }
            }
        }
    }
}

