/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.geometry;

import net.lecousin.framework.geometry.Point2DInt;
import net.lecousin.framework.geometry.Rectangle2DInt;

public class Line2DInt {
    public Point2DInt p1;
    public Point2DInt p2;

    public Line2DInt(Point2DInt point1, Point2DInt point2) {
        this.p1 = point1;
        this.p2 = point2;
    }

    public Line2DInt(Line2DInt copy) {
        this(new Point2DInt(copy.p1), new Point2DInt(copy.p2));
    }

    public Rectangle2DInt getRectangle() {
        return new Rectangle2DInt(this.p1.x < this.p2.x ? this.p1.x : this.p2.x, this.p1.y < this.p2.y ? this.p1.y : this.p2.y, this.p1.x < this.p2.x ? this.p2.x - this.p1.x + 1 : this.p1.x - this.p2.x + 1, this.p1.y < this.p2.y ? this.p2.y - this.p1.y + 1 : this.p1.y - this.p2.y + 1);
    }

    public boolean contains(Point2DInt point, int tolerance) {
        if (!this.containsAbsolute(point, tolerance)) {
            return false;
        }
        return this.getRectangle().contains(point, tolerance);
    }

    public boolean containsAbsolute(Point2DInt point, int tolerance) {
        double[] eq = this.getEquation();
        return Math.abs(eq[0] * (double)point.x + eq[1] * (double)point.y - eq[2]) < (double)tolerance;
    }

    public Point2DInt getAbsoluteIntersection(Line2DInt line) {
        double[] temp = this.getEquation();
        double a1 = temp[0];
        double b1 = temp[1];
        double c1 = temp[2];
        temp = line.getEquation();
        double a2 = temp[0];
        double b2 = temp[1];
        double c2 = temp[2];
        double det = a1 * b2 - b1 * a2;
        if (det == 0.0) {
            return null;
        }
        return new Point2DInt((int)Math.round((c1 * b2 - b1 * c2) / det), (int)Math.round((a1 * c2 - c1 * a2) / det));
    }

    public boolean isHorizontal() {
        return this.p1.y == this.p2.y;
    }

    public boolean isVertical() {
        return this.p1.x == this.p2.x;
    }

    public boolean isOn(Line2DInt line) {
        if (this.isVertical()) {
            if (!line.isVertical()) {
                return false;
            }
            if (this.p1.x != line.p1.x) {
                return false;
            }
            double lmin = Math.min(line.p1.y, line.p2.y);
            double lmax = Math.max(line.p1.y, line.p2.y);
            return (double)this.p1.y > lmin && (double)this.p1.y < lmax || (double)this.p2.y > lmin && (double)this.p2.y < lmax;
        }
        if (this.isHorizontal()) {
            if (!line.isHorizontal()) {
                return false;
            }
            if (this.p1.y != line.p1.y) {
                return false;
            }
            double lmin = Math.min(line.p1.x, line.p2.x);
            double lmax = Math.max(line.p1.x, line.p2.x);
            return (double)this.p1.x > lmin && (double)this.p1.x < lmax || (double)this.p2.x > lmin && (double)this.p2.x < lmax;
        }
        if (!this.isOnAbsolute(line)) {
            return false;
        }
        Point2DInt[] i = this.getRectangle().getIntersectionPoints(line.getRectangle());
        return i == null || i.length != 1;
    }

    public boolean isOnAbsolute(Line2DInt line) {
        double a2;
        if (this.isVertical()) {
            return line.isVertical() && this.p1.x == line.p1.x;
        }
        if (this.isHorizontal()) {
            return line.isHorizontal() && this.p1.y == line.p1.y;
        }
        double[] temp = this.getEquation();
        double a1 = temp[0];
        double b1 = temp[1];
        temp = line.getEquation();
        double b2 = temp[1];
        double det = a1 * b2 - b1 * (a2 = temp[0]);
        return det == 0.0;
    }

    public double[] getEquation() {
        double[] equation = new double[3];
        for (int i = 0; i < 3; ++i) {
            equation[i] = 0.0;
        }
        if (this.p1.x == this.p2.x) {
            if (this.p1.y == this.p2.y) {
                return equation;
            }
            equation[0] = 1.0;
            equation[1] = 0.0;
            equation[2] = this.p1.x;
            return equation;
        }
        equation[0] = (double)(this.p1.y - this.p2.y) / (double)(this.p2.x - this.p1.x);
        equation[1] = 1.0;
        equation[2] = (double)this.p2.y + equation[0] * (double)this.p2.x;
        return equation;
    }

    public double getLength() {
        return this.p1.getDistance(this.p2);
    }

    public Point2DInt getIntersection(Line2DInt line) {
        Point2DInt pt = this.getAbsoluteIntersection(line);
        return pt == null ? null : (this.getRectangle().contains(pt) && line.getRectangle().contains(pt) ? pt : null);
    }

    public Point2DInt[] getIntersection(Rectangle2DInt r) {
        int j;
        boolean found;
        Line2DInt line1 = r.getLeftLine();
        Line2DInt line2 = r.getRightLine();
        Line2DInt line3 = r.getTopLine();
        Line2DInt line4 = r.getBottomLine();
        if (this.isOn(line1) || this.isOn(line2) || this.isOn(line3) || this.isOn(line4)) {
            return null;
        }
        Point2DInt[] pts = new Point2DInt[2];
        int i = 0;
        Point2DInt p = this.getIntersection(line1);
        if (p != null) {
            pts[i++] = p;
        }
        if ((p = this.getIntersection(line2)) != null) {
            found = false;
            for (j = 0; j < i && !found; ++j) {
                if (!pts[j].equals(p)) continue;
                found = true;
            }
            if (!found) {
                pts[i++] = p;
            }
        }
        if ((p = this.getIntersection(line3)) != null) {
            found = false;
            for (j = 0; j < i && !found; ++j) {
                if (!pts[j].equals(p)) continue;
                found = true;
            }
            if (!found) {
                pts[i++] = p;
            }
        }
        if ((p = this.getIntersection(line4)) != null) {
            found = false;
            for (j = 0; j < i && !found; ++j) {
                if (!pts[j].equals(p)) continue;
                found = true;
            }
            if (!found) {
                pts[i++] = p;
            }
        }
        Point2DInt[] result = new Point2DInt[i];
        while (i > 0) {
            result[--i] = pts[i];
        }
        return result;
    }

    public String toString() {
        return "[ " + this.p1.toString() + " ; " + this.p2.toString() + " ]";
    }
}

