/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.geometry;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;

@SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
public class Path2D {
    private ArrayList<Segment> segments = new ArrayList();

    public Path2D() {
    }

    public Path2D(Segment ... segments) {
        for (Segment s : segments) {
            this.segments.add(s);
        }
    }

    public List<Segment> getSegments() {
        return this.segments;
    }

    public void add(Segment s) {
        this.segments.add(s);
    }

    public void removeLastSegment() {
        this.segments.remove(this.segments.size() - 1);
    }

    public static class Close
    implements Segment {
    }

    public static class QuadTo
    implements Segment {
        public double cx;
        public double cy;
        public double x;
        public double y;

        public QuadTo(double cx, double cy, double x, double y) {
            this.cx = cx;
            this.cy = cy;
            this.x = x;
            this.y = y;
        }
    }

    public static class CubicTo
    implements Segment {
        public double cx1;
        public double cy1;
        public double cx2;
        public double cy2;
        public double x;
        public double y;

        public CubicTo(double cx1, double cy1, double cx2, double cy2, double x, double y) {
            this.cx1 = cx1;
            this.cy1 = cy1;
            this.cx2 = cx2;
            this.cy2 = cy2;
            this.x = x;
            this.y = y;
        }
    }

    public static class LineTo
    implements Segment {
        public double x;
        public double y;

        public LineTo(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static class MoveTo
    implements Segment {
        public double x;
        public double y;

        public MoveTo(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static interface Segment {
    }
}

