/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.geometry;

public class Point2DInt {
    public int x;
    public int y;

    public Point2DInt(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public Point2DInt(Point2DInt copy) {
        this.x = copy.x;
        this.y = copy.y;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public double getDistance(Point2DInt c) {
        double xl = this.x > c.x ? (double)(this.x - c.x) : (double)(c.x - this.x);
        double yl = this.y > c.y ? (double)(this.y - c.y) : (double)(c.y - this.y);
        return Math.hypot(xl, yl);
    }

    public Point2DInt translate(Point2DInt translation) {
        return new Point2DInt(this.x + translation.x, this.y + translation.y);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Point2DInt)) {
            return false;
        }
        Point2DInt c = (Point2DInt)obj;
        return this.x == c.x && this.y == c.y;
    }

    public int hashCode() {
        return this.x + this.y;
    }

    public String toString() {
        return "[" + this.x + "," + this.y + "]";
    }
}

