/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.geometry;

import net.lecousin.framework.geometry.Line2DInt;
import net.lecousin.framework.geometry.Point2DInt;

public class Rectangle2DInt {
    public Point2DInt position;
    public Point2DInt size;

    public Rectangle2DInt(int x, int y, int width, int height) {
        this(new Point2DInt(x, y), new Point2DInt(width, height));
    }

    public Rectangle2DInt(Point2DInt position, Point2DInt size) {
        this.position = position;
        this.size = size;
    }

    public Rectangle2DInt(Rectangle2DInt copy) {
        this(new Point2DInt(copy.position), new Point2DInt(copy.size));
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Rectangle2DInt)) {
            return false;
        }
        Rectangle2DInt o = (Rectangle2DInt)obj;
        return this.position.equals(o.position) && this.size.equals(o.size);
    }

    public int hashCode() {
        return this.position.hashCode();
    }

    public String toString() {
        return "[x:" + this.position.x + ",y:" + this.position.y + ",w:" + this.size.x + ",h:" + this.size.y + "]";
    }

    public boolean contains(Point2DInt point) {
        return point.x >= this.position.x && point.x < this.position.x + this.size.x && point.y >= this.position.y && point.y < this.position.y + this.size.y;
    }

    public boolean contains(int px, int py) {
        return px >= this.position.x && px < this.position.x + this.size.x && py >= this.position.y && py < this.position.y + this.size.y;
    }

    public boolean contains(Point2DInt point, int tolerance) {
        return point.x + tolerance >= this.position.x && point.x - tolerance < this.position.x + this.size.x && point.y + tolerance >= this.position.y && point.y - tolerance < this.position.y + this.size.y;
    }

    public boolean contains(Rectangle2DInt r) {
        return r.position.x >= this.position.x && r.position.x + r.size.x <= this.position.x + this.size.x && r.position.y >= this.position.y && r.position.y + r.size.y <= this.position.y + this.size.y;
    }

    public boolean hasCommonArea(Rectangle2DInt r) {
        if (r.position.x > this.position.x + this.size.x) {
            return false;
        }
        if (r.position.y > this.position.y + this.size.y) {
            return false;
        }
        if (r.position.x + r.size.x - 1 < this.position.x) {
            return false;
        }
        return r.position.y + r.size.y - 1 >= this.position.y;
    }

    public Point2DInt[] getIntersection(Line2DInt line) {
        return line.getIntersection(this);
    }

    public Rectangle2DInt getIntersection(Rectangle2DInt r) {
        Rectangle2DInt bottom;
        Rectangle2DInt top;
        Rectangle2DInt right;
        Rectangle2DInt left;
        if (this.contains(r)) {
            return new Rectangle2DInt(r);
        }
        if (r.contains(this)) {
            return new Rectangle2DInt(this);
        }
        if (this.position.x < r.position.x) {
            left = this;
            right = r;
        } else {
            left = r;
            right = this;
        }
        if (right.position.x > left.position.x + left.size.x) {
            return null;
        }
        if (this.position.y < r.position.y) {
            top = this;
            bottom = r;
        } else {
            top = r;
            bottom = this;
        }
        if (bottom.position.y > top.position.y + top.size.y) {
            return null;
        }
        Point2DInt pos = new Point2DInt(right.position.x, bottom.position.y);
        Point2DInt size = new Point2DInt(Math.min(left.position.x + left.size.x - right.position.x, right.size.x), Math.min(top.position.y + top.size.y - bottom.position.y, bottom.size.y));
        return new Rectangle2DInt(pos, size);
    }

    public Point2DInt[] getIntersectionPoints(Rectangle2DInt r) {
        Rectangle2DInt bottom;
        Rectangle2DInt top;
        Rectangle2DInt right;
        Rectangle2DInt left;
        if (r.equals(this)) {
            return null;
        }
        if (this.contains(r)) {
            return new Point2DInt[0];
        }
        if (r.contains(this)) {
            return new Point2DInt[0];
        }
        if (this.position.x < r.position.x) {
            left = this;
            right = r;
        } else {
            left = r;
            right = this;
        }
        if (right.position.x > left.position.x + left.size.x) {
            return new Point2DInt[0];
        }
        if (this.position.y < r.position.y) {
            top = this;
            bottom = r;
        } else {
            top = r;
            bottom = this;
        }
        if (bottom.position.y > top.position.y + top.size.y) {
            return new Point2DInt[0];
        }
        if (left.position.x + left.size.x == right.position.x && top.position.y + top.size.y == bottom.position.y) {
            return new Point2DInt[]{new Point2DInt(left.position.x + left.size.x, top.position.y + top.size.y)};
        }
        return new Point2DInt[]{new Point2DInt(right.position.x, top.position.y + top.size.y), new Point2DInt(left.position.x + left.size.x, bottom.position.y)};
    }

    public void extendToContain(Rectangle2DInt r) {
        if (this.contains(r)) {
            return;
        }
        if (r.position.x < this.position.x) {
            this.size.x += this.position.x - r.position.x;
            this.position.x = r.position.x;
        }
        if (r.position.y < this.position.y) {
            this.size.y += this.position.y - r.position.y;
            this.position.y = r.position.y;
        }
        if (r.position.x + r.size.x > this.position.x + this.size.x) {
            this.size.x = r.position.x + r.size.x - this.position.x;
        }
        if (r.position.y + r.size.y > this.position.y + this.size.y) {
            this.size.y = r.position.y + r.size.y - this.position.y;
        }
    }

    public Line2DInt getTopLine() {
        return new Line2DInt(new Point2DInt(this.position.x, this.position.y), new Point2DInt(this.position.x + this.size.x - 1, this.position.y));
    }

    public Line2DInt getBottomLine() {
        return new Line2DInt(new Point2DInt(this.position.x, this.position.y + this.size.y - 1), new Point2DInt(this.position.x + this.size.x - 1, this.position.y + this.size.y - 1));
    }

    public Line2DInt getLeftLine() {
        return new Line2DInt(new Point2DInt(this.position.x, this.position.y), new Point2DInt(this.position.x, this.position.y + this.size.y - 1));
    }

    public Line2DInt getRightLine() {
        return new Line2DInt(new Point2DInt(this.position.x + this.size.x - 1, this.position.y), new Point2DInt(this.position.x + this.size.x - 1, this.position.y + this.size.y - 1));
    }
}

