/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.util.IConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public interface IO
extends IConcurrentCloseable {
    public String getSourceDescription();

    public IO getWrappedIO();

    public byte getPriority();

    public void setPriority(byte var1);

    public TaskManager getTaskManager();

    public static IOException error(Throwable e) {
        if (e instanceof IOException) {
            return (IOException)e;
        }
        return new IOException(e);
    }

    public static interface OutputToInput
    extends Readable,
    Writable {
        public void endOfData();

        public void signalErrorBeforeEndOfData(IOException var1);
    }

    public static interface WritableByteStream
    extends IO {
        public void write(byte var1) throws IOException;

        public void write(byte[] var1, int var2, int var3) throws IOException;

        default public void write(byte[] buffer) throws IOException {
            this.write(buffer, 0, buffer.length);
        }

        public ISynchronizationPoint<IOException> canStartWriting();
    }

    public static interface ReadableByteStream
    extends IO {
        public ISynchronizationPoint<IOException> canStartReading();

        public int read() throws IOException;

        public int read(byte[] var1, int var2, int var3) throws IOException;

        public int readFully(byte[] var1) throws IOException;

        default public byte readByte() throws IOException, EOFException {
            int b = this.read();
            if (b < 0) {
                throw new EOFException();
            }
            return (byte)b;
        }

        public int skip(int var1) throws IOException;
    }

    public static interface KnownSize
    extends IO {
        public long getSizeSync() throws IOException;

        public AsyncWork<Long, IOException> getSizeAsync();
    }

    public static interface Resizable
    extends KnownSize {
        public void setSizeSync(long var1) throws IOException;

        public AsyncWork<Void, IOException> setSizeAsync(long var1);
    }

    public static interface Writable
    extends IO,
    WriterAsync {
        public ISynchronizationPoint<IOException> canStartWriting();

        public int writeSync(ByteBuffer var1) throws IOException;

        public AsyncWork<Integer, IOException> writeAsync(ByteBuffer var1, RunnableWithParameter<Pair<Integer, IOException>> var2);

        @Override
        default public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer) {
            return this.writeAsync(buffer, null);
        }

        public static interface Buffered
        extends Writable,
        WritableByteStream {
            public ISynchronizationPoint<IOException> flush();
        }

        public static interface Seekable
        extends Writable,
        net.lecousin.framework.io.IO$Seekable {
            public int writeSync(long var1, ByteBuffer var3) throws IOException;

            public AsyncWork<Integer, IOException> writeAsync(long var1, ByteBuffer var3, RunnableWithParameter<Pair<Integer, IOException>> var4);

            default public AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer) {
                return this.writeAsync(pos, buffer, null);
            }
        }
    }

    public static interface WriterAsync {
        public AsyncWork<Integer, IOException> writeAsync(ByteBuffer var1);
    }

    public static interface Readable
    extends IO {
        public ISynchronizationPoint<IOException> canStartReading();

        public int readSync(ByteBuffer var1) throws IOException;

        public AsyncWork<Integer, IOException> readAsync(ByteBuffer var1, RunnableWithParameter<Pair<Integer, IOException>> var2);

        default public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer) {
            return this.readAsync(buffer, null);
        }

        public int readFullySync(ByteBuffer var1) throws IOException;

        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer var1, RunnableWithParameter<Pair<Integer, IOException>> var2);

        default public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer) {
            return this.readFullyAsync(buffer, null);
        }

        public long skipSync(long var1) throws IOException;

        public AsyncWork<Long, IOException> skipAsync(long var1, RunnableWithParameter<Pair<Long, IOException>> var3);

        default public AsyncWork<Long, IOException> skipAsync(long n) {
            return this.skipAsync(n, null);
        }

        public static interface Buffered
        extends Readable,
        ReadableByteStream {
            public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> var1);

            default public AsyncWork<ByteBuffer, IOException> readNextBufferAsync() {
                return this.readNextBufferAsync(null);
            }

            public int readAsync() throws IOException;
        }

        public static interface Seekable
        extends Readable,
        net.lecousin.framework.io.IO$Seekable {
            public int readSync(long var1, ByteBuffer var3) throws IOException;

            public AsyncWork<Integer, IOException> readAsync(long var1, ByteBuffer var3, RunnableWithParameter<Pair<Integer, IOException>> var4);

            default public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer) {
                return this.readAsync(pos, buffer, null);
            }

            public int readFullySync(long var1, ByteBuffer var3) throws IOException;

            public AsyncWork<Integer, IOException> readFullyAsync(long var1, ByteBuffer var3, RunnableWithParameter<Pair<Integer, IOException>> var4);

            default public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer) {
                return this.readFullyAsync(pos, buffer, null);
            }
        }
    }

    public static interface Seekable
    extends PositionKnown {
        public long seekSync(SeekType var1, long var2) throws IOException;

        public AsyncWork<Long, IOException> seekAsync(SeekType var1, long var2, RunnableWithParameter<Pair<Long, IOException>> var4);

        default public AsyncWork<Long, IOException> seekAsync(SeekType type, long move) {
            return this.seekAsync(type, move, null);
        }

        public static enum SeekType {
            FROM_BEGINNING,
            FROM_CURRENT,
            FROM_END;

        }
    }

    public static interface PositionKnown
    extends IO {
        public long getPosition() throws IOException;
    }

    public static enum OperationType {
        SYNCHRONOUS,
        ASYNCHRONOUS;

    }
}

