/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class IOFromInputStream
extends ConcurrentCloseable
implements IO.Readable {
    private InputStream stream;
    private String sourceDescription;
    private TaskManager manager;
    private byte priority;

    public IOFromInputStream(InputStream stream, String sourceDescription, TaskManager manager, byte priority) {
        this.stream = stream;
        this.sourceDescription = sourceDescription;
        this.manager = manager;
        this.priority = priority;
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return new SynchronizationPoint<boolean>(true);
    }

    public InputStream getInputStream() {
        return this.stream;
    }

    @Override
    public String getSourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.manager;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return IOUtil.closeAsync(this.stream);
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.stream = null;
        ondone.unblock();
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int nb = this.stream.read(buffer.array(), buffer.arrayOffset(), buffer.remaining());
        if (nb >= 0) {
            buffer.position(buffer.position() + nb);
        }
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        int nb;
        int total = 0;
        while ((nb = this.stream.read(buffer.array(), buffer.arrayOffset() + total, buffer.remaining() - total)) > 0 && (total += nb) < buffer.remaining()) {
        }
        buffer.position(buffer.position() + total);
        return total;
    }

    @Override
    public long skipSync(long n) throws IOException {
        int l;
        int nb;
        if (n <= 0L) {
            return 0L;
        }
        long total = 0L;
        byte[] b = new byte[n > 65536L ? 65536 : (int)n];
        while ((nb = this.stream.read(b, 0, l = n - total > 65536L ? 65536 : (int)(n - total))) > 0 && (total += (long)nb) < n) {
        }
        return total;
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task<Integer, IOException> t = new Task<Integer, IOException>(this.manager, "Read from InputStream", this.priority, ondone){

            @Override
            public Integer run() throws IOException, CancelException {
                try {
                    int nb = IOFromInputStream.this.stream.read(buffer.array(), buffer.arrayOffset(), buffer.remaining());
                    if (nb >= 0) {
                        buffer.position(buffer.position() + nb);
                    }
                    return nb;
                }
                catch (IOException e) {
                    if (IOFromInputStream.this.isClosing() || IOFromInputStream.this.isClosed()) {
                        throw new CancelException("InputStream closed");
                    }
                    throw e;
                }
            }
        };
        this.operation(t.start());
        return t.getOutput();
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task<Integer, IOException> t = new Task<Integer, IOException>(this.manager, "Read from InputStream", this.priority, ondone){

            @Override
            public Integer run() throws IOException, CancelException {
                int nb;
                int total = 0;
                do {
                    try {
                        nb = IOFromInputStream.this.stream.read(buffer.array(), buffer.arrayOffset() + total, buffer.remaining() - total);
                        if (nb <= 0) break;
                    }
                    catch (IOException e) {
                        if (IOFromInputStream.this.isClosing() || IOFromInputStream.this.isClosed()) {
                            throw new CancelException("InputStream closed");
                        }
                        throw e;
                    }
                } while ((total += nb) < buffer.remaining());
                buffer.position(buffer.position() + total);
                return total;
            }
        };
        this.operation(t.start());
        return t.getOutput();
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(final long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            return new AsyncWork<Long, Object>(0L, null);
        }
        Task<Long, IOException> t = new Task<Long, IOException>(this.manager, "Skip from InputStream", this.priority, ondone){

            @Override
            public Long run() throws IOException, CancelException {
                int l;
                int nb;
                long total = 0L;
                byte[] b = new byte[n > 65536L ? 65536 : (int)n];
                do {
                    int n2 = l = n - total > 65536L ? 65536 : (int)(n - total);
                    if (!IOFromInputStream.this.isClosing() && !IOFromInputStream.this.isClosed()) continue;
                    throw new CancelException("InputStream closed");
                } while ((nb = IOFromInputStream.this.stream.read(b, 0, l)) > 0 && (total += (long)nb) < n);
                return total;
            }
        };
        this.operation(t.start());
        return t.getOutput();
    }

    public static class KnownSize
    extends IOFromInputStream
    implements IO.KnownSize {
        private long size;

        public KnownSize(InputStream stream, long size, String sourceDescription, TaskManager manager, byte priority) {
            super(stream, sourceDescription, manager, priority);
            this.size = size;
        }

        @Override
        public long getSizeSync() {
            return this.size;
        }

        @Override
        public AsyncWork<Long, IOException> getSizeAsync() {
            return new AsyncWork<Long, Object>(this.size, null);
        }
    }
}

