/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class IOFromOutputStream
extends ConcurrentCloseable
implements IO.Writable {
    private OutputStream stream;
    private String sourceDescription;
    private TaskManager manager;
    private byte priority;

    public IOFromOutputStream(OutputStream stream, String sourceDescription, TaskManager manager, byte priority) {
        this.stream = stream;
        this.sourceDescription = sourceDescription;
        this.manager = manager;
        this.priority = priority;
    }

    public OutputStream getOutputStream() {
        return this.stream;
    }

    @Override
    public String getSourceDescription() {
        return this.sourceDescription;
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.manager;
    }

    @Override
    public ISynchronizationPoint<IOException> canStartWriting() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        int nb = buffer.remaining();
        if (buffer.hasArray()) {
            this.stream.write(buffer.array(), buffer.position(), buffer.remaining());
            buffer.position(buffer.position() + nb);
        } else {
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            this.stream.write(buf);
        }
        return nb;
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.writeAsyncUsingSync(this, buffer, ondone)).getOutput();
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return IOUtil.closeAsync(this.stream);
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.stream = null;
        ondone.unblock();
    }
}

