/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.mutable.Mutable;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class IOInMemoryOrFile
extends ConcurrentCloseable
implements IO.Readable.Seekable,
IO.Writable.Seekable,
IO.KnownSize,
IO.Resizable {
    private static final int BUFFER_SIZE = 8192;
    private int maxSizeInMemory;
    private byte priority;
    private String sourceDescription;
    private long pos = 0L;
    private long size = 0L;
    private byte[][] memory;
    private FileIO.ReadWrite file = null;

    public IOInMemoryOrFile(int maxSizeInMemory, byte priority, String sourceDescription) {
        this.priority = priority;
        this.sourceDescription = sourceDescription;
        int nbBuffers = maxSizeInMemory / 8192;
        if (maxSizeInMemory % 8192 > 0) {
            ++nbBuffers;
        }
        this.maxSizeInMemory = nbBuffers * 8192;
        this.memory = new byte[nbBuffers][];
    }

    @Override
    public String getSourceDescription() {
        return this.sourceDescription;
    }

    private void createFile() throws IOException {
        File file = File.createTempFile("net.lecousin.framework", "tempIO");
        file.deleteOnExit();
        this.file = new FileIO.ReadWrite(file, this.priority);
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    public int getMaxInMemory() {
        return this.memory.length * 8192;
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    public ISynchronizationPoint<IOException> canStartWriting() {
        return new SynchronizationPoint<boolean>(true);
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        if (this.file != null) {
            final SynchronizationPoint sp = new SynchronizationPoint();
            this.file.closeAsync().listenInline(new Runnable(){

                @Override
                public void run() {
                    if (!IOInMemoryOrFile.this.file.getFile().delete()) {
                        LCCore.getApplication().getDefaultLogger().warn("Unable to remove temporary file: " + IOInMemoryOrFile.this.file.getFile().getAbsolutePath());
                    }
                    sp.unblock();
                }
            }, sp);
            return sp;
        }
        return null;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.file = null;
        this.memory = null;
        ondone.unblock();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) {
        switch (type) {
            case FROM_BEGINNING: {
                this.pos = move;
                break;
            }
            case FROM_CURRENT: {
                this.pos += move;
                break;
            }
            case FROM_END: {
                this.pos = this.size - move;
                break;
            }
        }
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        if (this.pos > this.size) {
            this.pos = this.size;
        }
        return this.pos;
    }

    @Override
    public long skipSync(long n) {
        long prevPos = this.pos;
        this.pos += n;
        if (this.pos < 0L) {
            this.pos = 0L;
        }
        if (this.pos > this.size) {
            this.pos = this.size;
        }
        return this.pos - prevPos;
    }

    @Override
    public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        this.seekSync(type, move);
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(this.pos, null));
        }
        return new AsyncWork<Long, Object>(this.pos, null);
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        long skipped = this.skipSync(n);
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(skipped, null));
        }
        return new AsyncWork<Long, Object>(skipped, null);
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
    }

    @Override
    public long getSizeSync() {
        return this.size;
    }

    @Override
    public AsyncWork<Long, IOException> getSizeAsync() {
        AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        sp.unblockSuccess(this.size);
        return sp;
    }

    @Override
    public int writeSync(ByteBuffer buffer) throws IOException {
        return this.writeSync(this.pos, buffer);
    }

    @Override
    public int writeSync(long pos, ByteBuffer buffer) throws IOException {
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            this.setSizeSync(pos);
        }
        int len = buffer.remaining();
        if (pos < (long)this.maxSizeInMemory) {
            int inFil;
            int l;
            int inMem = pos + (long)len <= (long)this.maxSizeInMemory ? len : (int)((long)this.maxSizeInMemory - pos);
            int p = (int)pos;
            int rem = inMem;
            do {
                int i = p / 8192;
                l = rem;
                int j = p % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (this.memory[i] == null) {
                    this.memory[i] = new byte[8192];
                }
                buffer.get(this.memory[i], j, l);
                p += l;
            } while ((rem -= l) > 0);
            if (pos + (long)len <= (long)this.maxSizeInMemory) {
                this.pos = p;
                if ((long)p > this.size) {
                    this.size = p;
                }
                return len;
            }
            if (this.file == null) {
                this.createFile();
            }
            if ((inFil = this.file.writeSync(0L, buffer)) < len - inMem) {
                len = inMem + inFil;
            }
            this.pos = pos + (long)len;
            if (pos + (long)len > this.size) {
                this.size = pos + (long)len;
            }
            return len;
        }
        if (this.file == null) {
            this.createFile();
        }
        int nb = this.file.writeSync(pos - (long)this.maxSizeInMemory, buffer);
        this.pos = pos + (long)nb;
        if (pos + (long)nb > this.size) {
            this.size = pos + (long)nb;
        }
        return nb;
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(long pos, final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            AsyncWork<Void, IOException> resize = this.setSizeAsync(pos);
            AsyncWork result = new AsyncWork();
            long p = pos;
            IOUtil.listenOnDone(resize, res -> this.writeAsync(p, buffer, ondone).listenInline(result), result, ondone);
            return this.operation(result);
        }
        int len = buffer.remaining();
        if (pos < (long)this.maxSizeInMemory) {
            if (pos + (long)len <= (long)this.maxSizeInMemory) {
                WriteInMemory task = new WriteInMemory((int)pos, buffer, len, ondone);
                this.pos = pos + (long)len;
                if (pos + (long)len > this.size) {
                    this.size = pos + (long)len;
                }
                task.start();
                return this.operation(task.getOutput());
            }
            final WriteInMemory mem = new WriteInMemory((int)pos, buffer, (int)((long)this.maxSizeInMemory - pos), null);
            mem.start();
            if (this.file == null) {
                try {
                    this.createFile();
                }
                catch (IOException e) {
                    if (ondone != null) {
                        ondone.run(new Pair<Object, IOException>(null, e));
                    }
                    return new AsyncWork<Object, IOException>(null, e);
                }
            }
            final AsyncWork sp = new AsyncWork();
            final Mutable<Object> fil = new Mutable<Object>(null);
            this.pos = pos + (long)len;
            if (pos + (long)len > this.size) {
                this.size = pos + (long)len;
            }
            mem.getOutput().listenInline(new Runnable(){

                @Override
                public void run() {
                    if (mem.isCancelled()) {
                        sp.unblockCancel(mem.getCancelEvent());
                        return;
                    }
                    fil.set(IOInMemoryOrFile.this.file.writeAsync(0L, buffer));
                    IOUtil.listenOnDone((AsyncWork)fil.get(), result -> {
                        Integer r = (Integer)mem.getResult() + result;
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(r, null));
                        }
                        sp.unblockSuccess(r);
                    }, sp, ondone);
                }
            });
            sp.onCancel(new Listener<CancelException>(){

                @Override
                public void fire(CancelException event) {
                    mem.cancel(event);
                    if (fil.get() != null) {
                        ((AsyncWork)fil.get()).unblockCancel(event);
                    }
                }
            });
            return this.operation(sp);
        }
        if (this.file == null) {
            try {
                this.createFile();
            }
            catch (IOException e) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, e));
                }
                return new AsyncWork<Object, IOException>(null, e);
            }
        }
        this.pos = pos + (long)len;
        if (pos + (long)len > this.size) {
            this.size = pos + (long)len;
        }
        AsyncWork<Integer, IOException> task = this.file.writeAsync(pos - (long)this.maxSizeInMemory, buffer, ondone);
        return this.operation(task);
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.writeAsync(this.pos, buffer, ondone);
    }

    @Override
    public void setSizeSync(long newSize) throws IOException {
        if (newSize == this.size) {
            return;
        }
        if (newSize < this.size) {
            if (newSize <= (long)this.maxSizeInMemory) {
                if (this.file != null) {
                    File f = this.file.getFile();
                    this.file.closeAsync().listenInline(() -> {
                        if (!f.delete()) {
                            LCCore.getApplication().getDefaultLogger().warn("Unable to remove temporary file " + f.getAbsolutePath());
                        }
                    });
                    this.file = null;
                }
                int nbBuf = (int)(newSize / 8192L);
                if (newSize % 8192L != 0L) {
                    ++nbBuf;
                }
                if (this.memory.length > nbBuf) {
                    byte[][] newMem = new byte[nbBuf][];
                    System.arraycopy(this.memory, 0, newMem, 0, nbBuf);
                    this.memory = newMem;
                }
            } else {
                this.file.setSizeSync(newSize - (long)this.maxSizeInMemory);
            }
            this.size = newSize;
            if (this.pos > this.size) {
                this.pos = this.size;
            }
            return;
        }
        if (this.size < (long)this.maxSizeInMemory) {
            int nbBuf = (int)(newSize / 8192L);
            if (newSize % 8192L != 0L) {
                ++nbBuf;
            }
            if (nbBuf > this.memory.length) {
                byte[][] n = new byte[nbBuf][];
                System.arraycopy(this.memory, 0, n, 0, this.memory.length);
                this.memory = n;
                for (int i = 0; i < this.memory.length; ++i) {
                    if (this.memory[i] != null) continue;
                    this.memory[i] = new byte[8192];
                }
            }
        }
        if (newSize > (long)this.maxSizeInMemory) {
            if (this.file == null) {
                this.createFile();
            }
            this.file.setSizeSync(newSize - (long)this.maxSizeInMemory);
        }
        this.size = newSize;
    }

    @Override
    public AsyncWork<Void, IOException> setSizeAsync(final long newSize) {
        if (newSize == this.size) {
            return new AsyncWork<Object, Object>(null, null);
        }
        if (newSize < this.size) {
            if (newSize <= (long)this.maxSizeInMemory) {
                if (this.file != null) {
                    File f = this.file.getFile();
                    this.file.closeAsync().listenInline(() -> {
                        if (!f.delete()) {
                            LCCore.getApplication().getDefaultLogger().warn("Unable to remove temporary file " + f.getAbsolutePath());
                        }
                    });
                    this.file = null;
                }
                Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Shrink memory of IOInMemoryOrFile", this.getPriority()){

                    @Override
                    public Void run() {
                        int nbBuf = (int)(newSize / 8192L);
                        if (newSize % 8192L != 0L) {
                            ++nbBuf;
                        }
                        if (IOInMemoryOrFile.this.memory.length > nbBuf) {
                            byte[][] newMem = new byte[nbBuf][];
                            System.arraycopy(IOInMemoryOrFile.this.memory, 0, newMem, 0, nbBuf);
                            IOInMemoryOrFile.access$202(IOInMemoryOrFile.this, newMem);
                        }
                        IOInMemoryOrFile.this.size = newSize;
                        if (IOInMemoryOrFile.this.pos > IOInMemoryOrFile.this.size) {
                            IOInMemoryOrFile.this.pos = IOInMemoryOrFile.this.size;
                        }
                        return null;
                    }
                };
                this.operation(task);
                task.start();
                return task.getOutput();
            }
            AsyncWork<Void, IOException> result = new AsyncWork<Void, IOException>();
            AsyncWork<Void, IOException> resize = this.operation(this.file.setSizeAsync(newSize - (long)this.maxSizeInMemory));
            resize.listenInline(() -> {
                this.size = newSize;
                if (this.pos > this.size) {
                    this.pos = this.size;
                }
                result.unblockSuccess(null);
            }, result);
            return result;
        }
        AsyncWork taskMemory = null;
        if (this.size < (long)this.maxSizeInMemory) {
            Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Enlarge memory of IOInMemoryOrFile", this.getPriority()){

                @Override
                public Void run() {
                    int nbBuf = (int)(newSize / 8192L);
                    if (newSize % 8192L != 0L) {
                        ++nbBuf;
                    }
                    if (nbBuf > IOInMemoryOrFile.this.memory.length) {
                        byte[][] n = new byte[nbBuf][];
                        System.arraycopy(IOInMemoryOrFile.this.memory, 0, n, 0, IOInMemoryOrFile.this.memory.length);
                        IOInMemoryOrFile.access$202(IOInMemoryOrFile.this, n);
                        for (int i = 0; i < IOInMemoryOrFile.this.memory.length; ++i) {
                            if (IOInMemoryOrFile.this.memory[i] != null) continue;
                            ((IOInMemoryOrFile)IOInMemoryOrFile.this).memory[i] = new byte[8192];
                        }
                    }
                    return null;
                }
            };
            task.start();
            taskMemory = this.operation(task.getOutput());
        }
        AsyncWork<Void, IOException> taskFile = null;
        if (newSize > (long)this.maxSizeInMemory) {
            if (this.file == null) {
                try {
                    this.createFile();
                }
                catch (IOException e) {
                    return new AsyncWork<Object, IOException>(null, e);
                }
            }
            taskFile = this.operation(this.file.setSizeAsync(newSize - (long)this.maxSizeInMemory));
        }
        AsyncWork<Void, IOException> result = new AsyncWork<Void, IOException>();
        JoinPoint.fromSynchronizationPointsSimilarError(taskMemory, taskFile).listenInline(() -> {
            this.size = newSize;
            result.unblockSuccess(null);
        }, result);
        return result;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        return this.readSync(this.pos, buffer);
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        int nb;
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            pos = this.size;
        }
        if (pos == this.size) {
            return 0;
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        if (pos < (long)this.maxSizeInMemory) {
            int l;
            if (pos + (long)len > (long)this.maxSizeInMemory) {
                len = (int)((long)this.maxSizeInMemory - pos);
            }
            int p = (int)pos;
            int rem = len;
            do {
                int i = p / 8192;
                l = rem;
                int j = p % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (this.memory[i] == null) {
                    throw new IOException("Try to read at " + pos + " but it was not written before !");
                }
                buffer.put(this.memory[i], j, l);
                p += l;
            } while ((rem -= l) > 0 && buffer.remaining() > 0);
            this.pos = pos + (long)len;
            return len;
        }
        if (len < buffer.remaining()) {
            int limit = buffer.limit();
            buffer.limit(buffer.position() + len);
            nb = this.file.readSync(pos - (long)this.maxSizeInMemory, buffer);
            buffer.limit(limit);
        } else {
            nb = this.file.readSync(pos - (long)this.maxSizeInMemory, buffer);
        }
        this.pos = nb > 0 ? pos + (long)nb : pos;
        return nb;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return this.readFullySync(this.pos, buffer);
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return IOUtil.readFullySync(this, pos, buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(long pos, final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> task;
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            pos = this.size;
        }
        if (pos == this.size) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(0, null));
            }
            return new AsyncWork<Integer, Object>(0, null);
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        if (pos < (long)this.maxSizeInMemory) {
            if (pos + (long)len > (long)this.maxSizeInMemory) {
                len = (int)((long)this.maxSizeInMemory - pos);
            }
            ReadInMemory task2 = new ReadInMemory((int)pos, len, buffer, ondone);
            this.pos = pos + (long)len;
            this.operation(task2);
            task2.start();
            return task2.getOutput();
        }
        final long p = pos;
        if (len < buffer.remaining()) {
            final int limit = buffer.limit();
            buffer.limit(buffer.position() + len);
            task = this.file.readAsync(pos - (long)this.maxSizeInMemory, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                @Override
                public void run(Pair<Integer, IOException> param) {
                    buffer.limit(limit);
                    if (param.getValue1() != null) {
                        IOInMemoryOrFile.this.pos = p + (long)param.getValue1().intValue();
                    }
                    if (ondone != null) {
                        ondone.run(param);
                    }
                }
            });
        } else {
            task = this.file.readAsync(pos - (long)this.maxSizeInMemory, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                @Override
                public void run(Pair<Integer, IOException> param) {
                    if (param.getValue1() != null) {
                        IOInMemoryOrFile.this.pos = p + (long)param.getValue1().intValue();
                    }
                    if (ondone != null) {
                        ondone.run(param);
                    }
                }
            });
        }
        return this.operation(task);
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.pos, buffer, ondone);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (pos < 0L) {
            pos = 0L;
        }
        if (pos > this.size) {
            pos = this.size;
        }
        if (pos == this.size) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(0, null));
            }
            return new AsyncWork<Integer, Object>(0, null);
        }
        int len = buffer.remaining();
        if (pos + (long)len > this.size) {
            len = (int)(this.size - pos);
        }
        Task mem = null;
        if (pos < (long)this.maxSizeInMemory) {
            if (pos + (long)len > (long)this.maxSizeInMemory) {
                mem = new ReadInMemory((int)pos, (int)((long)this.maxSizeInMemory - pos), buffer, null);
                pos = this.pos = (long)this.maxSizeInMemory;
                len -= (int)((long)this.maxSizeInMemory - pos);
                this.operation(mem.start());
            } else {
                mem = this.operation(new ReadInMemory((int)pos, len, buffer, ondone));
                this.pos = pos + (long)len;
                mem.start();
                return mem.getOutput();
            }
        }
        if (mem == null) {
            return this.readFromFile(pos - (long)this.maxSizeInMemory, len, buffer, ondone);
        }
        AsyncWork<Integer, IOException> sp = new AsyncWork<Integer, IOException>();
        int l = len;
        Mutable<Object> fil = new Mutable<Object>(null);
        IOUtil.listenOnDone(mem.getOutput(), result -> {
            fil.set(this.operation(this.readFromFile(0L, l, buffer, null)));
            IOUtil.listenOnDone((AsyncWork)fil.get(), result2 -> {
                Integer r = result + result2;
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>(r, null));
                }
                sp.unblockSuccess(r);
            }, sp, ondone);
        }, sp, ondone);
        Task mm = mem;
        sp.onCancel(new Listener<CancelException>((ReadInMemory)mm, fil){
            final /* synthetic */ ReadInMemory val$mm;
            final /* synthetic */ Mutable val$fil;
            {
                this.val$mm = readInMemory;
                this.val$fil = mutable;
            }

            @Override
            public void fire(CancelException event) {
                this.val$mm.cancel(event);
                if (this.val$fil.get() != null) {
                    ((AsyncWork)this.val$fil.get()).unblockCancel(event);
                }
            }
        });
        return sp;
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readFullyAsync(this.pos, buffer, ondone);
    }

    private AsyncWork<Integer, IOException> readFromFile(final long pos, int len, final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> task;
        if (len < buffer.remaining()) {
            final int limit = buffer.limit();
            buffer.limit(buffer.position() + len);
            task = this.file.readFullyAsync(pos, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                @Override
                public void run(Pair<Integer, IOException> param) {
                    buffer.limit(limit);
                    if (param.getValue1() != null) {
                        IOInMemoryOrFile.this.pos = (long)IOInMemoryOrFile.this.maxSizeInMemory + pos + (long)param.getValue1().intValue();
                    }
                    if (ondone != null) {
                        ondone.run(param);
                    }
                }
            });
        } else {
            task = this.file.readFullyAsync(pos, buffer, new RunnableWithParameter<Pair<Integer, IOException>>(){

                @Override
                public void run(Pair<Integer, IOException> param) {
                    if (param.getValue1() != null) {
                        IOInMemoryOrFile.this.pos = (long)IOInMemoryOrFile.this.maxSizeInMemory + pos + (long)param.getValue1().intValue();
                    }
                    if (ondone != null) {
                        ondone.run(param);
                    }
                }
            });
        }
        return this.operation(task);
    }

    static /* synthetic */ byte[][] access$202(IOInMemoryOrFile x0, byte[][] x1) {
        x0.memory = x1;
        return x1;
    }

    private class WriteInMemory
    extends Task.Cpu<Integer, IOException> {
        private int pos;
        private int len;
        private ByteBuffer buf;

        private WriteInMemory(int pos, ByteBuffer buf, int len, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            super("IOInMemoryOrFile: writing in memory", IOInMemoryOrFile.this.priority, ondone);
            this.pos = pos;
            this.len = len;
            this.buf = buf;
        }

        @Override
        public Integer run() throws IOException {
            if (IOInMemoryOrFile.this.memory == null) {
                throw new IOException("IOInMemoryOrFile is already closed: " + IOInMemoryOrFile.this.getSourceDescription());
            }
            Integer result = this.len;
            do {
                int i = this.pos / 8192;
                int l = this.len;
                int j = this.pos % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (IOInMemoryOrFile.this.memory[i] == null) {
                    ((IOInMemoryOrFile)IOInMemoryOrFile.this).memory[i] = new byte[8192];
                }
                this.buf.get(IOInMemoryOrFile.this.memory[i], j, l);
                this.len -= l;
                this.pos += l;
            } while (this.len > 0);
            return result;
        }
    }

    private class ReadInMemory
    extends Task.Cpu<Integer, IOException> {
        private int pos;
        private int len;
        private ByteBuffer buf;

        private ReadInMemory(int pos, int len, ByteBuffer buf, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            super("IOInMemoryOrFile: reading in memory", IOInMemoryOrFile.this.priority, ondone);
            this.pos = pos;
            this.len = len;
            this.buf = buf;
        }

        @Override
        public Integer run() throws IOException {
            if (IOInMemoryOrFile.this.memory == null) {
                throw new IOException("IOInMemoryOrFile is already closed: " + IOInMemoryOrFile.this.getSourceDescription());
            }
            Integer result = this.len;
            do {
                int i = this.pos / 8192;
                int l = this.len;
                int j = this.pos % 8192;
                if (l > 8192 - j) {
                    l = 8192 - j;
                }
                if (IOInMemoryOrFile.this.memory[i] == null) {
                    throw new IOException("Try to read at " + this.pos + " but it was not written before !");
                }
                this.buf.put(IOInMemoryOrFile.this.memory[i], j, l);
                this.len -= l;
                this.pos += l;
            } while (this.len > 0 && this.buf.remaining() > 0);
            return result;
        }
    }
}

