/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class SimpleBufferedReadable
extends ConcurrentCloseable
implements IO.Readable.Buffered {
    private IO.Readable io;
    private ByteBuffer readBuffer;
    private AtomicState state;
    private ByteBuffer bb;
    private AsyncWork<Integer, IOException> readTask;

    public SimpleBufferedReadable(IO.Readable io, int bufferSize) {
        this.io = io;
        this.readBuffer = ByteBuffer.allocate(bufferSize);
        this.readTask = io.readAsync(this.readBuffer);
        this.bb = ByteBuffer.allocate(bufferSize);
        this.state = new AtomicState();
        this.state.pos = (this.state.len = 0);
        AtomicState.access$302(this.state, this.bb.array());
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        ISynchronizationPoint<Object> sp = this.readTask;
        if (sp == null) {
            sp = new SynchronizationPoint<boolean>(true);
        }
        return sp;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        AsyncWork<Integer, IOException> currentRead = this.readTask;
        if (currentRead != null && !currentRead.isUnblocked()) {
            currentRead.cancel(new CancelException("IO closed"));
            final SynchronizationPoint sp = new SynchronizationPoint();
            currentRead.listenInline(new Runnable(){

                @Override
                public void run() {
                    SimpleBufferedReadable.this.io.closeAsync().listenInline(sp);
                }
            });
            return sp;
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.readTask = null;
        AtomicState.access$302(this.state, null);
        this.bb = null;
        this.readBuffer = null;
        ondone.unblock();
    }

    public void stop() {
        AsyncWork<Integer, IOException> currentRead = this.readTask;
        if (currentRead != null && !currentRead.isUnblocked()) {
            currentRead.cancel(new CancelException("SimpleBufferedReadable.stop"));
            currentRead.block(0L);
        }
    }

    private void fill() throws IOException, CancelException {
        AsyncWork<Integer, IOException> currentRead = this.readTask;
        if (currentRead == null) {
            return;
        }
        currentRead.block(0L);
        if (!currentRead.isSuccessful()) {
            if (currentRead.isCancelled()) {
                throw currentRead.getCancelEvent();
            }
            IOException e = currentRead.getError();
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        int nb = currentRead.getResult();
        if (nb <= 0) {
            this.state.pos = (this.state.len = 0);
            AtomicState.access$302(this.state, null);
            this.bb = null;
            this.readBuffer = null;
            this.readTask = null;
            return;
        }
        if (this.readTask == null) {
            return;
        }
        AtomicState s = new AtomicState();
        AtomicState.access$302(s, this.readBuffer.array());
        s.pos = 0;
        s.len = this.readBuffer.position();
        this.state = s;
        ByteBuffer b = this.readBuffer;
        this.readBuffer = this.bb;
        this.bb = b;
        this.readBuffer.clear();
        this.readTask = this.io.readAsync(this.readBuffer);
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        int l;
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                return -1;
            }
            if (this.state.pos == this.state.len) {
                return -1;
            }
        }
        if ((l = buffer.remaining()) > this.state.len - this.state.pos) {
            l = this.state.len - this.state.pos;
        }
        buffer.put(this.state.buffer, this.state.pos, l);
        AtomicState atomicState = this.state;
        atomicState.pos = atomicState.pos + l;
        return l;
    }

    @Override
    public int readAsync() {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            AsyncWork<Integer, IOException> currentRead = this.readTask;
            if (currentRead != null && currentRead.isUnblocked()) {
                try {
                    this.fill();
                }
                catch (Throwable t) {
                    return -1;
                }
            }
            return -2;
        }
        return s.buffer[s.pos++] & 0xFF;
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone)).getOutput();
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(this, buffer, ondone);
    }

    @Override
    public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        AtomicState s = this.state;
        if (s.pos == s.len && s.buffer == null) {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(null, null));
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        Task.Cpu<ByteBuffer, IOException> task = new Task.Cpu<ByteBuffer, IOException>("Read next buffer", this.getPriority(), ondone){

            @Override
            public ByteBuffer run() throws IOException, CancelException {
                AtomicState s = SimpleBufferedReadable.this.state;
                if (s.pos == s.len) {
                    if (s.buffer == null) {
                        return null;
                    }
                    SimpleBufferedReadable.this.fill();
                    if (SimpleBufferedReadable.this.state.pos == SimpleBufferedReadable.this.state.len) {
                        return null;
                    }
                }
                ByteBuffer buf = ByteBuffer.allocate(SimpleBufferedReadable.this.state.len - SimpleBufferedReadable.this.state.pos);
                try {
                    buf.put(SimpleBufferedReadable.this.state.buffer, SimpleBufferedReadable.this.state.pos, SimpleBufferedReadable.this.state.len - SimpleBufferedReadable.this.state.pos);
                }
                catch (NullPointerException e) {
                    throw new CancelException("IO closed");
                }
                SimpleBufferedReadable.this.state.pos = SimpleBufferedReadable.this.state.len;
                buf.flip();
                return buf;
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    @Override
    public long skipSync(long n) throws IOException {
        if (this.state.buffer == null || n <= 0L) {
            return 0L;
        }
        if (n <= (long)(this.state.len - this.state.pos)) {
            AtomicState atomicState = this.state;
            atomicState.pos = atomicState.pos + (int)n;
            return n;
        }
        AsyncWork<Integer, IOException> currentRead = this.readTask;
        if (currentRead == null) {
            return 0L;
        }
        currentRead.block(0L);
        if (!currentRead.isSuccessful()) {
            if (currentRead.isCancelled()) {
                return 0L;
            }
            IOException e = currentRead.getError();
            if (e instanceof IOException) {
                throw e;
            }
            throw new IOException(e);
        }
        int avail = currentRead.getResult();
        if (avail < 0) {
            avail = 0;
        }
        if (n <= (long)(this.state.len - this.state.pos + avail)) {
            int i = this.state.len - this.state.pos;
            try {
                this.fill();
            }
            catch (CancelException e) {
                return 0L;
            }
            return this.skipSync(n - (long)i) + (long)i;
        }
        n = this.io.skipSync(n - (long)(this.state.len - this.state.pos + avail));
        n += (long)(this.state.len - this.state.pos);
        n += (long)avail;
        this.state.len = (this.state.pos = 0);
        this.readBuffer.clear();
        this.readTask = this.io.readAsync(this.readBuffer);
        return n;
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(final long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        if (this.state.buffer == null || n <= 0L) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            return new AsyncWork<Long, Object>(0L, null);
        }
        if (n <= (long)(this.state.len - this.state.pos)) {
            AtomicState atomicState = this.state;
            atomicState.pos = atomicState.pos + (int)n;
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(n, null));
            }
            return new AsyncWork<Long, Object>(n, null);
        }
        final AsyncWork<Integer, IOException> currentRead = this.readTask;
        if (currentRead == null) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            return new AsyncWork<Long, Object>(0L, null);
        }
        Task.Cpu<Long, IOException> task = new Task.Cpu<Long, IOException>("Skipping bytes", this.io.getPriority(), ondone){

            @Override
            public Long run() throws IOException, CancelException {
                if (currentRead.isCancelled()) {
                    return 0L;
                }
                if (!currentRead.isSuccessful()) {
                    if (currentRead.isCancelled()) {
                        throw currentRead.getCancelEvent();
                    }
                    throw (IOException)currentRead.getError();
                }
                int avail = (Integer)currentRead.getResult();
                if (avail < 0) {
                    avail = 0;
                }
                if (n <= (long)(SimpleBufferedReadable.this.state.len - SimpleBufferedReadable.this.state.pos + avail)) {
                    int i = SimpleBufferedReadable.this.state.len - SimpleBufferedReadable.this.state.pos;
                    SimpleBufferedReadable.this.fill();
                    return SimpleBufferedReadable.this.skipSync(n - (long)i) + (long)i;
                }
                long res = SimpleBufferedReadable.this.io.skipSync(n - (long)(SimpleBufferedReadable.this.state.len - SimpleBufferedReadable.this.state.pos + avail));
                res += (long)(SimpleBufferedReadable.this.state.len - SimpleBufferedReadable.this.state.pos);
                res += (long)avail;
                SimpleBufferedReadable.this.state.len = (SimpleBufferedReadable.this.state.pos = 0);
                SimpleBufferedReadable.this.readBuffer.clear();
                SimpleBufferedReadable.this.readTask = SimpleBufferedReadable.this.io.readAsync(SimpleBufferedReadable.this.readBuffer);
                return res;
            }
        };
        this.operation(task).startOn(this.readTask, true);
        return task.getOutput();
    }

    @Override
    public int read() throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                return -1;
            }
            if (this.state.pos == this.state.len) {
                return -1;
            }
        }
        return this.state.buffer[this.state.pos++] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int l) throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.buffer == null) {
                return -1;
            }
            try {
                this.fill();
            }
            catch (CancelException e) {
                return -1;
            }
            if (this.state.pos == this.state.len) {
                return -1;
            }
        }
        if (l > this.state.len - this.state.pos) {
            l = this.state.len - this.state.pos;
        }
        System.arraycopy(this.state.buffer, this.state.pos, buffer, offset, l);
        AtomicState atomicState = this.state;
        atomicState.pos = atomicState.pos + l;
        return l;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    private static class AtomicState {
        private byte[] buffer;
        private int pos;
        private int len;

        private AtomicState() {
        }

        static /* synthetic */ byte[] access$302(AtomicState x0, byte[] x1) {
            x0.buffer = x1;
            return x1;
        }
    }
}

