/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class SingleBufferReadable
extends ConcurrentCloseable
implements IO.Readable.Buffered {
    private IO.Readable io;
    private boolean useReadFully;
    private byte[] buffer;
    private AtomicState state;
    private AsyncWork<Integer, IOException> reading;

    public SingleBufferReadable(IO.Readable io, int bufferSize, boolean useReadFully) {
        this.io = io;
        this.buffer = new byte[bufferSize];
        this.useReadFully = useReadFully;
        this.state = new AtomicState();
        this.state.pos = (this.state.len = 0);
        this.state.eof = false;
        this.fillNextBuffer();
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return new SynchronizationPoint<boolean>(true);
    }

    private void fillNextBuffer() {
        this.reading = this.useReadFully ? this.io.readFullyAsync(ByteBuffer.wrap(this.buffer), result -> {
            if (result.getValue1() == null) {
                return;
            }
            AtomicState ns = new AtomicState();
            ns.len = (Integer)result.getValue1();
            if (ns.len <= 0) {
                ns.len = 0;
                ns.eof = true;
            } else if (ns.len < this.buffer.length) {
                ns.eof = true;
            } else {
                ns.eof = false;
            }
            ns.pos = 0;
            this.state = ns;
        }) : this.io.readAsync(ByteBuffer.wrap(this.buffer), result -> {
            AtomicState ns = new AtomicState();
            ns.len = (Integer)result.getValue1();
            if (ns.len <= 0) {
                ns.len = 0;
                ns.eof = true;
            } else {
                ns.eof = false;
            }
            ns.pos = 0;
            this.state = ns;
        });
        this.operation(this.reading);
    }

    private void waitBufferSync() throws IOException {
        this.reading.blockException(0L);
        if (this.reading.isCancelled()) {
            throw new IOException("Read cancelled", this.reading.getCancelEvent());
        }
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return 0;
            }
            this.waitBufferSync();
            return this.readSync(buffer);
        }
        int l = buffer.remaining();
        if (l > s.len - s.pos) {
            l = s.len - s.pos;
        }
        buffer.put(this.buffer, s.pos, l);
        AtomicState atomicState = s;
        atomicState.pos = atomicState.pos + l;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return l;
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readAsyncUsingSync(this, buffer, ondone)).getOutput();
    }

    @Override
    public int readAsync() {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return -1;
            }
            return -2;
        }
        int c = this.buffer[s.pos++] & 0xFF;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return c;
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, buffer, ondone));
    }

    @Override
    public long skipSync(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long nb = 0L;
        while (n > 0L) {
            int l;
            AtomicState s = this.state;
            if (s.pos == s.len) {
                if (s.eof) {
                    return nb;
                }
                this.waitBufferSync();
            }
            if ((long)(l = this.state.len - this.state.pos) > n) {
                l = (int)n;
            }
            AtomicState atomicState = this.state;
            atomicState.pos = atomicState.pos + l;
            nb += (long)l;
            n -= (long)l;
            if (this.state.pos != this.state.len) continue;
            this.fillNextBuffer();
        }
        return nb;
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.skipAsyncByReading(this, n, ondone));
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return this.io.getTaskManager();
    }

    @Override
    public int read() throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return -1;
            }
            this.waitBufferSync();
            return this.read();
        }
        int c = this.buffer[s.pos++] & 0xFF;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return c;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        AtomicState s = this.state;
        if (s.pos == s.len) {
            if (s.eof) {
                return 0;
            }
            this.waitBufferSync();
            return this.read(buffer, offset, len);
        }
        int l = len;
        if (l > s.len - s.pos) {
            l = s.len - s.pos;
        }
        System.arraycopy(this.buffer, s.pos, buffer, offset, l);
        AtomicState atomicState = s;
        atomicState.pos = atomicState.pos + l;
        if (s.pos == s.len) {
            this.fillNextBuffer();
        }
        return l;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return IOUtil.readFully(this, ByteBuffer.wrap(buffer));
    }

    @Override
    public int skip(int skip) throws IOException {
        return (int)this.skipSync(skip);
    }

    @Override
    public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        AtomicState s = this.state;
        if (s.pos == s.len && s.eof) {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(null, null));
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        Task.Cpu<ByteBuffer, IOException> task = new Task.Cpu<ByteBuffer, IOException>("Read next buffer", this.getPriority(), ondone){

            @Override
            public ByteBuffer run() throws IOException, CancelException {
                if (SingleBufferReadable.this.reading.hasError()) {
                    throw (IOException)SingleBufferReadable.this.reading.getError();
                }
                if (SingleBufferReadable.this.reading.isCancelled()) {
                    throw SingleBufferReadable.this.reading.getCancelEvent();
                }
                AtomicState s = SingleBufferReadable.this.state;
                if (s.pos == s.len && s.eof) {
                    return null;
                }
                ByteBuffer buf = ByteBuffer.allocate(s.len - s.pos);
                buf.put(SingleBufferReadable.this.buffer, s.pos, s.len - s.pos);
                s.pos = s.len;
                SingleBufferReadable.this.fillNextBuffer();
                buf.flip();
                return buf;
            }
        };
        ((Task.Cpu)this.operation(task)).startOn(this.reading, true);
        return task.getOutput();
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        if (!this.reading.isUnblocked()) {
            this.reading.cancel(new CancelException("IO closed"));
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.buffer = null;
        this.io = null;
        ondone.unblock();
    }

    private static class AtomicState {
        private int len;
        private int pos;
        private boolean eof;

        private AtomicState() {
        }
    }
}

