/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class TwoBuffersIO
extends ConcurrentCloseable
implements IO.Readable.Buffered,
IO.Readable.Seekable,
IO.KnownSize {
    private IO.Readable io;
    protected byte[] buf1;
    protected byte[] buf2;
    private int nb1 = -1;
    private int nb2 = -1;
    private AsyncWork<Integer, IOException> read1;
    private AsyncWork<Integer, IOException> read2;
    protected int pos = 0;

    public TwoBuffersIO(final IO.Readable io, int firstBuffer, int secondBuffer) {
        this.io = io;
        this.buf1 = new byte[firstBuffer];
        this.read1 = io.readFullyAsync(ByteBuffer.wrap(this.buf1));
        this.operation(this.read1);
        if (secondBuffer > 0) {
            this.buf2 = new byte[secondBuffer];
            this.read1.listenInline(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    if (!TwoBuffersIO.this.read1.isSuccessful()) return;
                    int nb = (Integer)TwoBuffersIO.this.read1.getResult();
                    TwoBuffersIO.this.nb1 = nb > 0 ? nb : 0;
                    if (nb < TwoBuffersIO.this.buf1.length) {
                        TwoBuffersIO.this.buf2 = null;
                        TwoBuffersIO.this.nb2 = 0;
                        TwoBuffersIO.this.read2 = new AsyncWork<Integer, Object>(0, null);
                    } else {
                        TwoBuffersIO.this.operation(TwoBuffersIO.this.read2 = io.readFullyAsync(ByteBuffer.wrap(TwoBuffersIO.this.buf2)));
                    }
                    byte[] byArray = TwoBuffersIO.this.buf1;
                    synchronized (TwoBuffersIO.this.buf1) {
                        TwoBuffersIO.this.buf1.notifyAll();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                }
            });
        }
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.io = null;
        this.buf1 = null;
        this.buf2 = null;
        ondone.unblock();
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        if (this.nb1 < 0 || this.pos < this.nb1 || this.buf2 == null) {
            return this.read1;
        }
        if (this.read2 == null) {
            this.waitRead2();
        }
        return this.read2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitRead2() {
        byte[] byArray = this.buf1;
        synchronized (this.buf1) {
            while (this.read2 == null) {
                try {
                    this.buf1.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void needRead1() throws IOException {
        if (!this.read1.isUnblocked()) {
            this.read1.block(0L);
        }
        if (!this.read1.isSuccessful()) {
            if (this.read1.isCancelled()) {
                throw new IOException("Cancelled", this.read1.getCancelEvent());
            }
            throw this.read1.getError();
        }
        this.nb1 = this.read1.getResult();
        if (this.nb1 < 0) {
            this.nb1 = 0;
        }
    }

    private void needRead2() throws IOException {
        if (this.read2 == null) {
            this.waitRead2();
        }
        if (!this.read2.isUnblocked()) {
            this.read2.block(0L);
        }
        if (!this.read2.isSuccessful()) {
            if (this.read2.isCancelled()) {
                throw new IOException("Cancelled", this.read2.getCancelEvent());
            }
            throw this.read2.getError();
        }
        this.nb2 = this.read2.getResult();
        if (this.nb2 < 0) {
            this.nb2 = 0;
        }
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public long getPosition() {
        return this.pos;
    }

    @Override
    public int read() throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        if (this.pos < this.nb1) {
            return this.buf1[this.pos++] & 0xFF;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return -1;
        }
        return this.buf2[this.pos++ - this.nb1] & 0xFF;
    }

    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        if (this.pos < this.nb1) {
            int l = this.nb1 - this.pos;
            if (l > len) {
                l = len;
            }
            System.arraycopy(this.buf1, this.pos, buffer, offset, l);
            this.pos += l;
            return l;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return -1;
        }
        int l = this.nb1 + this.nb2 - this.pos;
        if (l > len) {
            l = len;
        }
        System.arraycopy(this.buf2, this.pos - this.nb1, buffer, offset, l);
        this.pos += l;
        return l;
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        int l;
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int len = buffer.length;
        int offset = 0;
        int done = 0;
        if (this.pos < this.nb1) {
            l = this.nb1 - this.pos;
            if (l > len) {
                l = len;
            }
            System.arraycopy(this.buf1, this.pos, buffer, 0, l);
            this.pos += l;
            if (l == len) {
                return l;
            }
            offset += l;
            len -= l;
            done = l;
        }
        if (this.buf2 == null) {
            return done > 0 ? done : -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return done > 0 ? done : -1;
        }
        l = this.nb1 + this.nb2 - this.pos;
        if (l > len) {
            l = len;
        }
        System.arraycopy(this.buf2, this.pos - this.nb1, buffer, offset, l);
        this.pos += l;
        return l + done;
    }

    @Override
    public int readSync(ByteBuffer buffer) throws IOException {
        return this.readSync(this.pos, buffer);
    }

    @Override
    public int readSync(long pos, ByteBuffer buffer) throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int len = buffer.remaining();
        if (pos < (long)this.nb1) {
            int l = this.nb1 - (int)pos;
            if (l > len) {
                l = len;
            }
            buffer.put(this.buf1, (int)pos, l);
            this.pos = (int)pos + l;
            return l;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (pos >= (long)(this.nb1 + this.nb2)) {
            return -1;
        }
        int l = this.nb1 + this.nb2 - (int)pos;
        if (l > len) {
            l = len;
        }
        buffer.put(this.buf2, (int)pos - this.nb1, l);
        this.pos = (int)pos + l;
        return l;
    }

    private <T> AsyncWork<T, IOException> needRead1Async(final Callable<T> onReady, final RunnableWithParameter<Pair<T, IOException>> ondone) {
        if (!this.read1.isUnblocked()) {
            final AsyncWork sp = new AsyncWork();
            this.read1.listenAsync(new Task.Cpu<Void, NoException>("TwoBuffersIO", this.io.getPriority()){

                @Override
                public Void run() {
                    if (TwoBuffersIO.this.read1.isSuccessful()) {
                        try {
                            Object r = onReady.call();
                            if (ondone != null) {
                                ondone.run(new Pair(r, null));
                            }
                            sp.unblockSuccess(r);
                        }
                        catch (Exception e) {
                            IOException err = IO.error(e);
                            if (ondone != null) {
                                ondone.run(new Pair<Object, IOException>(null, err));
                            }
                            sp.unblockError(err);
                        }
                    } else if (TwoBuffersIO.this.read1.isCancelled()) {
                        sp.unblockCancel(TwoBuffersIO.this.read1.getCancelEvent());
                    } else {
                        if (ondone != null) {
                            ondone.run(new Pair(null, TwoBuffersIO.this.read1.getError()));
                        }
                        sp.unblockError(TwoBuffersIO.this.read1.getError());
                    }
                    return null;
                }
            }, true);
            return this.operation(sp);
        }
        if (!this.read1.isSuccessful()) {
            IOException e = this.read1.isCancelled() ? new IOException("Cancelled", this.read1.getCancelEvent()) : this.read1.getError();
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, e));
            }
            return new AsyncWork<Object, IOException>(null, e);
        }
        this.nb1 = this.read1.getResult();
        if (this.nb1 < 0) {
            this.nb1 = 0;
        }
        return null;
    }

    private <T> AsyncWork<T, IOException> needRead2Async(final Callable<T> onReady, final RunnableWithParameter<Pair<T, IOException>> ondone) {
        if (!this.read1.isUnblocked() || this.read2 == null) {
            final AsyncWork sp = new AsyncWork();
            this.read1.listenAsync(this.operation(new Task.Cpu<Void, NoException>("TwoBuffersIO", this.io.getPriority()){

                @Override
                public Void run() {
                    if (TwoBuffersIO.this.read1.isSuccessful()) {
                        try {
                            Object r = onReady.call();
                            if (ondone != null) {
                                ondone.run(new Pair(r, null));
                            }
                            sp.unblockSuccess(r);
                        }
                        catch (Exception e) {
                            IOException err = IO.error(e);
                            if (ondone != null) {
                                ondone.run(new Pair<Object, IOException>(null, err));
                            }
                            sp.unblockError(err);
                        }
                    } else if (TwoBuffersIO.this.read1.isCancelled()) {
                        sp.unblockCancel(TwoBuffersIO.this.read1.getCancelEvent());
                    } else {
                        if (ondone != null) {
                            ondone.run(new Pair(null, TwoBuffersIO.this.read1.getError()));
                        }
                        sp.unblockError(TwoBuffersIO.this.read1.getError());
                    }
                    return null;
                }
            }), true);
            return sp;
        }
        if (!this.read2.isUnblocked()) {
            final AsyncWork sp = new AsyncWork();
            this.read2.listenAsync(this.operation(new Task.Cpu<Void, NoException>("TwoBuffersIO", this.io.getPriority()){

                @Override
                public Void run() {
                    if (TwoBuffersIO.this.read2.isSuccessful()) {
                        try {
                            Object r = onReady.call();
                            if (ondone != null) {
                                ondone.run(new Pair(r, null));
                            }
                            sp.unblockSuccess(r);
                        }
                        catch (Exception e) {
                            IOException err = IO.error(e);
                            if (ondone != null) {
                                ondone.run(new Pair<Object, IOException>(null, err));
                            }
                            sp.unblockError(err);
                        }
                    } else if (TwoBuffersIO.this.read2.isCancelled()) {
                        sp.unblockCancel(TwoBuffersIO.this.read2.getCancelEvent());
                    } else {
                        if (ondone != null) {
                            ondone.run(new Pair(null, TwoBuffersIO.this.read2.getError()));
                        }
                        sp.unblockError(TwoBuffersIO.this.read2.getError());
                    }
                    return null;
                }
            }), true);
            return sp;
        }
        if (!this.read2.isSuccessful()) {
            IOException e = this.read2.isCancelled() ? new IOException("Cancelled", this.read2.getCancelEvent()) : this.read2.getError();
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, e));
            }
            return new AsyncWork<Object, IOException>(null, e);
        }
        this.nb2 = this.read2.getResult();
        if (this.nb2 < 0) {
            this.nb2 = 0;
        }
        return null;
    }

    @Override
    public int readAsync() throws IOException {
        if (this.nb1 < 0) {
            if (!this.read1.isUnblocked()) {
                return -2;
            }
            this.needRead1();
        }
        if (this.pos < this.nb1) {
            return this.buf1[this.pos++] & 0xFF;
        }
        if (this.buf2 == null) {
            return -1;
        }
        if (this.nb2 < 0) {
            if (this.read2 == null) {
                this.waitRead2();
            }
            if (!this.read2.isUnblocked()) {
                return -2;
            }
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return -1;
        }
        return this.buf2[this.pos++ - this.nb1] & 0xFF;
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.readAsync(this.pos, buffer, ondone);
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(final long pos, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> res;
        AsyncWork<Integer, IOException> res2;
        if (this.nb1 < 0 && (res2 = this.needRead1Async(() -> {
            if (this.nb1 == 0) {
                return -1;
            }
            return this.readSync(pos, buffer);
        }, ondone)) != null) {
            return res2;
        }
        final int len = buffer.remaining();
        if (pos < (long)this.nb1) {
            Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on FullyBufferedIO", this.getPriority(), ondone){

                @Override
                public Integer run() {
                    int l = TwoBuffersIO.this.nb1 - (int)pos;
                    if (l > len) {
                        l = len;
                    }
                    buffer.put(TwoBuffersIO.this.buf1, (int)pos, l);
                    TwoBuffersIO.this.pos = (int)pos + l;
                    return l;
                }
            };
            this.operation(task).start();
            return task.getOutput();
        }
        if (this.buf2 == null) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(-1, null));
            }
            return new AsyncWork<Integer, Object>(-1, null);
        }
        if (this.nb2 < 0 && (res = this.needRead2Async(() -> this.readSync(pos, buffer), ondone)) != null) {
            return res;
        }
        if (pos >= (long)(this.nb1 + this.nb2)) {
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>(-1, null));
            }
            return new AsyncWork<Integer, Object>(-1, null);
        }
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("readAsync on TwoBuffersIO", this.getPriority(), ondone){

            @Override
            public Integer run() {
                int l = TwoBuffersIO.this.nb1 + TwoBuffersIO.this.nb2 - (int)pos;
                if (l > len) {
                    l = len;
                }
                buffer.put(TwoBuffersIO.this.buf2, (int)pos - TwoBuffersIO.this.nb1, l);
                TwoBuffersIO.this.pos = (int)pos + l;
                return l;
            }
        };
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        Task.Cpu<ByteBuffer, IOException> task = new Task.Cpu<ByteBuffer, IOException>("Read next buffer", this.getPriority(), ondone){

            @Override
            public ByteBuffer run() throws IOException {
                if (TwoBuffersIO.this.nb1 < 0) {
                    if (TwoBuffersIO.this.read1.hasError()) {
                        throw (IOException)TwoBuffersIO.this.read1.getError();
                    }
                    if (TwoBuffersIO.this.read1.isCancelled()) {
                        throw new IOException("Cancelled", TwoBuffersIO.this.read1.getCancelEvent());
                    }
                    TwoBuffersIO.this.nb1 = (Integer)TwoBuffersIO.this.read1.getResult();
                    if (TwoBuffersIO.this.nb1 < 0) {
                        TwoBuffersIO.this.nb1 = 0;
                    }
                    if (TwoBuffersIO.this.nb1 == 0) {
                        return null;
                    }
                }
                if (TwoBuffersIO.this.pos < TwoBuffersIO.this.nb1) {
                    ByteBuffer buf = ByteBuffer.allocate(TwoBuffersIO.this.nb1 - TwoBuffersIO.this.pos);
                    buf.put(TwoBuffersIO.this.buf1, TwoBuffersIO.this.pos, TwoBuffersIO.this.nb1 - TwoBuffersIO.this.pos);
                    buf.flip();
                    TwoBuffersIO.this.pos = TwoBuffersIO.this.nb1;
                    return buf;
                }
                if (TwoBuffersIO.this.buf2 == null) {
                    return null;
                }
                if (TwoBuffersIO.this.nb2 < 0) {
                    if (TwoBuffersIO.this.read1.hasError()) {
                        throw (IOException)TwoBuffersIO.this.read1.getError();
                    }
                    if (TwoBuffersIO.this.read1.isCancelled()) {
                        throw new IOException("Cancelled", TwoBuffersIO.this.read1.getCancelEvent());
                    }
                    if (TwoBuffersIO.this.read2 == null) {
                        TwoBuffersIO.this.waitRead2();
                    }
                    if (TwoBuffersIO.this.read2.hasError()) {
                        throw (IOException)TwoBuffersIO.this.read2.getError();
                    }
                    if (TwoBuffersIO.this.read2.isCancelled()) {
                        throw new IOException("Cancelled", TwoBuffersIO.this.read2.getCancelEvent());
                    }
                    TwoBuffersIO.this.nb2 = (Integer)TwoBuffersIO.this.read2.getResult();
                    if (TwoBuffersIO.this.nb2 < 0) {
                        TwoBuffersIO.this.nb2 = 0;
                    }
                    if (TwoBuffersIO.this.nb2 == 0) {
                        return null;
                    }
                }
                if (TwoBuffersIO.this.pos >= TwoBuffersIO.this.nb1 + TwoBuffersIO.this.nb2) {
                    return null;
                }
                ByteBuffer buf = ByteBuffer.allocate(TwoBuffersIO.this.nb1 + TwoBuffersIO.this.nb2 - TwoBuffersIO.this.pos);
                if (TwoBuffersIO.this.pos < TwoBuffersIO.this.nb1) {
                    buf.put(TwoBuffersIO.this.buf1, TwoBuffersIO.this.pos, TwoBuffersIO.this.nb1 - TwoBuffersIO.this.pos);
                }
                buf.put(TwoBuffersIO.this.buf2, TwoBuffersIO.this.pos - TwoBuffersIO.this.nb1, TwoBuffersIO.this.nb2 - (TwoBuffersIO.this.pos - TwoBuffersIO.this.nb1));
                buf.flip();
                TwoBuffersIO.this.pos = TwoBuffersIO.this.nb1 + TwoBuffersIO.this.nb2;
                return buf;
            }
        };
        if (this.nb1 < 0) {
            if (!this.read1.isUnblocked()) {
                this.read1.listenAsync(task, true);
                return ((Task.Cpu)this.operation(task)).getOutput();
            }
            if (this.read1.hasError()) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, this.read1.getError()));
                }
                return new AsyncWork<Object, IOException>(null, this.read1.getError());
            }
            if (this.read1.isCancelled()) {
                return new AsyncWork<Object, Object>(null, null, this.read1.getCancelEvent());
            }
            this.nb1 = this.read1.getResult();
            if (this.nb1 < 0) {
                this.nb1 = 0;
            }
            if (this.nb1 == 0) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, Object>(null, null));
                }
                return new AsyncWork<Object, Object>(null, null);
            }
        }
        if (this.pos < this.nb1) {
            this.operation(task.start());
            return task.getOutput();
        }
        if (this.buf2 == null) {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(null, null));
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        if (this.nb2 < 0) {
            if (!this.read1.isUnblocked()) {
                this.read1.listenAsync(task, true);
                return ((Task.Cpu)this.operation(task)).getOutput();
            }
            if (this.read1.hasError()) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, this.read1.getError()));
                }
                return new AsyncWork<Object, IOException>(null, this.read1.getError());
            }
            if (this.read1.isCancelled()) {
                return new AsyncWork<Object, Object>(null, null, this.read1.getCancelEvent());
            }
            if (this.read2 == null) {
                this.operation(task.start());
                return task.getOutput();
            }
            if (!this.read2.isUnblocked()) {
                this.read2.listenAsync(task, true);
                return ((Task.Cpu)this.operation(task)).getOutput();
            }
            if (this.read2.hasError()) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, this.read2.getError()));
                }
                return new AsyncWork<Object, IOException>(null, this.read2.getError());
            }
            if (this.read2.isCancelled()) {
                return new AsyncWork<Object, Object>(null, null, this.read2.getCancelEvent());
            }
            this.nb2 = this.read2.getResult();
            if (this.nb2 < 0) {
                this.nb2 = 0;
            }
            if (this.nb2 == 0) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, Object>(null, null));
                }
                return new AsyncWork<Object, Object>(null, null);
            }
        }
        if (this.pos >= this.nb1 + this.nb2) {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(null, null));
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        this.operation(task.start());
        return task.getOutput();
    }

    @Override
    public int readFullySync(ByteBuffer buffer) throws IOException {
        return this.readFullySync(this.pos, buffer);
    }

    @Override
    public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        int l;
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int len = buffer.remaining();
        int done = 0;
        if (pos < (long)this.nb1) {
            l = this.nb1 - (int)pos;
            if (l > len) {
                l = len;
            }
            buffer.put(this.buf1, (int)pos, l);
            this.pos = (int)pos + l;
            if (l == len) {
                return l;
            }
            pos += (long)l;
            len -= l;
            done = l;
        }
        if (this.buf2 == null) {
            return done > 0 ? done : -1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (pos >= (long)(this.nb1 + this.nb2)) {
            return done > 0 ? done : -1;
        }
        l = this.nb1 + this.nb2 - (int)pos;
        if (l > len) {
            l = len;
        }
        buffer.put(this.buf2, (int)pos - this.nb1, l);
        this.pos = (int)pos + l;
        return l + done;
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync((IO.Readable)this, buffer, 0, ondone));
    }

    @Override
    public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync(this, pos, buffer, ondone));
    }

    @Override
    public long skipSync(long n) throws IOException {
        return this.skip((int)n);
    }

    @Override
    public int skip(int skip) throws IOException {
        if (skip == 0) {
            return 0;
        }
        if (skip < 0) {
            if (-skip > this.pos) {
                skip = -this.pos;
            }
            this.pos += skip;
            return skip;
        }
        if (this.nb1 < 0) {
            this.needRead1();
        }
        int done = 0;
        if (this.pos < this.nb1) {
            if (this.pos + skip <= this.nb1) {
                this.pos += skip;
                return skip;
            }
            done = this.nb1 - this.pos;
            this.pos = this.nb1;
            skip -= done;
        }
        if (this.buf2 == null) {
            return done;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        if (this.pos >= this.nb1 + this.nb2) {
            return done;
        }
        if (this.pos + skip <= this.nb1 + this.nb2) {
            this.pos += skip;
            return skip + done;
        }
        this.pos = this.nb1 + this.nb2;
        return done += this.nb1 + this.nb2 - this.pos;
    }

    @Override
    public AsyncWork<Long, IOException> skipAsync(long skip, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        long d;
        long s;
        AsyncWork<Long, IOException> res;
        long s2;
        AsyncWork<Long, IOException> res2;
        if (skip < 0L) {
            if (-skip > (long)this.pos) {
                skip = -this.pos;
            }
            this.pos = (int)((long)this.pos + skip);
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(skip, null));
            }
            return new AsyncWork<Long, Object>(skip, null);
        }
        if (skip == 0L) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            return new AsyncWork<Long, Object>(0L, null);
        }
        if (this.nb1 < 0 && (res2 = this.needRead1Async(() -> this.lambda$skipAsync$2(s2 = skip), ondone)) != null) {
            return res2;
        }
        int done = 0;
        if (this.pos < this.nb1) {
            if ((long)this.pos + skip <= (long)this.nb1) {
                this.pos = (int)((long)this.pos + skip);
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(skip, null));
                }
                return new AsyncWork<Long, Object>(skip, null);
            }
            done = this.nb1 - this.pos;
            this.pos = this.nb1;
            skip -= (long)done;
        }
        if (this.buf2 == null) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(Long.valueOf(done), null));
            }
            return new AsyncWork<Long, Object>(Long.valueOf(done), null);
        }
        if (this.nb2 < 0 && (res = this.needRead2Async(() -> this.lambda$skipAsync$3(s = skip, d = (long)done), ondone)) != null) {
            return res;
        }
        if (this.pos >= this.nb1 + this.nb2) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(Long.valueOf(done), null));
            }
            return new AsyncWork<Long, Object>(Long.valueOf(done), null);
        }
        if ((long)this.pos + skip <= (long)(this.nb1 + this.nb2)) {
            this.pos = (int)((long)this.pos + skip);
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(skip + (long)done, null));
            }
            return new AsyncWork<Long, Object>(skip + (long)done, null);
        }
        done += this.nb1 + this.nb2 - this.pos;
        this.pos = this.nb1 + this.nb2;
        if (ondone != null) {
            ondone.run(new Pair<Long, Object>(Long.valueOf(done), null));
        }
        return new AsyncWork<Long, Object>(Long.valueOf(done), null);
    }

    @Override
    public long getSizeSync() throws IOException {
        if (this.nb1 < 0) {
            this.needRead1();
        }
        if (this.buf2 == null) {
            return this.nb1;
        }
        if (this.nb2 < 0) {
            this.needRead2();
        }
        return this.nb1 + this.nb2;
    }

    @Override
    public AsyncWork<Long, IOException> getSizeAsync() {
        AsyncWork<Long, IOException> res;
        if (this.nb1 < 0 && (res = this.needRead1Async(() -> this.getSizeSync(), null)) != null) {
            return res;
        }
        if (this.buf2 == null) {
            return new AsyncWork<Long, Object>(Long.valueOf(this.nb1), null);
        }
        if (this.nb2 < 0 && (res = this.needRead2Async(() -> this.getSizeSync(), null)) != null) {
            return res;
        }
        return new AsyncWork<Long, Object>(Long.valueOf(this.nb1 + this.nb2), null);
    }

    @Override
    public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_CURRENT: {
                this.skipSync(move);
                return this.pos;
            }
            case FROM_BEGINNING: {
                this.pos = 0;
                this.skipSync(move);
                return this.pos;
            }
            case FROM_END: {
                this.pos = (int)this.getSizeSync();
                this.skipSync(-move);
                return this.pos;
            }
        }
        return 0L;
    }

    @Override
    public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.seekAsyncUsingSync(this, type, move, ondone)).getOutput();
    }

    private /* synthetic */ Long lambda$skipAsync$3(long s, long d) throws Exception {
        return this.skipSync(s) + d;
    }

    private /* synthetic */ Long lambda$skipAsync$2(long s) throws Exception {
        if (this.nb1 == 0) {
            return 0L;
        }
        return this.skipSync(s);
    }

    public static class DeterminedSize
    extends TwoBuffersIO
    implements IO.KnownSize {
        public DeterminedSize(IO.Readable io, int firstBuffer, int secondBuffer) {
            super(io, firstBuffer, secondBuffer);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n) {
            return new AsyncWork<Long, Object>(Long.valueOf(this.skip((int)n)), null);
        }

        @Override
        public int skip(int skip) {
            if (skip == 0) {
                return 0;
            }
            if (skip < 0) {
                if (-skip > this.pos) {
                    skip = -this.pos;
                }
                this.pos += skip;
                return skip;
            }
            int max = this.buf1.length + (this.buf2 == null ? 0 : this.buf2.length);
            if (this.pos + skip > max) {
                skip = max - this.pos;
            }
            this.pos += skip;
            return skip;
        }

        @Override
        public long getSizeSync() {
            return this.buf1.length + (this.buf2 == null ? 0 : this.buf2.length);
        }

        @Override
        public AsyncWork<Long, IOException> getSizeAsync() {
            return new AsyncWork<Long, Object>(Long.valueOf(this.buf1.length + (this.buf2 == null ? 0 : this.buf2.length)), null);
        }

        @Override
        public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            try {
                Long r = this.seekSync(type, move);
                if (ondone != null) {
                    ondone.run(new Pair<Long, Object>(r, null));
                }
                return new AsyncWork<Long, Object>(r, null);
            }
            catch (IOException e) {
                if (ondone != null) {
                    ondone.run(new Pair<Object, IOException>(null, e));
                }
                return new AsyncWork<Object, IOException>(null, e);
            }
        }
    }
}

